/*
 * Decompiled with CFR 0.152.
 */
package com.partyhotkeys;

import com.google.inject.Provides;
import com.partyhotkeys.ConnectionIndicator;
import com.partyhotkeys.PartyHotkeysConfig;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDependency(value=PartyPlugin.class)
@PluginDescriptor(name="Party Hotkeys", description="Custom Hotkeys for rejoining previous party & joining preset party names", tags={"party,hotkeys"})
public class PartyHotkeysPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PartyHotkeysPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private PartyHotkeysConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PartyService partyService;
    @Inject
    private KeyManager keyManager;
    final String PARTY_CONFIG_GROUP = "party";
    final String PREVIOUS_PARTY_ID = "previousPartyId";
    boolean isInParty = false;
    Instant lastLeave = null;
    private final HotkeyListener previousKeyListener = new HotkeyListener(() -> this.config.rejoinPreviousKey()){

        public void hotkeyPressed() {
            PartyHotkeysPlugin.this.RejoinPreviousParty();
        }
    };
    private final HotkeyListener leavePartyKeyListener = new HotkeyListener(() -> this.config.leavePartyKey()){

        public void hotkeyPressed() {
            PartyHotkeysPlugin.this.LeaveParty();
        }
    };
    private final HotkeyListener joinParty1KeyListener = new HotkeyListener(() -> this.config.joinParty1Key()){

        public void hotkeyPressed() {
            PartyHotkeysPlugin.this.changeParty(PartyHotkeysPlugin.this.config.presetParty1());
        }
    };
    private final HotkeyListener joinParty2KeyListener = new HotkeyListener(() -> this.config.joinParty2Key()){

        public void hotkeyPressed() {
            PartyHotkeysPlugin.this.changeParty(PartyHotkeysPlugin.this.config.presetParty2());
        }
    };
    private final HotkeyListener joinParty3KeyListener = new HotkeyListener(() -> this.config.joinParty3Key()){

        public void hotkeyPressed() {
            PartyHotkeysPlugin.this.changeParty(PartyHotkeysPlugin.this.config.presetParty3());
        }
    };

    @Provides
    PartyHotkeysConfig provideConfig(ConfigManager configManager) {
        return (PartyHotkeysConfig)configManager.getConfig(PartyHotkeysConfig.class);
    }

    protected void startUp() throws Exception {
        this.CheckPartyStatus();
        this.keyManager.registerKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.leavePartyKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.joinParty1KeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.joinParty2KeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.joinParty3KeyListener);
    }

    protected void shutDown() throws Exception {
        this.RemoveInfobox();
        this.keyManager.unregisterKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.leavePartyKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.joinParty1KeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.joinParty2KeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.joinParty3KeyListener);
    }

    private void CreateInfobox() {
        this.RemoveInfobox();
        BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon_Disconnected.png");
        ConnectionIndicator infobox = new ConnectionIndicator(image, this, "You aren't in a party!");
        this.infoBoxManager.addInfoBox((InfoBox)infobox);
    }

    private void RemoveInfobox() {
        this.infoBoxManager.removeIf(t -> t instanceof ConnectionIndicator);
    }

    public void CheckPartyStatus() {
        boolean bl = this.isInParty = this.partyService != null && this.partyService.isInParty();
        if (this.config.disconnectedWarning()) {
            if (!this.isInParty) {
                this.CreateInfobox();
            } else {
                this.RemoveInfobox();
            }
        }
    }

    public void changeParty(String passphrase) {
        if (this.lastLeave != null && Duration.between(this.lastLeave, Instant.now()).getSeconds() <= 5L) {
            this.clientThread.invokeLater(() -> this.client.playSoundEffect(2266));
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        if (this.isInParty) {
            return;
        }
        if ((passphrase = passphrase.replace(" ", "-").trim()).length() == 0) {
            return;
        }
        for (int i = 0; i < passphrase.length(); ++i) {
            char ch = passphrase.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') continue;
            return;
        }
        this.partyService.changeParty(passphrase);
    }

    public void LeaveParty() {
        if (this.isInParty) {
            this.clientThread.invokeLater(() -> this.client.playSoundEffect(3930));
            this.partyService.changeParty(null);
            this.lastLeave = Instant.now();
        }
    }

    public void RejoinPreviousParty() {
        this.changeParty(this.getPreviousPartyId());
    }

    public String getPreviousPartyId() {
        return Optional.ofNullable(this.configManager.getConfiguration("party", "previousPartyId")).orElse("");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("partyhotkeys") && event.getKey().equals("disconnectedWarning")) {
            if (event.getNewValue().equals("false")) {
                this.RemoveInfobox();
            } else {
                this.CheckPartyStatus();
            }
        }
    }

    @Subscribe
    public void onPartyChanged(PartyChanged event) {
        this.CheckPartyStatus();
    }
}

