/*
 * Decompiled with CFR 0.152.
 */
package com.GuildSpamFilter;

import com.GuildSpamFilter.Configs.AchievementDiariesEnum;
import com.GuildSpamFilter.Configs.CombatDiariesEnum;
import com.GuildSpamFilter.GuildSpamFilterConfig;
import com.GuildSpamFilter.Handlers.CollectionLogHandler;
import com.GuildSpamFilter.Models.Categori;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Spam Filter", tags={"Spam filter", "Clan spam filter", "Spam", "Filter", "Guild Spam Filter", "Guild", "Clan"}, description="Remove broadcasts from clan chat")
public class GuildSpamFilterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GuildSpamFilterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GuildSpamFilterConfig config;
    private HashSet<String> pbsToIncludeOrExclude;
    private HashSet<String> customFilters;
    private HashSet<String> alwaysIncludedPlayerNames;
    private ArrayList<Categori> categoris;

    @Provides
    GuildSpamFilterConfig provideConfig(ConfigManager configManager) {
        return (GuildSpamFilterConfig)configManager.getConfig(GuildSpamFilterConfig.class);
    }

    protected void startUp() throws RuntimeException, IOException {
        log.info("Clan Spam Filter started!");
        this.pbsToIncludeOrExclude = new HashSet();
        this.customFilters = new HashSet();
        this.alwaysIncludedPlayerNames = new HashSet();
        CollectionLogHandler collectionLogHandler = new CollectionLogHandler();
        this.categoris = collectionLogHandler.ReadData();
        this.UpdatePbsToIncludeOrExclude();
        this.UpdateCustomFilters();
        this.UpdateAlwaysIncludedPlayerIgnsFromBroadcasts();
    }

    protected void shutDown() {
        log.info("Clan Spam Filter stopped!");
        this.pbsToIncludeOrExclude = null;
        this.customFilters = null;
        this.alwaysIncludedPlayerNames = null;
        this.categoris = null;
    }

    private void UpdatePbsToIncludeOrExclude() {
        this.pbsToIncludeOrExclude.clear();
        String[] values = this.config.pbsToIncludeOrExclude().split(",");
        if (values.length > 0) {
            for (String value : values) {
                if ((value = value.trim().toLowerCase()).length() <= 0) continue;
                this.pbsToIncludeOrExclude.add(value);
            }
        }
        log.debug("New list: " + String.join((CharSequence)", ", this.pbsToIncludeOrExclude));
    }

    private void UpdateCustomFilters() {
        this.customFilters.clear();
        String[] values = this.config.customFilters().split(",");
        if (values.length > 0) {
            for (String value : values) {
                if ((value = value.trim().toLowerCase()).length() <= 0) continue;
                this.customFilters.add(value);
            }
        }
        log.debug("New list: " + String.join((CharSequence)", ", this.customFilters));
    }

    private void UpdateAlwaysIncludedPlayerIgnsFromBroadcasts() {
        this.alwaysIncludedPlayerNames.clear();
        String[] values = this.config.excludedPlayerNames().split(",");
        if (values.length > 0) {
            for (String value : values) {
                if ((value = value.trim().toLowerCase()).length() <= 0) continue;
                this.alwaysIncludedPlayerNames.add(value);
            }
        }
        log.debug("New list: " + String.join((CharSequence)", ", this.alwaysIncludedPlayerNames));
    }

    private boolean isBroadcastMessageForPlayer(String playerName, String broadcastMessage) {
        for (int i = 0; i < playerName.length(); ++i) {
            char currentBroadcastMessageChar;
            char currentPlayerChar = playerName.charAt(i);
            if (currentPlayerChar == (currentBroadcastMessageChar = broadcastMessage.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals("pbsToIncludeOrExclude")) {
            this.UpdatePbsToIncludeOrExclude();
        } else if (event.getKey().equals("customFilters")) {
            this.UpdateCustomFilters();
        } else if (event.getKey().equals("excludedPlayerNames")) {
            this.UpdateAlwaysIncludedPlayerIgnsFromBroadcasts();
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        String part;
        String part2;
        if (!event.getEventName().equals("chatFilterCheck")) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        if (intStack.length < intStackSize - 3 || stringStack.length < stringStackSize - 1) {
            return;
        }
        int messageType = intStack[intStackSize - 2];
        ChatMessageType chatMessageType = ChatMessageType.of((int)messageType);
        if (chatMessageType != ChatMessageType.CLAN_MESSAGE) {
            return;
        }
        String message = stringStack[stringStackSize - 1].trim();
        log.debug("Broadcast message: " + message);
        if (this.alwaysIncludedPlayerNames.size() > 0) {
            String lowercaseBroadcastMessage = message.toLowerCase();
            for (String playerName : this.alwaysIncludedPlayerNames) {
                if (!this.isBroadcastMessageForPlayer(playerName, lowercaseBroadcastMessage)) continue;
                log.debug("New broadcast for player detected skipping it.. Player name was: " + playerName);
                return;
            }
        }
        if (this.config.filterPb() && message.contains("has achieved a new")) {
            log.debug("New PB detected.. Mode was set to: " + this.config.pbToIncludeOrExcludeEnum());
            String partWithoutPlayerName = message.substring(12);
            String lowercaseMessage = partWithoutPlayerName.toLowerCase();
            switch (this.config.pbToIncludeOrExcludeEnum()) {
                case EXCLUDE_ALL_EXCEPT: {
                    boolean found = false;
                    if (this.pbsToIncludeOrExclude.size() > 0) {
                        for (String text : this.pbsToIncludeOrExclude) {
                            if (!lowercaseMessage.contains(text)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) break;
                    log.debug("No match found removing it..");
                    intStack[intStackSize - 3] = 0;
                    return;
                }
                case INCLUDE_ALL_EXCEPT: {
                    boolean found = false;
                    if (this.pbsToIncludeOrExclude.size() > 0) {
                        for (String text : this.pbsToIncludeOrExclude) {
                            if (!lowercaseMessage.contains(text)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) break;
                    log.debug("Match found removing it..");
                    intStack[intStackSize - 3] = 0;
                    return;
                }
            }
        } else if (this.config.filterRaidDrop() && message.contains("received special loot")) {
            log.debug("New raid loot detected..");
            int index = message.lastIndexOf("(");
            int index2 = message.lastIndexOf(")");
            if (index != -1 && index2 != -1) {
                part2 = message.substring(index + 1, index2).replace(",", "").replace("coins", "").trim();
                long gpValue = Long.parseLong(part2);
                if (gpValue < (long)this.config.raidLootGpThreshold() || gpValue == Integer.MAX_VALUE && gpValue == (long)this.config.raidLootGpThreshold()) {
                    log.debug("Raid loot was below threshold: " + gpValue + " removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("Raid loot could not find value of item but we still remove it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterRegularDrops() && message.contains("received a drop")) {
            log.debug("New drop detected..");
            int index = message.indexOf("(");
            int index2 = message.indexOf(")");
            if (index != -1 && index2 != -1) {
                part2 = message.substring(index + 1, index2).replace(",", "").replace("coins", "").trim();
                long gpValue = Long.parseLong(part2);
                if (gpValue < (long)this.config.lootGpThreshold() || gpValue == Integer.MAX_VALUE && gpValue == (long)this.config.lootGpThreshold()) {
                    log.debug("Loot was below threshold: " + gpValue + " removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("Loot detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterPets() && (message.contains("has a funny feeling") || message.contains("acquired something special"))) {
            log.debug("New pet detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterMaxTotal() && message.contains("has reached the highest possible total level of")) {
            log.debug("New max total detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterTotalLevelMilestone() && message.contains("has reached a total")) {
            log.debug("New total level detected removing it..");
            String textToFind = "total level of ";
            int index = message.indexOf(textToFind);
            if (index != -1) {
                part2 = message.substring(index + textToFind.length(), message.length() - 1);
                long totalLevel = Long.parseLong(part2);
                if (totalLevel < (long)this.config.totalLevelThreshold()) {
                    log.debug("Total level was below threshold: " + totalLevel + " removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("Total level detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterXpMilestone() && message.contains("XP in")) {
            log.debug("New XP milestone detected..");
            int index = message.indexOf("reached");
            int index2 = message.indexOf("XP in");
            if (index != -1 && index2 != -1) {
                part2 = message.substring(index + 8, index2 - 1).replace(",", "");
                long xp = Long.parseLong(part2);
                if (xp < (long)this.config.xpMilestoneThreshold()) {
                    log.debug("XP milestone was below threshold: " + xp + " removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("XP milestone detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterLevelUp() && message.contains("has reached")) {
            log.debug("New level up detected..");
            int index = message.indexOf("level");
            if (index != -1) {
                part = message.substring(index + 6, message.length() - 1);
                long level = Long.parseLong(part);
                if (level < (long)this.config.levelThreshold()) {
                    log.debug("Level was below threshold: " + level + " removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("Level detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if ((this.config.filterCollectionLogBosses() || this.config.filterCollectionLogRaids() || this.config.filterCollectionLogClues() || this.config.filterCollectionLogMinigames() || this.config.filterCollectionLogOther() || this.config.enableCollectionLogThreshold()) && message.contains("a new collection log")) {
            int index = message.lastIndexOf("(");
            int index2 = message.lastIndexOf("/");
            if (index != -1 && index2 != -1) {
                part2 = message.substring(index + 1, index2).trim();
                int collectionLogs = Integer.parseInt(part2);
                if (this.config.enableCollectionLogThreshold() && this.config.filterCollectionLogThreshold() > collectionLogs) {
                    log.debug("Collection long amount was below threshold: " + collectionLogs + " removing it..");
                    intStack[intStackSize - 3] = 0;
                } else {
                    boolean isFound = false;
                    index = message.indexOf(":") + 1;
                    index2 = message.lastIndexOf("(");
                    part2 = message.substring(index, index2).trim();
                    for (Categori categori : this.categoris) {
                        switch (categori.name) {
                            case "Bosses": {
                                if (!this.config.filterCollectionLogBosses() || !categori.allItems.contains(part2)) break;
                                log.debug("New collection log item detected removing it..");
                                intStack[intStackSize - 3] = 0;
                                isFound = true;
                                break;
                            }
                            case "Raids": {
                                if (!this.config.filterCollectionLogRaids() || !categori.allItems.contains(part2)) break;
                                log.debug("New collection log item detected removing it..");
                                intStack[intStackSize - 3] = 0;
                                isFound = true;
                                break;
                            }
                            case "Clues": {
                                if (!this.config.filterCollectionLogClues() || !categori.allItems.contains(part2)) break;
                                log.debug("New collection log item detected removing it..");
                                intStack[intStackSize - 3] = 0;
                                isFound = true;
                                break;
                            }
                            case "Minigames": {
                                if (!this.config.filterCollectionLogMinigames() || !categori.allItems.contains(part2)) break;
                                log.debug("New collection log item detected removing it..");
                                intStack[intStackSize - 3] = 0;
                                isFound = true;
                                break;
                            }
                            case "Other": {
                                if (!this.config.filterCollectionLogOther() || !categori.allItems.contains(part2)) break;
                                log.debug("New collection log item detected removing it..");
                                intStack[intStackSize - 3] = 0;
                                isFound = true;
                            }
                        }
                        if (!isFound) continue;
                        break;
                    }
                }
            } else {
                log.debug("New collection log item detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterNewClanMember() && message.contains("has been invited into the")) {
            log.debug("New clan member detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterDefaultMessage() && message.contains("To talk in your")) {
            log.debug("New default message detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterRareDrops() && message.contains("received a rare drop")) {
            log.debug("New rare drop detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterQuestComplete() && message.contains("has completed a quest")) {
            log.debug("New quest completion detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterHardcoreDeath() && message.contains("and lost their hardcore")) {
            log.debug("New hardcore death detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterClanMemberKicked() && message.contains("has expelled")) {
            log.debug("New kicked clan member detected removing it..");
            intStack[intStackSize - 3] = 0;
        } else if (this.config.filterPlayerDied() && message.contains("has been defeated by")) {
            int left = message.indexOf("(");
            int right = message.indexOf(")");
            if (left != -1 && right != -1) {
                part2 = message.substring(left + 1, right - 6).replace(",", "");
                int value = Integer.parseInt(part2);
                if (value < this.config.playerDiedThreshold()) {
                    log.debug("New player has been defeated by another player detected removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("New player has been defeated by another player detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterPlayerKill() && message.contains("has defeated")) {
            int left = message.indexOf("(");
            int right = message.indexOf(")");
            if (left != -1 && right != -1) {
                part2 = message.substring(left + 1, right - 6).replace(",", "");
                int value = Integer.parseInt(part2);
                if (value < this.config.playerKillThreshold()) {
                    log.debug("New player has been defeated by another player detected removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("New player has been defeated by another player detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterCombatLevelUpMessage() && message.contains("combat level")) {
            boolean isMaxCombatMessage = message.contains("highest possible combat level");
            if (isMaxCombatMessage) {
                if (this.config.filterCCombatLevelUpThreshold() > 126) {
                    log.debug("New max combat level up message detected removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                int index = message.indexOf("combat level");
                if (index != -1) {
                    part2 = message.substring(index + 13);
                    String combatLevelStr = part2.substring(0, part2.length() - 1);
                    int combatLevel = Integer.parseInt(combatLevelStr);
                    if (this.config.filterCCombatLevelUpThreshold() > combatLevel) {
                        log.debug("New combat level up message detected removing it..");
                        intStack[intStackSize - 3] = 0;
                    }
                } else {
                    log.debug("New combat level up message detected removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            }
        } else if (this.config.filterCombatDiaries() && message.contains("Combat Achievement")) {
            log.debug("New combat achievement diaries detected..");
            int index = message.indexOf("the");
            if (index != -1) {
                part = message.substring(index + 4);
                int index2 = part.indexOf(" ");
                if (index2 != -1) {
                    String combatDiaryLevel = part.substring(0, index2);
                    if (this.config.combatDiariesThreshold() == CombatDiariesEnum.ALL) {
                        log.debug("Combat Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + combatDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.combatDiariesThreshold() == CombatDiariesEnum.GRANDMASTER && (combatDiaryLevel.equals(CombatDiariesEnum.MASTER.toString()) || combatDiaryLevel.equals(CombatDiariesEnum.ELITE.toString()) || combatDiaryLevel.equals(CombatDiariesEnum.HARD.toString()) || combatDiaryLevel.equals(CombatDiariesEnum.MEDIUM.toString()) || combatDiaryLevel.equals("Easy"))) {
                        log.debug("Combat Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + combatDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.combatDiariesThreshold() == CombatDiariesEnum.MASTER && (combatDiaryLevel.equals(CombatDiariesEnum.ELITE.toString()) || combatDiaryLevel.equals(CombatDiariesEnum.HARD.toString()) || combatDiaryLevel.equals(CombatDiariesEnum.MEDIUM.toString()) || combatDiaryLevel.equals("Easy"))) {
                        log.debug("Combat Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + combatDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.combatDiariesThreshold() == CombatDiariesEnum.ELITE && (combatDiaryLevel.equals(CombatDiariesEnum.HARD.toString()) || combatDiaryLevel.equals(CombatDiariesEnum.MEDIUM.toString()) || combatDiaryLevel.equals("Easy"))) {
                        log.debug("Combat Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + combatDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.combatDiariesThreshold() == CombatDiariesEnum.HARD && (combatDiaryLevel.equals(CombatDiariesEnum.MEDIUM.toString()) || combatDiaryLevel.equals("Easy"))) {
                        log.debug("Combat Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + combatDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.combatDiariesThreshold() == CombatDiariesEnum.MEDIUM && combatDiaryLevel.equals("Easy")) {
                        log.debug("Combat Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + combatDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    }
                } else {
                    log.debug("Combat Achievement Diaries detected removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("Combat Achievement Diaries detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        } else if (this.config.filterAchievementDiaries() && (message.contains("Easy") || message.contains(AchievementDiariesEnum.MEDIUM.toString()) || message.contains(AchievementDiariesEnum.HARD.toString()) || message.contains(AchievementDiariesEnum.ELITE.toString()))) {
            log.debug("New achievement diaries detected..");
            int index = message.indexOf("the");
            if (index != -1) {
                part = message.substring(index + 4);
                int index2 = part.indexOf(" ");
                if (index2 != -1) {
                    String achievementDiaryLevel = part.substring(0, index2);
                    if (this.config.achievementDiariesThreshold() == AchievementDiariesEnum.ALL) {
                        log.debug("Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + achievementDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.achievementDiariesThreshold() == AchievementDiariesEnum.ELITE && (achievementDiaryLevel.equals("Easy") || achievementDiaryLevel.equals(AchievementDiariesEnum.MEDIUM.toString()) || achievementDiaryLevel.equals(AchievementDiariesEnum.HARD.toString()))) {
                        log.debug("Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + achievementDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.achievementDiariesThreshold() == AchievementDiariesEnum.HARD && (achievementDiaryLevel.equals("Easy") || achievementDiaryLevel.equals(AchievementDiariesEnum.MEDIUM.toString()))) {
                        log.debug("Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + achievementDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    } else if (this.config.achievementDiariesThreshold() == AchievementDiariesEnum.MEDIUM && achievementDiaryLevel.equals("Easy")) {
                        log.debug("Achievement Diaries Threshold was set to: " + this.config.achievementDiariesThreshold() + "and diary was: " + achievementDiaryLevel + " removing it..");
                        intStack[intStackSize - 3] = 0;
                    }
                } else {
                    log.debug("Achievement Diaries detected removing it..");
                    intStack[intStackSize - 3] = 0;
                }
            } else {
                log.debug("Achievement Diaries detected removing it..");
                intStack[intStackSize - 3] = 0;
            }
        }
        if (this.customFilters.size() > 0) {
            log.debug("Custom filter was not empty scanning..");
            String lowercaseMessage = message.toLowerCase();
            boolean found = false;
            for (String text : this.customFilters) {
                if (!lowercaseMessage.contains(text)) continue;
                found = true;
                break;
            }
            if (found) {
                log.debug("Custom filter match found removing it..");
                intStack[intStackSize - 3] = 0;
            }
        }
        stringStack[stringStackSize - 1] = message;
    }
}

