/*
 * Decompiled with CFR 0.152.
 */
package com.GuildSpamFilter;

import com.GuildSpamFilter.Configs.AchievementDiariesEnum;
import com.GuildSpamFilter.Configs.CombatDiariesEnum;
import com.GuildSpamFilter.Configs.PersonalBestEnum;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="GuildSpamFilter")
public interface GuildSpamFilterConfig
extends Config {
    @ConfigSection(position=0, closedByDefault=false, name="General Filters", description="General broadcast filters")
    public static final String filterSectionGeneral = "General Filters";
    @ConfigSection(position=1, closedByDefault=true, name="Collection Log Filters", description="Collection Log broadcast filters")
    public static final String filterSectionCollectionLog = "Collection Log Filters";
    @ConfigSection(position=2, closedByDefault=true, name="Skilling Filters", description="Skilling broadcast filters")
    public static final String filterSectionSkilling = "Skilling Filters";
    @ConfigSection(position=3, closedByDefault=true, name="PvM Filters", description="PvM broadcast filters")
    public static final String filterSectionPvm = "PvM Filters";
    @ConfigSection(position=4, closedByDefault=true, name="PvP Filters", description="PvP broadcast filters")
    public static final String filterSectionPvp = "PvP Filters";
    @ConfigSection(position=5, closedByDefault=true, name="Miscellaneous", description="Miscellaneous")
    public static final String miscellaneous = "Miscellaneous";

    @ConfigItem(keyName="filterPb", name="Filter Personal Bests", description="Removes Personal Bests from clan broadcast", section="General Filters", position=0)
    default public boolean filterPb() {
        return false;
    }

    @ConfigItem(keyName="pbToIncludeOrExcludeEnum", name="PB Mode", description="Set which personal best mode. Include includes all PB's except the ones matching your comma separated list. Exclude does the reverse. (Default: Exclude all except)", section="General Filters", position=1)
    default public PersonalBestEnum pbToIncludeOrExcludeEnum() {
        return PersonalBestEnum.EXCLUDE_ALL_EXCEPT;
    }

    @ConfigItem(keyName="pbsToIncludeOrExclude", name="PB's to include or exclude based on PB Mode", description="Include/Exclude all except: Using comma separation e.g. 'Chambers of Xeric, Theatre of Blood' would include/exclude these PB's from Clan Broadcast (case insensitive)", section="General Filters", position=2)
    default public String pbsToIncludeOrExclude() {
        return "";
    }

    @ConfigItem(keyName="filterPets", name="Filter Pet Drops", description="Removes Pet Drops from clan broadcast", section="General Filters", position=3)
    default public boolean filterPets() {
        return false;
    }

    @ConfigItem(keyName="filterNewClanMember", name="Filter New Clan Members", description="Removes New Clan Members from clan broadcast", section="General Filters", position=4)
    default public boolean filterNewClanMember() {
        return false;
    }

    @ConfigItem(keyName="filterClanMemberKicked", name="Filter Kicked Clan Members", description="Removes Kicked Clan Members from clan broadcast", section="General Filters", position=5)
    default public boolean filterClanMemberKicked() {
        return false;
    }

    @ConfigItem(keyName="filterMemberLeftClan", name="Filter Members Who Leave", description="Removes Members Who Leave from clan broadcast", section="General Filters", position=6, hidden=true)
    default public boolean filterMemberLeftClan() {
        return false;
    }

    @ConfigItem(keyName="filterQuestComplete", name="Filter Quest Complete", description="Removes Quest Completions from clan broadcast", section="General Filters", position=7)
    default public boolean filterQuestComplete() {
        return false;
    }

    @ConfigItem(keyName="filterAchievementDiaries", name="Filter Achievement Diaries", description="Removes Achievement Diaries from clan broadcast", section="General Filters", position=8)
    default public boolean filterAchievementDiaries() {
        return false;
    }

    @ConfigItem(keyName="achievementDiariesThreshold", name="Achievement Diaries Threshold", description="Set minimum Achievement Diary threshold to filter broadcasts (Default: All)", section="General Filters", position=9)
    default public AchievementDiariesEnum achievementDiariesThreshold() {
        return AchievementDiariesEnum.ALL;
    }

    @ConfigItem(keyName="filterCombatDiaries", name="Filter Combat Diaries", description="Removes Combat Diaries from clan broadcast", section="General Filters", position=10)
    default public boolean filterCombatDiaries() {
        return false;
    }

    @ConfigItem(keyName="combatDiariesThreshold", name="Combat Diaries Threshold", description="Set minimum Combat Diary threshold to filter broadcasts (Default: All)", section="General Filters", position=11)
    default public CombatDiariesEnum combatDiariesThreshold() {
        return CombatDiariesEnum.ALL;
    }

    @ConfigItem(keyName="filterHardcoreDeath", name="Filter Hardcore Death", description="Removes Hardcore Deaths from clan broadcast", section="General Filters", position=12)
    default public boolean filterHardcoreDeath() {
        return false;
    }

    @ConfigItem(keyName="filterCombatLevelUpMessage", name="Filter Combat Level Up", description="Removes combat level ups from clan broadcast", section="General Filters", position=13)
    default public boolean filterCombatLevelUpMessage() {
        return false;
    }

    @ConfigItem(keyName="filterCCombatLevelUpThreshold", name="Combat Level Up Threshold", description="Set minimum Combat Level Up threshold to filter broadcasts (Default: 127)", section="General Filters", position=14)
    default public int filterCCombatLevelUpThreshold() {
        return 127;
    }

    @ConfigItem(keyName="filterDefaultMessage", name="Filter Default Message", description="Removes the default message when logging in from clan broadcast", section="General Filters", position=15)
    default public boolean filterDefaultMessage() {
        return false;
    }

    @ConfigItem(keyName="customFilters", name="Custom Filters", description="Using comma separation e.g. 'Chambers of Xeric, Theatre of Blood' if anything matches these search terms it would be removed from Clan Broadcast (case insensitive)", section="General Filters", position=16)
    default public String customFilters() {
        return "";
    }

    @ConfigItem(keyName="filterCollectionLogBosses", name="Filter Collection Log Boss Drops", description="Removes Collection Log Boss Drops from clan broadcast", section="Collection Log Filters", position=0)
    default public boolean filterCollectionLogBosses() {
        return false;
    }

    @ConfigItem(keyName="filterCollectionLogRaids", name="Filter Collection Log Raid Drops", description="Removes Collection Log Raid Drops from clan broadcast", section="Collection Log Filters", position=1)
    default public boolean filterCollectionLogRaids() {
        return false;
    }

    @ConfigItem(keyName="filterCollectionLogClues", name="Filter Collection Log Clue Drops", description="Removes Collection Log Clue Drops from clan broadcast", section="Collection Log Filters", position=2)
    default public boolean filterCollectionLogClues() {
        return false;
    }

    @ConfigItem(keyName="filterCollectionLogMinigames", name="Filter Collection Log Minigame Drops", description="Removes Collection Log Minigame Drops from clan broadcast", section="Collection Log Filters", position=3)
    default public boolean filterCollectionLogMinigames() {
        return false;
    }

    @ConfigItem(keyName="filterCollectionLogOther", name="Filter Collection Log Other Drops", description="Removes Collection Log Other Drops from clan broadcast", section="Collection Log Filters", position=4)
    default public boolean filterCollectionLogOther() {
        return false;
    }

    @ConfigItem(keyName="enableCollectionLogThreshold", name="Enable Collection Log Threshold", description="Enables collection log threshold", section="Collection Log Filters", position=5)
    default public boolean enableCollectionLogThreshold() {
        return false;
    }

    @ConfigItem(keyName="filterCollectionLogThreshold", name="Collection Log Threshold", description="Set minimum Collection Log gathered threshold to filter broadcasts (Default: 1444)", section="Collection Log Filters", position=6)
    default public int filterCollectionLogThreshold() {
        return 1444;
    }

    @ConfigItem(keyName="filterRaidDrop", name="Filter Raid Drops", description="Removes raid drops from clan broadcast", section="PvM Filters", position=0)
    default public boolean filterRaidDrop() {
        return false;
    }

    @ConfigItem(keyName="raidLootGpThreshold", name="Raid Loot GP Threshold", description="Set minimum Raid loot GP threshold to filter broadcasts (Default: 2,147,483,647)", section="PvM Filters", position=1)
    default public int raidLootGpThreshold() {
        return Integer.MAX_VALUE;
    }

    @ConfigItem(keyName="filterRegularDrops", name="Filter Regular Drops", description="Removes Regular Drops from clan broadcast", section="PvM Filters", position=2)
    default public boolean filterRegularDrops() {
        return false;
    }

    @ConfigItem(keyName="lootGpThreshold", name="Loot GP Threshold", description="Set minimum loot GP threshold to filter broadcasts (Default: 2,147,483,647)", section="PvM Filters", position=3)
    default public int lootGpThreshold() {
        return Integer.MAX_VALUE;
    }

    @ConfigItem(keyName="filterRareDrops", name="Filter Rare Drops", description="Removes Rare Drops from clan broadcast", section="PvM Filters", position=2)
    default public boolean filterRareDrops() {
        return false;
    }

    @ConfigItem(keyName="filterTotalLevelMilestone", name="Filter Total Level Milestones", description="Removes Total Level Milestones from clan broadcast", section="Skilling Filters", position=0)
    default public boolean filterTotalLevelMilestone() {
        return false;
    }

    @ConfigItem(keyName="totalLevelThreshold", name="Total Level Threshold", description="Set minimum Total Level threshold to filter broadcasts (Default: 2278)", section="Skilling Filters", position=1)
    default public int totalLevelThreshold() {
        return 2278;
    }

    @ConfigItem(keyName="filterLevelUp", name="Filter Level Ups", description="Removes Level Ups from clan broadcast", section="Skilling Filters", position=2)
    default public boolean filterLevelUp() {
        return false;
    }

    @ConfigItem(keyName="filterMaxTotal", name="Filter Max Total Message", description="Removes Max Total message from clan broadcast", section="Skilling Filters", position=3)
    default public boolean filterMaxTotal() {
        return false;
    }

    @ConfigItem(keyName="levelThreshold", name="Level Threshold", description="Set minimum Level threshold to filter broadcasts (Default: 100)", section="Skilling Filters", position=4)
    default public int levelThreshold() {
        return 100;
    }

    @ConfigItem(keyName="filterXpMilestone", name="Filter XP Milestones", description="Removes XP Milestones from clan broadcast", section="Skilling Filters", position=5)
    default public boolean filterXpMilestone() {
        return false;
    }

    @ConfigItem(keyName="xpMilestoneThreshold", name="XP Milestone Threshold", description="Set minimum XP Milestone threshold to filter broadcasts (Default: 2,147,483,647)", section="Skilling Filters", position=6)
    default public int xpMilestoneThreshold() {
        return Integer.MAX_VALUE;
    }

    @ConfigItem(keyName="filterPlayerDied", name="Filter Player Death", description="Removes Players who got PK'ed from clan broadcast", section="PvP Filters", position=0)
    default public boolean filterPlayerDied() {
        return false;
    }

    @ConfigItem(keyName="playerDiedThreshold", name="Player Death Threshold", description="Set minimum GP threshold to filter broadcasts (Default: 2,147,483,647)", section="PvP Filters", position=1)
    default public int playerDiedThreshold() {
        return Integer.MAX_VALUE;
    }

    @ConfigItem(keyName="filterPlayerKill", name="Filter Player Kill", description="Removes Players who get a PK from clan broadcast", section="PvP Filters", position=2)
    default public boolean filterPlayerKill() {
        return false;
    }

    @ConfigItem(keyName="playerKillThreshold", name="Player Kill Threshold", description="Set minimum GP threshold to filter broadcasts (Default: 2,147,483,647)", section="PvP Filters", position=3)
    default public int playerKillThreshold() {
        return Integer.MAX_VALUE;
    }

    @ConfigItem(keyName="excludedPlayerNames", name="Player names to always include in broadcasts", description="Using comma separation e.g. 'Biceps Btw, store biceps' if any player broadcasts matches these search terms it would always be included in Clan Broadcast (case insensitive)", section="Miscellaneous", position=0, hidden=false)
    default public String excludedPlayerNames() {
        return "";
    }
}

