/*
 * Decompiled with CFR 0.152.
 */
package com.gemtracker;

import com.gemtracker.GemTrackerPlugin;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GemTrackerSession {
    private static final Logger log = LoggerFactory.getLogger(GemTrackerSession.class);
    public Instant gemFound;
    @Inject
    ItemManager itemManager;
    private final GemTrackerPlugin plugin;
    private int jadesFound;
    private int diamondsFound;
    private int rubiesFound;
    private int opalsFound;
    private int sapphiresFound;
    private int emeraldsFound;
    private int redtopazFound;
    public int loadsDone;
    int profitDiamonds;
    int profitRubies;
    int profitEmeralds;
    int profitSapphires;
    int profitJades;
    int profitOpals;
    int profitRedTopaz;
    int tProfit = -1;
    public int currTotalGems;
    private Instant lastMined;

    @Inject
    public GemTrackerSession(ItemManager itemManager, GemTrackerPlugin plugin) {
        this.itemManager = itemManager;
        this.plugin = plugin;
    }

    void incrementGemFound(int gemID) {
        this.gemFound = Instant.now();
        switch (gemID) {
            case 1617: {
                ++this.diamondsFound;
                break;
            }
            case 1619: {
                ++this.rubiesFound;
                break;
            }
            case 1621: {
                ++this.emeraldsFound;
                break;
            }
            case 1623: {
                ++this.sapphiresFound;
                break;
            }
            case 1627: {
                ++this.jadesFound;
                break;
            }
            case 1625: {
                ++this.opalsFound;
                break;
            }
            case 1629: {
                ++this.redtopazFound;
                break;
            }
            default: {
                System.out.println("Invalid gem type.");
            }
        }
    }

    void setLastMined() {
        this.lastMined = Instant.now();
    }

    public int calcLoadsDone() {
        this.currTotalGems = 0;
        int tGems = this.diamondsFound + this.rubiesFound + this.emeraldsFound + this.sapphiresFound + this.jadesFound + this.opalsFound + this.redtopazFound;
        if (tGems > 0) {
            this.currTotalGems = tGems / 28;
            if (this.currTotalGems >= 1) {
                return Math.round(this.currTotalGems);
            }
        }
        return 0;
    }

    public int calcTotalValue() {
        int totalGems = this.diamondsFound + this.rubiesFound + this.emeraldsFound + this.sapphiresFound + this.jadesFound + this.opalsFound + this.redtopazFound;
        if (totalGems > 0) {
            if (this.diamondsFound > 0) {
                this.profitDiamonds = this.diamondsFound * this.itemManager.getItemPrice(1617);
            }
            if (this.rubiesFound > 0) {
                this.profitRubies = this.rubiesFound * this.itemManager.getItemPrice(1619);
            }
            if (this.emeraldsFound > 0) {
                this.profitEmeralds = this.emeraldsFound * this.itemManager.getItemPrice(1621);
            }
            if (this.sapphiresFound > 0) {
                this.profitSapphires = this.sapphiresFound * this.itemManager.getItemPrice(1623);
            }
            if (this.jadesFound > 0) {
                this.profitJades = this.jadesFound * this.itemManager.getItemPrice(1627);
            }
            if (this.opalsFound > 0) {
                this.profitOpals = this.opalsFound * this.itemManager.getItemPrice(1625);
            }
            if (this.redtopazFound > 0) {
                this.profitRedTopaz = this.redtopazFound * this.itemManager.getItemPrice(1629);
            }
            this.tProfit = this.profitDiamonds + this.profitRubies + this.profitEmeralds + this.profitSapphires + this.profitJades + this.profitOpals + this.profitRedTopaz;
            return this.tProfit;
        }
        return 0;
    }

    public Instant getGemFound() {
        return this.gemFound;
    }

    public void setGemFound(Instant gemFound) {
        this.gemFound = gemFound;
    }

    public int getJadesFound() {
        return this.jadesFound;
    }

    void setJadesFound(int jadesFound) {
        this.jadesFound = jadesFound;
    }

    public int getDiamondsFound() {
        return this.diamondsFound;
    }

    void setDiamondsFound(int diamondsFound) {
        this.diamondsFound = diamondsFound;
    }

    public int getRubiesFound() {
        return this.rubiesFound;
    }

    void setRubiesFound(int rubiesFound) {
        this.rubiesFound = rubiesFound;
    }

    public int getOpalsFound() {
        return this.opalsFound;
    }

    void setOpalsFound(int opalsFound) {
        this.opalsFound = opalsFound;
    }

    public int getSapphiresFound() {
        return this.sapphiresFound;
    }

    void setSapphiresFound(int sapphiresFound) {
        this.sapphiresFound = sapphiresFound;
    }

    public int getEmeraldsFound() {
        return this.emeraldsFound;
    }

    void setEmeraldsFound(int emeraldsFound) {
        this.emeraldsFound = emeraldsFound;
    }

    public int getRedtopazFound() {
        return this.redtopazFound;
    }

    void setRedtopazFound(int redtopazFound) {
        this.redtopazFound = redtopazFound;
    }

    public int getLoadsDone() {
        return this.loadsDone;
    }

    public void setLoadsDone(int loadsDone) {
        this.loadsDone = loadsDone;
    }

    public int getCurrTotalGems() {
        return this.currTotalGems;
    }

    public Instant getLastMined() {
        return this.lastMined;
    }
}

