/*
 * Decompiled with CFR 0.152.
 */
package com.gemtracker;

import com.gemtracker.GemTrackerConfig;
import com.gemtracker.GemTrackerOverlay;
import com.gemtracker.GemTrackerSession;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Gem Rock Tracker", description="A plugin that tracks gems from gem rocks that you mine in the Shilo Village underground mine.", tags={"gem", "mining"})
@PluginDependency(value=XpTrackerPlugin.class)
public class GemTrackerPlugin
extends Plugin {
    @Inject
    private GemTrackerSession session;
    private static final Set<Integer> MINING_PICKS = ImmutableSet.of((Object)7283, (Object)628, (Object)3873, (Object)625, (Object)8347, (Object)7139, (Object[])new Integer[]{8346, 8887, 642, 8313, 4482, 626, 629, 624, 627});
    private static final Set<Integer> SHILO_VILLAGE_MINE_REGION = ImmutableSet.of((Object)11153, (Object)11154, (Object)11155, (Object)11409, (Object)11410, (Object)11411, (Object[])new Integer[]{11665, 11666, 11667});
    private static final Set<Integer> UNCUT_GEM_IDS = ImmutableSet.of((Object)1627, (Object)1617, (Object)1623, (Object)1625, (Object)1621, (Object)1619, (Object[])new Integer[]{1629});
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private GemTrackerConfig config;
    @Inject
    private GemTrackerOverlay overlay;
    public boolean inSvm;
    @Inject
    public String lastGemFoundS = "";

    @Provides
    GemTrackerConfig getConfig(ConfigManager configManager) {
        return (GemTrackerConfig)configManager.getConfig(GemTrackerConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.session.setGemFound(null);
    }

    @Subscribe
    @Inject
    public void onChatMessage(ChatMessage event) {
        String chatMessage;
        if (!this.checkInSvm() || event.getType() != ChatMessageType.SPAM) {
            return;
        }
        switch (chatMessage = event.getMessage()) {
            case "You just mined a Diamond!": {
                this.session.incrementGemFound(1617);
                this.lastGemFoundS = "Diamond";
                break;
            }
            case "You just mined a Ruby!": {
                this.session.incrementGemFound(1619);
                this.lastGemFoundS = "Ruby";
                break;
            }
            case "You just mined an Emerald!": {
                this.session.incrementGemFound(1621);
                this.lastGemFoundS = "Emerald";
                break;
            }
            case "You just mined a Sapphire!": {
                this.session.incrementGemFound(1623);
                this.lastGemFoundS = "Sapphire";
                break;
            }
            case "You just mined an Opal!": {
                this.session.incrementGemFound(1625);
                this.lastGemFoundS = "Opal";
                break;
            }
            case "You just mined a piece of Jade!": {
                this.session.incrementGemFound(1627);
                this.lastGemFoundS = "Jade";
                break;
            }
            case "You just mined a Red Topaz!": {
                this.session.incrementGemFound(1629);
                this.lastGemFoundS = "Red Topaz";
            }
        }
    }

    public boolean checkInSvm() {
        int[] currentMapRegions = this.client.getMapRegions();
        GameState gameState = this.client.getGameState();
        if (gameState == GameState.LOGGED_IN) {
            for (int region : currentMapRegions) {
                if (!SHILO_VILLAGE_MINE_REGION.contains(region)) continue;
                this.inSvm = true;
                return true;
            }
        }
        this.inSvm = false;
        return false;
    }

    void reset() {
        this.session.setGemFound(null);
    }

    public boolean areMining() {
        return Arrays.asList(MINING_PICKS).contains(this.client.getLocalPlayer().getAnimation());
    }

    GemTrackerSession getSession() {
        return this.session;
    }

    public static Set<Integer> getUNCUT_GEM_IDS() {
        return UNCUT_GEM_IDS;
    }

    boolean isInSvm() {
        return this.inSvm;
    }

    public String getLastGemFoundS() {
        return this.lastGemFoundS;
    }
}

