/*
 * Decompiled with CFR 0.152.
 */
package com.gemtracker;

import com.gemtracker.GemTrackerConfig;
import com.gemtracker.GemTrackerPlugin;
import com.gemtracker.GemTrackerSession;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class GemTrackerOverlay
extends OverlayPanel {
    private static final String GEMTRACKER_RESET = "Reset";
    @Inject
    ItemManager itemManager;
    private static final Set<Integer> MINING_ANIMATION = ImmutableSet.of((Object)625, (Object)626, (Object)627, (Object)3873, (Object)629, (Object)628, (Object[])new Integer[]{624, 8313, 7139, 8346, 642, 7283, 4482, 8347});
    private final Client client;
    private final GemTrackerPlugin plugin;
    private final GemTrackerConfig config;
    private final GemTrackerSession gemTrackerSession;
    private XpTrackerService xpTrackerService;

    @Inject
    public GemTrackerOverlay(Client client, GemTrackerPlugin plugin, GemTrackerConfig config, GemTrackerSession gemTrackerSession, XpTrackerService xpTrackerService, ItemManager itemManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client;
        this.plugin = plugin;
        this.gemTrackerSession = gemTrackerSession;
        this.config = config;
        this.xpTrackerService = xpTrackerService;
        this.itemManager = itemManager;
        this.addMenuEntry(MenuAction.RUNELITE_OVERLAY, GEMTRACKER_RESET, "Gem Tracker overlay", e -> plugin.reset());
    }

    public Dimension render(Graphics2D graphics) {
        if (this.gemTrackerSession.getGemFound() == null || !this.plugin.isInSvm()) {
            return null;
        }
        if (this.plugin.isInSvm()) {
            if (this.config.standAloneMode()) {
                if (MINING_ANIMATION.contains(this.client.getLocalPlayer().getAnimation())) {
                    this.panelComponent.getChildren().add(TitleComponent.builder().text("Gem Tracker").color(Color.GREEN).build());
                } else {
                    this.panelComponent.getChildren().add(TitleComponent.builder().text("Gem Tracker").color(Color.RED).build());
                }
            } else if (this.gemTrackerSession.getGemFound() != null) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Gem Tracker").color(this.config.cTextColor()).build());
            }
            int actions = this.xpTrackerService.getActions(Skill.MINING);
            if (actions > 0) {
                if (this.config.trackGemTypes() && this.config.gemPrices()) {
                    if (this.plugin.getSession().getOpalsFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Opal: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1625) + ") " + this.plugin.getSession().getOpalsFound()).build());
                    }
                    if (this.plugin.getSession().getJadesFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Jade: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1627) + ") " + this.plugin.getSession().getJadesFound()).build());
                    }
                    if (this.plugin.getSession().getRedtopazFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Red Topaz: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1629) + ") " + this.plugin.getSession().getRedtopazFound()).build());
                    }
                    if (this.plugin.getSession().getSapphiresFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Sapphire: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1623) + ") " + this.plugin.getSession().getSapphiresFound()).build());
                    }
                    if (this.plugin.getSession().getEmeraldsFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Emerald: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1621) + ") " + this.plugin.getSession().getEmeraldsFound()).build());
                    }
                    if (this.plugin.getSession().getRubiesFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Ruby: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1619) + ") " + this.plugin.getSession().getRubiesFound()).build());
                    }
                    if (this.plugin.getSession().getDiamondsFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Diamond: ").rightColor(this.config.cTextColor()).right("(" + this.itemManager.getItemPrice(1617) + ") " + this.plugin.getSession().getDiamondsFound()).build());
                    }
                }
                if (this.config.trackGemTypes() & !this.config.gemPrices()) {
                    if (this.plugin.getSession().getOpalsFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Opal: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getOpalsFound())).build());
                    }
                    if (this.plugin.getSession().getJadesFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Jade: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getJadesFound())).build());
                    }
                    if (this.plugin.getSession().getRedtopazFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Red Topaz: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getRedtopazFound())).build());
                    }
                    if (this.plugin.getSession().getSapphiresFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Sapphire: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getSapphiresFound())).build());
                    }
                    if (this.plugin.getSession().getEmeraldsFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Emerald: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getEmeraldsFound())).build());
                    }
                    if (this.plugin.getSession().getRubiesFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Ruby: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getRubiesFound())).build());
                    }
                    if (this.plugin.getSession().getDiamondsFound() > 0) {
                        this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Diamond: ").rightColor(this.config.cTextColor()).right(Integer.toString(this.plugin.getSession().getDiamondsFound())).build());
                    }
                }
                if (this.config.standAloneMode() || this.config.trackProfit() || this.config.trackXpHr()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().build());
                }
                if (this.config.trackLoads()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Total loads:").rightColor(this.config.cTextColor()).right(String.format("%,d", this.gemTrackerSession.calcLoadsDone())).build());
                }
                if (this.config.standAloneMode()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Gems mined:").rightColor(this.config.cTextColor()).right(String.format("%,d", actions)).build());
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Gems/hr:").rightColor(this.config.cTextColor()).right(String.format("%,d", this.xpTrackerService.getActionsHr(Skill.MINING))).build());
                }
                if (this.config.trackProfit()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("Profit:").rightColor(this.config.cTextColor()).right(String.format("%,d", this.plugin.getSession().calcTotalValue())).build());
                }
                if (this.config.trackXpHr()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(this.config.cTextColor()).left("XP/hr:").rightColor(this.config.cTextColor()).right(String.format("%,d", this.xpTrackerService.getXpHr(Skill.MINING))).build());
                }
            }
        }
        return super.render(graphics);
    }
}

