/*
 * Decompiled with CFR 0.152.
 */
package gg.trevor.tobdamage;

import gg.trevor.tobdamage.TobDamageCounterConfig;
import gg.trevor.tobdamage.TobDamageCounterPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Player;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.QuantityFormatter;

class TobDamageOverlay
extends OverlayPanel {
    private final TobDamageCounterPlugin plugin;
    private final TobDamageCounterConfig config;

    @Inject
    TobDamageOverlay(TobDamageCounterPlugin plugin, TobDamageCounterConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInTob() || this.plugin.getLocalPlayerIndex() == 0) {
            return null;
        }
        if (this.plugin.getCurrentRoom() == null && this.plugin.getRaidDamage() == null) {
            return null;
        }
        String title = this.plugin.getCurrentRoom() == null ? "Tob Damage" : this.plugin.getCurrentRoom().toString() + " Damage";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(title).build());
        TobDamageCounterPlugin.Damage damage = this.plugin.getCurrentRoom() != null ? this.plugin.getDamageMap().get((Object)this.plugin.getCurrentRoom()) : this.plugin.getRaidDamage();
        String left = "Personal Damage";
        String right = QuantityFormatter.formatNumber((long)damage.getPersonalDamage());
        this.panelComponent.getChildren().add(LineComponent.builder().left(left).right(right).build());
        left = "Total Damage";
        right = QuantityFormatter.formatNumber((long)damage.getTotalDamage());
        this.panelComponent.getChildren().add(LineComponent.builder().left(left).right(right).build());
        if (this.config.showHealCount() && damage.getTotalHealing() != 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Total Healing").right(QuantityFormatter.formatNumber((long)damage.getTotalHealing())).build());
        }
        if (this.config.showLeechOverlay() && damage.getLeechCounts().size() != 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().build());
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Leech Count").build());
            Map<Player, Integer> leeches = damage.getLeechCounts();
            for (Player p : leeches.keySet()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left(p.getName()).right("" + leeches.get(p)).build());
            }
        }
        return super.render(graphics);
    }
}

