/*
 * Decompiled with CFR 0.152.
 */
package gg.trevor.tobdamage;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import gg.trevor.tobdamage.TobDamageCounterConfig;
import gg.trevor.tobdamage.TobDamageOverlay;
import gg.trevor.tobdamage.TobRooms;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="TOB Damage Counter", description="Shows personal and total damage for each room in the theatre of blood", tags={"counter", "tracker"})
public class TobDamageCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobDamageCounterPlugin.class);
    private static final Set<Integer> blacklistNPCs = ImmutableSet.of((Object)8379);
    private static final Set<Integer> SALVE_IDS = ImmutableSet.of((Object)10588, (Object)12018, (Object)4081, (Object)12017);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.##");
    private static final DecimalFormat DAMAGE_FORMAT = new DecimalFormat("#,###");
    private static final WorldPoint TEMP_LOCATION = new WorldPoint(3370, 5152, 2);
    private static final int VERZIK_HEAL_GRAPHIC = 1602;
    private static final int LOCAL_TOB_ORB_VARB = 6441;
    private static final Set<Integer> maidenSpawns = ImmutableSet.of((Object)8366, (Object)8367);
    private static final Set<Integer> verzikIDs = ImmutableSet.of((Object)8370, (Object)8372, (Object)8374);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TobDamageOverlay tobDamageOverlay;
    @Inject
    private TobDamageCounterConfig config;
    private boolean inTob;
    private int localPlayerIndex;
    private TobRooms currentRoom;
    private Map<TobRooms, Damage> damageMap = new HashMap<TobRooms, Damage>();
    private Damage raidDamage;
    private boolean shouldCalc;
    private boolean loggedIn;

    @Provides
    TobDamageCounterConfig provideConfig(ConfigManager configManager) {
        return (TobDamageCounterConfig)configManager.getConfig(TobDamageCounterConfig.class);
    }

    protected void startUp() throws Exception {
        this.clientThread.invokeLater(() -> this.calcInTob());
        this.overlayManager.add((Overlay)this.tobDamageOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.tobDamageOverlay);
        this.reset();
    }

    private void reset() {
        this.damageMap.clear();
        this.inTob = false;
        this.currentRoom = null;
        this.raidDamage = null;
        this.shouldCalc = false;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (!this.inTob) {
            return;
        }
        Actor actor = hitsplatApplied.getActor();
        if (!(actor instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)actor;
        if (blacklistNPCs.contains(npc.getId())) {
            return;
        }
        this.calcCurrentRoom(npc.getId());
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (this.currentRoom == null) {
            return;
        }
        if (this.config.showMVPDamage()) {
            if (this.currentRoom == TobRooms.MAIDEN && maidenSpawns.contains(npc.getId())) {
                return;
            }
            if (!(this.currentRoom != TobRooms.VERZIK_P1 && this.currentRoom != TobRooms.VERZIK_P2 && this.currentRoom != TobRooms.VERZIK_P3 || verzikIDs.contains(npc.getId()))) {
                return;
            }
        }
        if (hitsplat.isMine()) {
            this.damageMap.get((Object)this.currentRoom).addDamage(hitsplat.getAmount(), true);
        } else if (hitsplat.isOthers()) {
            this.damageMap.get((Object)this.currentRoom).addDamage(hitsplat.getAmount(), false);
        } else if (hitsplat.getHitsplatType() == 6) {
            this.damageMap.get((Object)this.currentRoom).addHealing(hitsplat.getAmount());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getId() != 8375) {
            return;
        }
        if (this.config.showDamageSummary()) {
            for (TobRooms room : TobRooms.values()) {
                this.printRoomDamage(room, this.damageMap.get((Object)room));
            }
            this.printRoomDamage(null, this.raidDamage);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN && !this.loggedIn) {
            if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getWorldLocation().equals((Object)TEMP_LOCATION)) {
                return;
            }
            this.shouldCalc = true;
        } else if (this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getGameState() == GameState.CONNECTION_LOST) {
            this.loggedIn = false;
        } else if (this.client.getGameState() == GameState.HOPPING) {
            this.reset();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.shouldCalc) {
            this.calcInTob();
            this.shouldCalc = false;
            this.loggedIn = true;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        boolean tempInTob = this.getTobState();
        this.localPlayerIndex = this.client.getVarbitValue(6441);
        if (tempInTob != this.inTob) {
            if (this.loggedIn) {
                if (tempInTob) {
                    this.initializeTob();
                } else {
                    this.reset();
                }
            }
            this.inTob = tempInTob;
        }
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        if (!this.inTob) {
            return;
        }
        int id = event.getActor().getGraphic();
        if (id == 1602) {
            if (this.config.showLeechMessages()) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(event.getActor().getName() + " has leeched and healed Verzik.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(chatMessage).build());
            }
            if (event.getActor() instanceof Player) {
                this.damageMap.get((Object)this.currentRoom).addLeech((Player)event.getActor());
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Integer leechCount;
        if (!this.inTob || !(event.getActor() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getActor();
        Actor interacting = p.getInteracting();
        if (interacting == null || !(interacting instanceof NPC) || ((NPC)interacting).getId() != 8359 || p.getAnimation() == -1) {
            return;
        }
        int amulet_id = p.getPlayerComposition().getEquipmentId(KitType.AMULET);
        if (SALVE_IDS.contains(amulet_id)) {
            return;
        }
        if (this.config.showLeechMessages() && (leechCount = this.damageMap.get((Object)this.currentRoom).getLeechCounts().get(p)) == null) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(p.getName() + " is leeching and is not attacking with a salve.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(chatMessage).build());
        }
        if (event.getActor() instanceof Player) {
            this.damageMap.get((Object)this.currentRoom).addLeech((Player)event.getActor());
        }
    }

    private void calcCurrentRoom(int npcID) {
        if (this.currentRoom != null && this.currentRoom.getNpcIds().contains(npcID)) {
            return;
        }
        for (TobRooms room : TobRooms.values()) {
            if (!room.getNpcIds().contains(npcID)) continue;
            this.currentRoom = room;
            return;
        }
        this.currentRoom = null;
        log.warn("NPC ID not handled: " + npcID);
    }

    private void calcInTob() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean tempInTob = this.getTobState();
        if (tempInTob != this.inTob) {
            if (!tempInTob) {
                this.reset();
            } else if (tempInTob) {
                this.initializeTob();
            }
            this.inTob = tempInTob;
        }
    }

    private void initializeTob() {
        for (TobRooms room : TobRooms.values()) {
            this.damageMap.put(room, new Damage());
        }
    }

    private boolean getTobState() {
        return this.client.getVar(6440) == 2 || this.client.getVar(6440) == 3;
    }

    private void printRoomDamage(TobRooms room, Damage damage) {
        int totalDamage = damage.getTotalDamage();
        int personalDamage = damage.getPersonalDamage();
        double percentage = (double)personalDamage / ((double)totalDamage / 100.0);
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total " + (room != null ? room.toString() : "raid") + " damage: ").append(ChatColorType.HIGHLIGHT).append(DAMAGE_FORMAT.format(totalDamage)).append(ChatColorType.NORMAL).append(", Personal damage: ").append(ChatColorType.HIGHLIGHT).append(DAMAGE_FORMAT.format(personalDamage)).append(ChatColorType.NORMAL).append(" (").append(ChatColorType.HIGHLIGHT).append(DECIMAL_FORMAT.format(percentage)).append(ChatColorType.NORMAL).append("%)").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(chatMessage).build());
    }

    public boolean isInTob() {
        return this.inTob;
    }

    public int getLocalPlayerIndex() {
        return this.localPlayerIndex;
    }

    public TobRooms getCurrentRoom() {
        return this.currentRoom;
    }

    public Map<TobRooms, Damage> getDamageMap() {
        return this.damageMap;
    }

    public Damage getRaidDamage() {
        return this.raidDamage;
    }

    class Damage {
        private int personalDamage = 0;
        private int totalDamage = 0;
        private int totalHealing = 0;
        private Map<Player, Integer> leechCounts = new HashMap<Player, Integer>();

        void addDamage(int damage, boolean isLocalPlayer) {
            if (this != TobDamageCounterPlugin.this.raidDamage) {
                if (TobDamageCounterPlugin.this.raidDamage == null) {
                    TobDamageCounterPlugin.this.raidDamage = new Damage();
                }
                TobDamageCounterPlugin.this.raidDamage.addDamage(damage, isLocalPlayer);
            }
            this.totalDamage += damage;
            if (isLocalPlayer) {
                this.personalDamage += damage;
            }
        }

        void addLeech(Player player) {
            if (this.leechCounts.get(player) != null) {
                this.leechCounts.put(player, this.leechCounts.get(player) + 1);
            } else {
                this.leechCounts.put(player, 1);
            }
        }

        void addHealing(int amount) {
            this.totalHealing += amount;
        }

        public int getPersonalDamage() {
            return this.personalDamage;
        }

        public int getTotalDamage() {
            return this.totalDamage;
        }

        public int getTotalHealing() {
            return this.totalHealing;
        }

        public Map<Player, Integer> getLeechCounts() {
            return this.leechCounts;
        }

        public void setPersonalDamage(int personalDamage) {
            this.personalDamage = personalDamage;
        }

        public void setTotalDamage(int totalDamage) {
            this.totalDamage = totalDamage;
        }

        public void setTotalHealing(int totalHealing) {
            this.totalHealing = totalHealing;
        }

        public void setLeechCounts(Map<Player, Integer> leechCounts) {
            this.leechCounts = leechCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Damage)) {
                return false;
            }
            Damage other = (Damage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPersonalDamage() != other.getPersonalDamage()) {
                return false;
            }
            if (this.getTotalDamage() != other.getTotalDamage()) {
                return false;
            }
            if (this.getTotalHealing() != other.getTotalHealing()) {
                return false;
            }
            Map<Player, Integer> this$leechCounts = this.getLeechCounts();
            Map<Player, Integer> other$leechCounts = other.getLeechCounts();
            return !(this$leechCounts == null ? other$leechCounts != null : !((Object)this$leechCounts).equals(other$leechCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Damage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPersonalDamage();
            result = result * 59 + this.getTotalDamage();
            result = result * 59 + this.getTotalHealing();
            Map<Player, Integer> $leechCounts = this.getLeechCounts();
            result = result * 59 + ($leechCounts == null ? 43 : ((Object)$leechCounts).hashCode());
            return result;
        }

        public String toString() {
            return "TobDamageCounterPlugin.Damage(personalDamage=" + this.getPersonalDamage() + ", totalDamage=" + this.getTotalDamage() + ", totalHealing=" + this.getTotalHealing() + ", leechCounts=" + this.getLeechCounts() + ")";
        }
    }
}

