/*
 * Decompiled with CFR 0.152.
 */
package com.airtiarasrunecraft;

import java.time.Instant;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AirTiarasRunecraftSession {
    private static final Logger log = LoggerFactory.getLogger(AirTiarasRunecraftSession.class);
    private Instant lastLapCompleted;
    private int totalLaps;
    private int lapsTillGoal;

    AirTiarasRunecraftSession() {
    }

    void incrementLapCount(Client client, XpTrackerService xpTrackerService) {
        ++this.totalLaps;
        this.calculateLapsUntilGoal(client, xpTrackerService);
    }

    void calculateLapsUntilGoal(Client client, XpTrackerService xpTrackerService) {
        int currentExp = client.getSkillExperience(Skill.RUNECRAFT);
        int rcLvl = client.getBoostedSkillLevel(Skill.RUNECRAFT);
        int goalXp = xpTrackerService.getEndGoalXp(Skill.RUNECRAFT);
        if (goalXp == 0) {
            goalXp = Experience.getXpForLevel((int)(rcLvl + 1));
        }
        int goalRemainingXp = goalXp - currentExp;
        double courseTotalExp = 650.0;
        this.lapsTillGoal = goalRemainingXp > 0 ? (int)Math.ceil((double)goalRemainingXp / courseTotalExp) : 0;
    }

    void resetLapCount() {
        this.totalLaps = 0;
        this.lapsTillGoal = 0;
    }

    public Instant getLastLapCompleted() {
        return this.lastLapCompleted;
    }

    public int getTotalLaps() {
        return this.totalLaps;
    }

    public int getLapsTillGoal() {
        return this.lapsTillGoal;
    }

    public void setLastLapCompleted(Instant lastLapCompleted) {
        this.lastLapCompleted = lastLapCompleted;
    }

    public void setTotalLaps(int totalLaps) {
        this.totalLaps = totalLaps;
    }

    public void setLapsTillGoal(int lapsTillGoal) {
        this.lapsTillGoal = lapsTillGoal;
    }
}

