/*
 * Decompiled with CFR 0.152.
 */
package com.airtiarasrunecraft;

import com.airtiarasrunecraft.AirTiarasRunecraftConfig;
import com.airtiarasrunecraft.AirTiarasRunecraftOverlay;
import com.airtiarasrunecraft.AirTiarasRunecraftSession;
import com.airtiarasrunecraft.Stopwatch;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Air Tiaras Runecraft")
@PluginDependency(value=XpTrackerPlugin.class)
public class AirTiarasRunecraftPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AirTiarasRunecraftPlugin.class);
    private final WorldPoint startLocation = new WorldPoint(2933, 3288, 0);
    private final WorldPoint stopLocation = new WorldPoint(2933, 3289, 0);
    @Inject
    private Client client;
    @Inject
    private AirTiarasRunecraftConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AirTiarasRunecraftOverlay airTiarasRunecraftOverlay;
    private AirTiarasRunecraftSession session;
    @Inject
    private XpTrackerService xpTrackerService;
    private boolean lapStarted = false;
    private Stopwatch stopWatch;
    private boolean hasGainedRcXp = false;
    private boolean hasGainedMiningXp = false;
    private boolean hasGainedSmithingXp = false;
    private boolean hasGainedCraftingXp = false;
    private WorldPoint lastLocation;
    private boolean isFirstGameTick = true;

    @Provides
    AirTiarasRunecraftConfig provideConfig(ConfigManager configManager) {
        return (AirTiarasRunecraftConfig)configManager.getConfig(AirTiarasRunecraftConfig.class);
    }

    protected void startUp() throws Exception {
        this.resetLap();
        this.session = new AirTiarasRunecraftSession();
        this.stopWatch = new Stopwatch("Stopwatch");
        this.lastLocation = this.getPlayerLocation();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.airTiarasRunecraftOverlay);
        this.session = null;
        this.stopWatch = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Subscribe
    public void onGameTick(GameTick tick) {
        if (!this.isFirstGameTick) {
            try {
                if (this.isOnStopTile() && this.lapStarted && this.isValidLap()) {
                    this.stopLap();
                } else if (this.isOnStartTile() && !this.lapStarted && this.lastLocation.hashCode() == this.stopLocation.hashCode()) {
                    this.startLap();
                }
                if (this.lastLocation == this.getPlayerLocation()) return;
                this.lastLocation = this.getPlayerLocation();
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.lastLocation = this.getPlayerLocation();
            this.isFirstGameTick = false;
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.isFirstGameTick) {
            return;
        }
        if (statChanged.getSkill() == Skill.RUNECRAFT) {
            this.hasGainedRcXp = true;
        } else if (statChanged.getSkill() == Skill.MINING) {
            this.hasGainedMiningXp = true;
        } else if (statChanged.getSkill() == Skill.CRAFTING) {
            this.hasGainedCraftingXp = true;
        } else if (statChanged.getSkill() == Skill.SMITHING) {
            this.hasGainedSmithingXp = true;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.isFirstGameTick = true;
        }
    }

    private boolean isOnStartTile() {
        return this.startLocation.hashCode() == this.getPlayerLocation().hashCode();
    }

    private boolean isOnStopTile() {
        return this.stopLocation.hashCode() == this.getPlayerLocation().hashCode();
    }

    private boolean isValidLap() {
        return this.hasGainedRcXp && this.hasGainedCraftingXp && this.hasGainedSmithingXp && this.hasGainedMiningXp;
    }

    private WorldPoint getPlayerLocation() {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return null;
        }
        WorldPoint location = local.getWorldLocation();
        return location;
    }

    private void startLap() {
        this.resetLap();
        this.stopWatch.start();
        this.lapStarted = true;
        this.session.calculateLapsUntilGoal(this.client, this.xpTrackerService);
        if (!this.overlayManager.anyMatch(overlay -> overlay.getName() == this.airTiarasRunecraftOverlay.getName())) {
            this.overlayManager.add((Overlay)this.airTiarasRunecraftOverlay);
        }
    }

    private void stopLap() {
        this.stopWatch.pause();
        this.stopWatch.lap();
        this.session.incrementLapCount(this.client, this.xpTrackerService);
        this.resetLap();
    }

    private void resetLap() {
        this.lapStarted = false;
        this.hasGainedRcXp = false;
        this.hasGainedCraftingXp = false;
        this.hasGainedSmithingXp = false;
        this.hasGainedMiningXp = false;
    }

    public AirTiarasRunecraftSession getSession() {
        return this.session;
    }

    public void setSession(AirTiarasRunecraftSession session) {
        this.session = session;
    }

    public Stopwatch getStopWatch() {
        return this.stopWatch;
    }

    public void setStopWatch(Stopwatch stopWatch) {
        this.stopWatch = stopWatch;
    }
}

