/*
 * Decompiled with CFR 0.152.
 */
package com.airtiarasrunecraft;

import com.airtiarasrunecraft.AirTiarasRunecraftConfig;
import com.airtiarasrunecraft.AirTiarasRunecraftPlugin;
import com.airtiarasrunecraft.AirTiarasRunecraftSession;
import com.airtiarasrunecraft.Stopwatch;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.EnumSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AirTiarasRunecraftOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(AirTiarasRunecraftOverlay.class);
    private final Client client;
    private final AirTiarasRunecraftPlugin plugin;
    private final AirTiarasRunecraftConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private AirTiarasRunecraftOverlay(AirTiarasRunecraftPlugin plugin, Client client, AirTiarasRunecraftConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        AirTiarasRunecraftSession session = this.plugin.getSession();
        Stopwatch stopwatch = this.plugin.getStopWatch();
        this.panelComponent.getChildren().clear();
        String overlayTitle = "Air Tiaras Runecraft:";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).build());
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(overlayTitle) + 10, 0));
        if (this.config.showCurrentWorld()) {
            EnumSet worldType = this.client.getWorldType();
            Color currentWorldColor = worldType.contains(WorldType.MEMBERS) ? Color.RED : Color.WHITE;
            this.panelComponent.getChildren().add(LineComponent.builder().left("World:").right(Integer.toString(this.client.getWorld())).rightColor(currentWorldColor).build());
        }
        if (this.config.showLapTime()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Lap time:").right(stopwatch.secondsToString((int)stopwatch.getDisplayTime())).build());
        }
        if (this.config.showBestLap()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Best lap:").right(!stopwatch.getLaps().isEmpty() ? stopwatch.getFormatedBestLap() : "--").rightColor(!stopwatch.getLaps().isEmpty() ? Color.GREEN : Color.WHITE).build());
        }
        if (this.config.lapsToLevel() && session.getLapsTillGoal() > 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Laps until goal:").right(Integer.toString(session.getLapsTillGoal())).build());
        }
        if (this.config.showTotalLaps()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Total laps:").right(Integer.toString(session.getTotalLaps())).build());
        }
        return this.panelComponent.render(graphics);
    }
}

