/*
 * Decompiled with CFR 0.152.
 */
package com.runelogger;

import com.google.inject.Provides;
import com.runelogger.ApiCommunication;
import com.runelogger.Bosses;
import com.runelogger.ClueScrollCompletion;
import com.runelogger.CollectionLog;
import com.runelogger.DuelArena;
import com.runelogger.LevelingUp;
import com.runelogger.MusicUnlock;
import com.runelogger.QuestCompletion;
import com.runelogger.RuneloggerConfig;
import com.runelogger.SkillingBosses;
import com.runelogger.SoloCombatMinigame;
import com.runelogger.TutorialIsland;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Runelogger", description="Publishes your RuneScape adventures on Runelogger.com.", tags={"runelogger", "journey"})
public class RuneloggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RuneloggerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RuneloggerConfig config;
    @Inject
    private SkillingBosses skillingBosses;
    @Inject
    private LevelingUp levelingUp;
    @Inject
    private QuestCompletion questCompletion;
    @Inject
    private MusicUnlock musicUnlock;
    @Inject
    private TutorialIsland tutorialIsland;
    @Inject
    private CollectionLog collectionLog;
    @Inject
    private Bosses bosses;
    @Inject
    private DuelArena duelArena;
    @Inject
    private ClueScrollCompletion clueScrollCompletion;
    @Inject
    private SoloCombatMinigame soloCombatMinigame;
    @Inject
    private ApiCommunication apiCommunication;
    private boolean characterInfoSend = false;
    private boolean suportedWorld = false;

    protected void startUp() {
        log.debug("Plugin active!");
    }

    protected void shutDown() {
        this.characterInfoSend = false;
        log.debug("Plugin inactive!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (!(gameStateChanged.getGameState() != GameState.LOGGED_IN || this.client.getWorldType().contains(WorldType.DEADMAN) || this.client.getWorldType().contains(WorldType.NOSAVE_MODE) || this.client.getWorldType().contains(WorldType.SEASONAL) || this.client.getWorldType().contains(WorldType.TOURNAMENT_WORLD))) {
            this.suportedWorld = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.suportedWorld) {
            if (this.client.getLocalPlayer().getName() != null && !this.characterInfoSend) {
                Player player = this.client.getLocalPlayer();
                this.characterInfoSend = this.apiCommunication.sendCharacterInfo();
            }
            if (this.config.skillingBosses()) {
                this.skillingBosses.gametickSkillingBoss();
            }
            if (this.config.levelingUp()) {
                this.levelingUp.gametickLevelingUp();
            }
            if (this.config.questCompletion()) {
                this.questCompletion.gametickQuestCompletion();
            }
            if (this.config.tutorialIsland()) {
                this.tutorialIsland.gametickTutorialIsland();
            }
            if (this.config.duelArena()) {
                this.duelArena.gametickDuelArena();
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.suportedWorld) {
            String message = chatMessage.getMessage();
            if (this.config.skillingBosses()) {
                this.skillingBosses.chatSkillingBoss(message);
            }
            if (this.config.musicUnlocks()) {
                this.musicUnlock.chatMusicUnlock(message);
            }
            if (this.config.collectionLog()) {
                this.collectionLog.chatCollectionLog(message);
            }
            if (this.config.bosses()) {
                this.bosses.chatBosses(message);
            }
            if (this.config.clueScrollCompletion()) {
                this.clueScrollCompletion.chatClueScrollCompletion(message);
            }
            if (this.config.soloCombatMinigame()) {
                this.soloCombatMinigame.chatSoloCombatMinigame(message);
            }
        }
    }

    @Provides
    RuneloggerConfig provideConfig(ConfigManager configManager) {
        return (RuneloggerConfig)configManager.getConfig(RuneloggerConfig.class);
    }
}

