/*
 * Decompiled with CFR 0.152.
 */
package com.runelogger;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCommunication {
    private static final Logger log = LoggerFactory.getLogger(ApiCommunication.class);
    @Inject
    private Client client;
    @Inject
    private OkHttpClient CurrentOkHttpClient;

    private String getUsernameHash() {
        String username = "";
        try {
            MessageDigest sha256Digest = MessageDigest.getInstance("SHA-256");
            byte[] usernameHashedBytes = sha256Digest.digest(this.client.getUsername().getBytes(StandardCharsets.UTF_8));
            StringBuilder usernameBuiler = new StringBuilder(usernameHashedBytes.length * 2);
            for (byte b : usernameHashedBytes) {
                usernameBuiler.append(String.format("%02x", b));
            }
            username = usernameBuiler.toString();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Something is wrong");
        }
        return username;
    }

    public boolean sendTutorialInfo(String status) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("status", status).build();
        String file = "processTutorialIsland.php";
        this.sendToApi(file, (RequestBody)formBody);
        return true;
    }

    public void sendLevelingUpInfo(String skill, Integer level) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("skill", skill).add("level", "" + level).build();
        String file = "processLevelUp.php";
        this.sendToApi(file, (RequestBody)formBody);
        this.sendLevelInfo();
    }

    public void sendSkillingBossInfo(String boss, Integer score) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("boss", boss).add("score", "" + score).build();
        String file = "processSkillingBoss.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public void sendQuestCompletionInfo(String quest) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("quest", quest).build();
        String file = "processQuestCompletion.php";
        this.sendToApi(file, (RequestBody)formBody);
        this.sendQuestInfo();
    }

    public void sendBosses(String boss) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("boss", boss).build();
        String file = "processBosses.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public void sendCollectionLog(String item) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("item", item).build();
        String file = "processCollectionLog.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public void sendDuelArena(String outcome, String ownCombat, String opponent, String opponentCombat, String winnings) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("outcome", outcome).add("ownCombat", ownCombat).add("opponent", opponent).add("opponentCombat", opponentCombat).add("winnings", winnings).build();
        String file = "processDuelArena.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public void sendMusicUnlock(String track) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("track", track).build();
        String file = "processMusicUnlock.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public void sendClueScrollCompletion(String type, String reward) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("type", type).add("reward", reward).build();
        String file = "processClueScrollCompletion.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public void sendMinigameTime(String minigame, String type, String time) {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("minigame", minigame).add("type", type).add("time", time).build();
        String file = "processMinigameTime.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    public boolean sendCharacterInfo() {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("characterName", this.client.getLocalPlayer().getName()).add("characterType", this.client.getAccountType().name()).add("memberDays", "" + this.client.getVar(1780)).build();
        String file = "getCharacterInfo.php";
        this.sendToApi(file, (RequestBody)formBody);
        this.sendLevelInfo();
        this.sendQuestInfo();
        return true;
    }

    private void sendLevelInfo() {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("combatLevel", "" + this.client.getLocalPlayer().getCombatLevel()).add("agility", "" + this.client.getRealSkillLevel(Skill.AGILITY)).add("attack", "" + this.client.getRealSkillLevel(Skill.ATTACK)).add("construction", "" + this.client.getRealSkillLevel(Skill.CONSTRUCTION)).add("cooking", "" + this.client.getRealSkillLevel(Skill.COOKING)).add("crafting", "" + this.client.getRealSkillLevel(Skill.CRAFTING)).add("defence", "" + this.client.getRealSkillLevel(Skill.DEFENCE)).add("farming", "" + this.client.getRealSkillLevel(Skill.FARMING)).add("firemaking", "" + this.client.getRealSkillLevel(Skill.FIREMAKING)).add("fishing", "" + this.client.getRealSkillLevel(Skill.FISHING)).add("fletching", "" + this.client.getRealSkillLevel(Skill.FLETCHING)).add("herblore", "" + this.client.getRealSkillLevel(Skill.HERBLORE)).add("hitpoints", "" + this.client.getRealSkillLevel(Skill.HITPOINTS)).add("hunter", "" + this.client.getRealSkillLevel(Skill.HUNTER)).add("magic", "" + this.client.getRealSkillLevel(Skill.MAGIC)).add("mining", "" + this.client.getRealSkillLevel(Skill.MINING)).add("prayer", "" + this.client.getRealSkillLevel(Skill.PRAYER)).add("ranged", "" + this.client.getRealSkillLevel(Skill.RANGED)).add("runecraft", "" + this.client.getRealSkillLevel(Skill.RUNECRAFT)).add("slayer", "" + this.client.getRealSkillLevel(Skill.SLAYER)).add("smithing", "" + this.client.getRealSkillLevel(Skill.SMITHING)).add("strenght", "" + this.client.getRealSkillLevel(Skill.STRENGTH)).add("thieving", "" + this.client.getRealSkillLevel(Skill.THIEVING)).add("woodcutting", "" + this.client.getRealSkillLevel(Skill.WOODCUTTING)).add("overall", "" + this.client.getTotalLevel()).build();
        String file = "getSkillingInfo.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    private void sendQuestInfo() {
        FormBody formBody = new FormBody.Builder().add("username", this.getUsernameHash()).add("questPoints", "" + this.client.getVar(101)).build();
        String file = "getQuestInfo.php";
        this.sendToApi(file, (RequestBody)formBody);
    }

    private void sendToApi(final String file, RequestBody formBody) {
        Request request = new Request.Builder().addHeader("User-Agent", "RuneLite").addHeader("ContentType", "application/x-www-form-urlencoded").url("https://runelogger.com/api/" + file).post(formBody).build();
        this.CurrentOkHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error submitting update, caused by {}.", (Object)e.getMessage());
            }

            public void onResponse(Call call, Response response) {
                log.debug("Succesfully send request to api " + file);
                response.close();
            }
        });
    }
}

