/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.utils;

import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import com.thenwefight.utils.GameUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginUtils.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ThenWeFightPlugin plugin;
    @Inject
    private ThenWeFightConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private GameUtils gameUtils;

    public void setCustomUnlockImageFilePaths() {
        String path6;
        String path5;
        String path4;
        String path3;
        String path2;
        String path1;
        int unlockListLength = ThenWeFightPlugin.rawUnlockList.length;
        int scroll = this.config.unlockScroll();
        if (unlockListLength >= 1 && !this.isNumeric(path1 = ThenWeFightPlugin.rawUnlockList[scroll].split(",")[1])) {
            ThenWeFightPlugin.U_1_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path1);
        }
        if (unlockListLength >= 2 && !this.isNumeric(path2 = ThenWeFightPlugin.rawUnlockList[scroll + 1].split(",")[1])) {
            ThenWeFightPlugin.U_2_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path2);
        }
        if (unlockListLength >= 3 && !this.isNumeric(path3 = ThenWeFightPlugin.rawUnlockList[scroll + 2].split(",")[1])) {
            ThenWeFightPlugin.U_3_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path3);
        }
        if (unlockListLength >= 4 && !this.isNumeric(path4 = ThenWeFightPlugin.rawUnlockList[scroll + 3].split(",")[1])) {
            ThenWeFightPlugin.U_4_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path4);
        }
        if (unlockListLength >= 5 && !this.isNumeric(path5 = ThenWeFightPlugin.rawUnlockList[scroll + 4].split(",")[1])) {
            ThenWeFightPlugin.U_5_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path5);
        }
        if (unlockListLength >= 6 && !this.isNumeric(path6 = ThenWeFightPlugin.rawUnlockList[scroll + 5].split(",")[1])) {
            ThenWeFightPlugin.U_6_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path6);
        }
        this.loadCustomUnlockImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomUnlockImages() {
        int imageWidth = this.config.unlockImageWidth();
        int imageHeight = this.config.unlockImageHeight();
        if (ThenWeFightPlugin.U_1_CUSTOM_DIR.exists()) {
            try {
                Class<ImageIO> clazz = ImageIO.class;
                synchronized (ImageIO.class) {
                    this.plugin.u1Custom = ImageIO.read(ThenWeFightPlugin.U_1_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                log.error("thenwefightplugin: error setting custom task 1 image", (Throwable)e);
            }
        } else {
            log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.U_1_CUSTOM_DIR.getAbsolutePath());
            this.plugin.u1Custom = null;
        }
        {
            Class<ImageIO> e;
            if (ThenWeFightPlugin.U_2_CUSTOM_DIR.exists()) {
                try {
                    e = ImageIO.class;
                    synchronized (ImageIO.class) {
                        this.plugin.u2Custom = ImageIO.read(ThenWeFightPlugin.U_2_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                        // ** MonitorExit[e] (shouldn't be in output)
                    }
                }
                catch (Exception e2) {
                    log.error("thenwefightplugin: error setting custom task 2 image", (Throwable)e2);
                }
            } else {
                log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.U_2_CUSTOM_DIR.getAbsolutePath());
                this.plugin.u2Custom = null;
            }
            {
                if (ThenWeFightPlugin.U_3_CUSTOM_DIR.exists()) {
                    try {
                        e = ImageIO.class;
                        synchronized (ImageIO.class) {
                            this.plugin.u3Custom = ImageIO.read(ThenWeFightPlugin.U_3_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                            // ** MonitorExit[e] (shouldn't be in output)
                        }
                    }
                    catch (Exception e3) {
                        log.error("thenwefightplugin: error setting custom task 3 image", (Throwable)e3);
                    }
                } else {
                    log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.U_3_CUSTOM_DIR.getAbsolutePath());
                    this.plugin.u3Custom = null;
                }
                {
                    if (ThenWeFightPlugin.U_4_CUSTOM_DIR.exists()) {
                        try {
                            e = ImageIO.class;
                            synchronized (ImageIO.class) {
                                this.plugin.u4Custom = ImageIO.read(ThenWeFightPlugin.U_4_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                                // ** MonitorExit[e] (shouldn't be in output)
                            }
                        }
                        catch (Exception e4) {
                            log.error("thenwefightplugin: error setting custom task 4 image", (Throwable)e4);
                        }
                    } else {
                        log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.U_4_CUSTOM_DIR.getAbsolutePath());
                        this.plugin.u4Custom = null;
                    }
                    {
                        if (ThenWeFightPlugin.U_5_CUSTOM_DIR.exists()) {
                            try {
                                e = ImageIO.class;
                                synchronized (ImageIO.class) {
                                    this.plugin.u5Custom = ImageIO.read(ThenWeFightPlugin.U_5_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                                    // ** MonitorExit[e] (shouldn't be in output)
                                }
                            }
                            catch (Exception e5) {
                                log.error("thenwefightplugin: error setting custom task 5 image", (Throwable)e5);
                            }
                        } else {
                            log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.U_5_CUSTOM_DIR.getAbsolutePath());
                            this.plugin.u5Custom = null;
                        }
                        {
                            if (ThenWeFightPlugin.U_6_CUSTOM_DIR.exists()) {
                                try {
                                    e = ImageIO.class;
                                    synchronized (ImageIO.class) {
                                        this.plugin.u6Custom = ImageIO.read(ThenWeFightPlugin.U_6_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                                        // ** MonitorExit[e] (shouldn't be in output)
                                    }
                                }
                                catch (Exception e6) {
                                    log.error("thenwefightplugin: error setting custom task 6 image", (Throwable)e6);
                                }
                            } else {
                                log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.U_6_CUSTOM_DIR.getAbsolutePath());
                                this.plugin.u6Custom = null;
                            }
                            {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    public void setCustomItemUnlockImageFilePaths() {
        String path6;
        String path5;
        String path4;
        String path3;
        String path2;
        String path1;
        int unlockListLength = ThenWeFightPlugin.rawItemUnlockList.length;
        int scroll = this.config.itemUnlockScroll();
        if (unlockListLength >= 1 && !this.isNumeric(path1 = ThenWeFightPlugin.rawItemUnlockList[scroll].split(",")[1])) {
            ThenWeFightPlugin.IU_1_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path1);
        }
        if (unlockListLength >= 2 && !this.isNumeric(path2 = ThenWeFightPlugin.rawItemUnlockList[scroll + 1].split(",")[1])) {
            ThenWeFightPlugin.IU_2_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path2);
        }
        if (unlockListLength >= 3 && !this.isNumeric(path3 = ThenWeFightPlugin.rawItemUnlockList[scroll + 2].split(",")[1])) {
            ThenWeFightPlugin.IU_3_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path3);
        }
        if (unlockListLength >= 4 && !this.isNumeric(path4 = ThenWeFightPlugin.rawItemUnlockList[scroll + 3].split(",")[1])) {
            ThenWeFightPlugin.IU_4_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path4);
        }
        if (unlockListLength >= 5 && !this.isNumeric(path5 = ThenWeFightPlugin.rawItemUnlockList[scroll + 4].split(",")[1])) {
            ThenWeFightPlugin.IU_5_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path5);
        }
        if (unlockListLength >= 6 && !this.isNumeric(path6 = ThenWeFightPlugin.rawItemUnlockList[scroll + 5].split(",")[1])) {
            ThenWeFightPlugin.IU_6_CUSTOM_DIR = new File(ThenWeFightPlugin.THEN_WE_FIGHT_FOLDER + File.separator + path6);
        }
        this.loadCustomItemUnlockImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomItemUnlockImages() {
        int imageWidth = this.config.unlockImageWidth();
        int imageHeight = this.config.unlockImageHeight();
        if (ThenWeFightPlugin.IU_1_CUSTOM_DIR.exists()) {
            try {
                Class<ImageIO> clazz = ImageIO.class;
                synchronized (ImageIO.class) {
                    this.plugin.iu1Custom = ImageIO.read(ThenWeFightPlugin.IU_1_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                log.error("thenwefightplugin: error setting custom task 1 image", (Throwable)e);
            }
        } else {
            log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.IU_1_CUSTOM_DIR.getAbsolutePath());
            this.plugin.iu1Custom = null;
        }
        {
            Class<ImageIO> e;
            if (ThenWeFightPlugin.IU_2_CUSTOM_DIR.exists()) {
                try {
                    e = ImageIO.class;
                    synchronized (ImageIO.class) {
                        this.plugin.iu2Custom = ImageIO.read(ThenWeFightPlugin.IU_2_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                        // ** MonitorExit[e] (shouldn't be in output)
                    }
                }
                catch (Exception e2) {
                    log.error("thenwefightplugin: error setting custom task 2 image", (Throwable)e2);
                }
            } else {
                log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.IU_2_CUSTOM_DIR.getAbsolutePath());
                this.plugin.iu2Custom = null;
            }
            {
                if (ThenWeFightPlugin.IU_3_CUSTOM_DIR.exists()) {
                    try {
                        e = ImageIO.class;
                        synchronized (ImageIO.class) {
                            this.plugin.iu3Custom = ImageIO.read(ThenWeFightPlugin.IU_3_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                            // ** MonitorExit[e] (shouldn't be in output)
                        }
                    }
                    catch (Exception e3) {
                        log.error("thenwefightplugin: error setting custom task 3 image", (Throwable)e3);
                    }
                } else {
                    log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.IU_3_CUSTOM_DIR.getAbsolutePath());
                    this.plugin.iu3Custom = null;
                }
                {
                    if (ThenWeFightPlugin.IU_4_CUSTOM_DIR.exists()) {
                        try {
                            e = ImageIO.class;
                            synchronized (ImageIO.class) {
                                this.plugin.iu4Custom = ImageIO.read(ThenWeFightPlugin.IU_4_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                                // ** MonitorExit[e] (shouldn't be in output)
                            }
                        }
                        catch (Exception e4) {
                            log.error("thenwefightplugin: error setting custom task 4 image", (Throwable)e4);
                        }
                    } else {
                        log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.IU_4_CUSTOM_DIR.getAbsolutePath());
                        this.plugin.iu4Custom = null;
                    }
                    {
                        if (ThenWeFightPlugin.IU_5_CUSTOM_DIR.exists()) {
                            try {
                                e = ImageIO.class;
                                synchronized (ImageIO.class) {
                                    this.plugin.iu5Custom = ImageIO.read(ThenWeFightPlugin.IU_5_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                                    // ** MonitorExit[e] (shouldn't be in output)
                                }
                            }
                            catch (Exception e5) {
                                log.error("thenwefightplugin: error setting custom task 5 image", (Throwable)e5);
                            }
                        } else {
                            log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.IU_5_CUSTOM_DIR.getAbsolutePath());
                            this.plugin.iu5Custom = null;
                        }
                        {
                            if (ThenWeFightPlugin.IU_6_CUSTOM_DIR.exists()) {
                                try {
                                    e = ImageIO.class;
                                    synchronized (ImageIO.class) {
                                        this.plugin.iu6Custom = ImageIO.read(ThenWeFightPlugin.IU_6_CUSTOM_DIR).getScaledInstance(imageWidth, imageHeight, 1);
                                        // ** MonitorExit[e] (shouldn't be in output)
                                    }
                                }
                                catch (Exception e6) {
                                    log.error("thenwefightplugin: error setting custom task 6 image", (Throwable)e6);
                                }
                            } else {
                                log.error("thenwefightplugin: error cannot find image in " + ThenWeFightPlugin.IU_6_CUSTOM_DIR.getAbsolutePath());
                                this.plugin.iu6Custom = null;
                            }
                            {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    public void loadResources() {
        try {
            this.plugin.background = ImageUtil.loadImageResource(((Object)((Object)this.plugin)).getClass(), (String)"background.png");
            this.plugin.debugBackground = ImageUtil.loadImageResource(((Object)((Object)this.plugin)).getClass(), (String)"debug.png");
            this.plugin.runOrb = ImageUtil.loadImageResource(((Object)((Object)this.plugin)).getClass(), (String)"run.png");
            this.plugin.specOrb = ImageUtil.loadImageResource(((Object)((Object)this.plugin)).getClass(), (String)"spec.png");
            this.plugin.healthOrb = ImageUtil.loadImageResource(((Object)((Object)this.plugin)).getClass(), (String)"health.png");
            this.plugin.prayerOrb = ImageUtil.loadImageResource(((Object)((Object)this.plugin)).getClass(), (String)"prayer.png");
        }
        catch (Exception e) {
            log.error("thenwefightplugin, error loading image resources", (Throwable)e);
        }
    }

    public void updateItemList() {
        ThenWeFightPlugin.unlockedItems.clear();
        ThenWeFightPlugin.unlockedItems.addAll(this.stringToIntList(this.config.unlockedItems()));
    }

    public void updateNpcList() {
        ThenWeFightPlugin.unlockedNpcs.clear();
        ThenWeFightPlugin.unlockedNpcs.addAll(Text.fromCSV((String)Text.standardize((String)this.config.unlockedNpcs())));
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.clientThread.invoke(this::updateNpcs);
        }
    }

    public void updateWidgetList() {
        ThenWeFightPlugin.lockedWidgets.clear();
        ThenWeFightPlugin.lockedWidgets.addAll(this.stringToIntList(this.config.lockedWidgets()));
    }

    public void updateGameObjectList() {
        ThenWeFightPlugin.lockedObjects.clear();
        ThenWeFightPlugin.lockedObjects.addAll(Text.fromCSV((String)Text.standardize((String)this.config.lockedGameObjects())));
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.clientThread.invoke(this::updateGameObjects);
        }
    }

    public void updateTaskList() {
        String raw = this.config.taskList();
        ThenWeFightPlugin.rawTaskList = raw.split("\n");
    }

    public void updateUnlockList() {
        String raw = this.config.unlockList();
        ThenWeFightPlugin.rawUnlockList = raw.split("\n");
    }

    public void updateItemUnlockList() {
        String raw = this.config.itemUnlockList();
        ThenWeFightPlugin.rawItemUnlockList = raw.split("\n");
    }

    public void updateGameObjects() {
        ThenWeFightPlugin.gameObjects.clear();
        ThenWeFightPlugin.wallObjects.clear();
        ThenWeFightPlugin.groundObjects.clear();
        if (this.config.lockGameObjects()) {
            for (String s : ThenWeFightPlugin.lockedObjects) {
                ThenWeFightPlugin.gameObjects.addAll(this.gameUtils.getGameObjects(s));
                ThenWeFightPlugin.wallObjects.addAll(this.gameUtils.getWallObjects(s));
                ThenWeFightPlugin.groundObjects.addAll(this.gameUtils.getGroundObjects(s));
            }
        }
        if (this.config.lockBanks()) {
            for (String s : ThenWeFightPlugin.BANK_OBJECT_NAMES) {
                ThenWeFightPlugin.gameObjects.addAll(this.gameUtils.getGameObjects(s));
                ThenWeFightPlugin.wallObjects.addAll(this.gameUtils.getWallObjects(s));
                ThenWeFightPlugin.groundObjects.addAll(this.gameUtils.getGroundObjects(s));
            }
        }
        if (this.config.lockUnderground()) {
            for (String s : ThenWeFightPlugin.UNDERGROUND_OBJECT_NAMES) {
                ThenWeFightPlugin.gameObjects.addAll(this.gameUtils.getGameObjects(s));
                ThenWeFightPlugin.wallObjects.addAll(this.gameUtils.getWallObjects(s));
                ThenWeFightPlugin.groundObjects.addAll(this.gameUtils.getGroundObjects(s));
            }
        }
        if (this.config.lockDoors()) {
            for (String s : ThenWeFightPlugin.DOOR_OBJECT_NAMES) {
                ThenWeFightPlugin.gameObjects.addAll(this.gameUtils.getGameObjects(s));
                ThenWeFightPlugin.wallObjects.addAll(this.gameUtils.getWallObjects(s));
                ThenWeFightPlugin.groundObjects.addAll(this.gameUtils.getGroundObjects(s));
            }
        }
        if (this.config.lockStairs()) {
            for (String s : ThenWeFightPlugin.STAIRS_OBJECT_NAMES) {
                ThenWeFightPlugin.gameObjects.addAll(this.gameUtils.getGameObjects(s));
                ThenWeFightPlugin.wallObjects.addAll(this.gameUtils.getWallObjects(s));
                ThenWeFightPlugin.groundObjects.addAll(this.gameUtils.getGroundObjects(s));
            }
        }
    }

    public void updateNpcs() {
        ThenWeFightPlugin.npcs.clear();
        if (this.config.unlockNpcs()) {
            ThenWeFightPlugin.npcs.addAll(this.gameUtils.getExcludedNpcs(ThenWeFightPlugin.unlockedNpcs));
        }
        if (this.config.lockBanks()) {
            ThenWeFightPlugin.npcs.addAll(this.gameUtils.getIncludedNpcs(ThenWeFightPlugin.BANK_NPC_NAMES));
        }
    }

    public void unlockAllItems(MenuEntry entry) {
        for (Widget w : this.gameUtils.getAllItems()) {
            int id = w.getItemId();
            if (id == -1 || id == 6512 || id == 0 || ThenWeFightPlugin.unlockedItems.contains(id)) continue;
            ThenWeFightPlugin.unlockedItems.add(id);
        }
        this.configManager.setConfiguration("thenwefight", "unlockedItems", ThenWeFightPlugin.unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
    }

    public void lockAllItems(MenuEntry entry) {
        for (Widget w : this.gameUtils.getAllItems()) {
            int id = w.getItemId();
            if (id == -1 || id == 6512 || id == 0 || !ThenWeFightPlugin.unlockedItems.contains(id)) continue;
            ThenWeFightPlugin.unlockedItems.remove((Object)id);
        }
        this.configManager.setConfiguration("thenwefight", "unlockedItems", ThenWeFightPlugin.unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
    }

    public void unlockAllFood(MenuEntry entry) {
        for (Widget w : this.gameUtils.getAllItems()) {
            ItemComposition ic;
            int id = w.getItemId();
            if (id == -1 || id == 6512 || id == 0 || (ic = this.itemManager.getItemComposition(id)) == null) continue;
            for (String s : ic.getInventoryActions()) {
                if (s == null || s.equals("") || !ThenWeFightPlugin.EAT_OPTIONS.contains(s.toLowerCase()) && !ThenWeFightPlugin.DRINK_OPTIONS.contains(s.toLowerCase()) || ThenWeFightPlugin.unlockedItems.contains(id)) continue;
                ThenWeFightPlugin.unlockedItems.add(id);
            }
        }
        this.configManager.setConfiguration("thenwefight", "unlockedItems", ThenWeFightPlugin.unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
    }

    public void lockAllFood(MenuEntry entry) {
        for (Widget w : this.gameUtils.getAllItems()) {
            ItemComposition ic;
            int id = w.getItemId();
            if (id == -1 || id == 6512 || id == 0 || (ic = this.itemManager.getItemComposition(id)) == null) continue;
            for (String s : ic.getInventoryActions()) {
                if (s == null || s.equals("") || !ThenWeFightPlugin.EAT_OPTIONS.contains(s.toLowerCase()) && !ThenWeFightPlugin.DRINK_OPTIONS.contains(s.toLowerCase()) || !ThenWeFightPlugin.unlockedItems.contains(id)) continue;
                ThenWeFightPlugin.unlockedItems.remove((Object)id);
            }
        }
        this.configManager.setConfiguration("thenwefight", "unlockedItems", ThenWeFightPlugin.unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
    }

    public void unlockAllEquipment(MenuEntry entry) {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return;
        }
        for (KitType kitType : KitType.values()) {
            int itemId;
            if (local.getPlayerComposition() == null || (itemId = local.getPlayerComposition().getEquipmentId(kitType)) == -1 || itemId == 6512 || itemId == 0 || ThenWeFightPlugin.unlockedItems.contains(itemId)) continue;
            ThenWeFightPlugin.unlockedItems.add(itemId);
        }
        this.configManager.setConfiguration("thenwefight", "unlockedItems", ThenWeFightPlugin.unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
    }

    public void lockAllEquipment(MenuEntry entry) {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return;
        }
        for (KitType kitType : KitType.values()) {
            int itemId;
            if (local.getPlayerComposition() == null || (itemId = local.getPlayerComposition().getEquipmentId(kitType)) == -1 || itemId == 6512 || itemId == 0 || !ThenWeFightPlugin.unlockedItems.contains(itemId)) continue;
            ThenWeFightPlugin.unlockedItems.remove((Object)itemId);
        }
        this.configManager.setConfiguration("thenwefight", "unlockedItems", ThenWeFightPlugin.unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
    }

    public List<Integer> stringToIntList(String string) {
        return string == null || string.trim().equals("") ? Arrays.asList(0) : Arrays.stream(string.split(",")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
    }

    public boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

