/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.utils;

import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;

public class GameUtils {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ThenWeFightPlugin plugin;
    @Inject
    private ThenWeFightConfig config;

    public Collection<NPC> getExcludedNpcs(Collection<String> names) {
        ArrayList<NPC> excludedNpcs = new ArrayList<NPC>();
        for (NPC n : this.client.getNpcs()) {
            if (n == null || n.getName() == null || n.getName().equals("") || names.contains(n.getName().toLowerCase()) || ThenWeFightPlugin.npcs.contains(n)) continue;
            excludedNpcs.add(n);
        }
        return excludedNpcs;
    }

    public Collection<NPC> getIncludedNpcs(Collection<String> names) {
        ArrayList<NPC> includedNpcs = new ArrayList<NPC>();
        for (NPC n : this.client.getNpcs()) {
            if (n == null || n.getName() == null || n.getName().equals("") || !names.contains(n.getName().toLowerCase()) || ThenWeFightPlugin.npcs.contains(n)) continue;
            includedNpcs.add(n);
        }
        return includedNpcs;
    }

    public Collection<GameObject> getGameObjects(String names) {
        Player local = this.client.getLocalPlayer();
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        ArrayList<GameObject> tileGameObjects = new ArrayList<GameObject>();
        Tile[][] tileArray = tiles[local.getWorldLocation().getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] tiles1;
            for (Tile tile : tiles1 = tileArray[i]) {
                if (tile == null) continue;
                for (GameObject g : tile.getGameObjects()) {
                    String name;
                    if (g == null || g.getWorldLocation().getPlane() != local.getWorldLocation().getPlane() || (name = this.getGameObjectName(g.getId())) == null || name.equals("") || !names.contains(name) || tileGameObjects.contains(g) || ThenWeFightPlugin.gameObjects.contains(g)) continue;
                    tileGameObjects.add(g);
                }
            }
        }
        return tileGameObjects;
    }

    public Collection<WallObject> getWallObjects(String names) {
        Player local = this.client.getLocalPlayer();
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        ArrayList<WallObject> tileWallObjects = new ArrayList<WallObject>();
        Tile[][] tileArray = tiles[local.getWorldLocation().getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] tiles1;
            for (Tile tile : tiles1 = tileArray[i]) {
                String name;
                if (tile == null || tile.getWallObject() == null || tile.getWallObject().getWorldLocation().getPlane() != local.getWorldLocation().getPlane() || (name = this.getGameObjectName(tile.getWallObject().getId())) == null || name.equals("") || !names.contains(name) || tileWallObjects.contains(tile.getWallObject()) || ThenWeFightPlugin.wallObjects.contains(tile.getWallObject())) continue;
                tileWallObjects.add(tile.getWallObject());
            }
        }
        return tileWallObjects;
    }

    public Collection<GroundObject> getGroundObjects(String names) {
        Player local = this.client.getLocalPlayer();
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        ArrayList<GroundObject> tileGroundObjects = new ArrayList<GroundObject>();
        Tile[][] tileArray = tiles[local.getWorldLocation().getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] tiles1;
            for (Tile tile : tiles1 = tileArray[i]) {
                String name;
                if (tile == null || tile.getGroundObject() == null || tile.getGroundObject().getWorldLocation().getPlane() != local.getWorldLocation().getPlane() || (name = this.getGameObjectName(tile.getGroundObject().getId())) == null || name.equals("") || !names.contains(name) || tileGroundObjects.contains(tile.getGroundObject()) || ThenWeFightPlugin.groundObjects.contains(tile.getGroundObject())) continue;
                tileGroundObjects.add(tile.getGroundObject());
            }
        }
        return tileGroundObjects;
    }

    @Nullable
    public ObjectComposition getObjectComposition(int id) {
        ObjectComposition objectComposition = this.client.getObjectDefinition(id);
        return objectComposition.getImpostorIds() == null ? objectComposition : objectComposition.getImpostor();
    }

    public String getGameObjectName(int id) {
        ObjectComposition objectComposition = this.getObjectComposition(id);
        if (objectComposition == null || objectComposition.getName() == null || objectComposition.getName().equals("")) {
            return "";
        }
        return objectComposition.getName().toLowerCase();
    }

    public Collection<Widget> getAllItems() {
        Widget[] inventoryItems;
        Widget inventory = this.client.getWidget(WidgetInfo.INVENTORY);
        if (inventory == null) {
            return null;
        }
        if (this.isWidgetInventoryContainer(inventory) && inventory.isHidden()) {
            this.refreshInventory();
        }
        if ((inventoryItems = inventory.getChildren()) == null || inventoryItems.length == 0) {
            return null;
        }
        return Arrays.stream(inventoryItems).collect(Collectors.toList());
    }

    public boolean isWidgetInventoryContainer(Widget widget) {
        Widget inventory = this.client.getWidget(WidgetInfo.INVENTORY);
        return widget != null && inventory != null && widget.getId() == inventory.getId();
    }

    public void refreshInventory() {
        if (!this.client.isClientThread()) {
            this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{6009, WidgetInfo.INVENTORY.getId(), 28, 1, -1}));
            return;
        }
        this.client.runScript(new Object[]{6009, WidgetInfo.INVENTORY.getId(), 28, 1, -1});
    }
}

