/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.overlay;

import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThenWeFightWidgetOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ThenWeFightWidgetOverlay.class);
    @Inject
    private Client client;
    private final ThenWeFightConfig config;
    private final ThenWeFightPlugin plugin;

    @Inject
    private ThenWeFightWidgetOverlay(Client client, ThenWeFightConfig config, ThenWeFightPlugin plugin) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        Widget emoteTab;
        Widget[] skills;
        Widget skillsTab;
        Widget[] spells;
        Widget spellsTab;
        Widget hpOrb;
        Widget runOrb;
        Player local = this.client.getLocalPlayer();
        if (this.plugin == null || local == null) {
            return null;
        }
        if (this.config.lockWidgets()) {
            for (int i : ThenWeFightPlugin.lockedWidgets) {
                Widget custom = this.client.getWidget(i);
                if (custom == null || custom.isHidden()) continue;
                this.renderWidgetOverlay(graphics, custom, this.config.uiOverlayColour());
            }
        }
        if (this.config.lockRunEnergy() && (runOrb = this.client.getWidget(WidgetInfo.MINIMAP_RUN_ORB)) != null && !runOrb.isHidden()) {
            ThenWeFightWidgetOverlay.renderImageLocation(graphics, runOrb.getBounds().getLocation(), this.plugin.getRunOrb());
        }
        if (this.config.lockPrayer()) {
            Widget[] prayers;
            Widget prayerTab;
            Widget prayOrb = this.client.getWidget(WidgetInfo.MINIMAP_PRAYER_ORB);
            if (prayOrb != null && !prayOrb.isHidden()) {
                ThenWeFightWidgetOverlay.renderImageLocation(graphics, prayOrb.getBounds().getLocation(), this.plugin.getPrayerOrb());
            }
            if ((prayerTab = this.client.getWidget(35454980)) != null && !prayerTab.isHidden() && (prayers = prayerTab.getStaticChildren()) != null) {
                Widget[] widgetArray = prayers;
                int n = widgetArray.length;
                for (int i = 0; i < n; ++i) {
                    Widget prayer = widgetArray[i];
                    String name = Text.standardize((String)prayer.getName());
                    if (prayer.isHidden() || !(this.config.lockThickSkin() && name.equals("thick skin") || this.config.lockBurstOfStrength() && name.equals("burst of strength") || this.config.lockClarityOfThought() && name.equals("clarity of thought") || this.config.lockRockSkin() && name.equals("rock skin") || this.config.lockSuperhumanStrength() && name.equals("superhuman strength") || this.config.lockImprovedReflexes() && name.equals("improved reflexes") || this.config.lockRapidRestore() && name.equals("rapid restore") || this.config.lockRapidHeal() && name.equals("rapid heal") || this.config.lockProtectItem() && name.equals("protect item") || this.config.lockSteelSkin() && name.equals("steel skin") || this.config.lockUltimateStrength() && name.equals("ultimate strength") || this.config.lockIncredibleReflexes() && name.equals("incredible reflexes") || this.config.lockProtectFromMagic() && name.equals("protect from magic") || this.config.lockProtectFromMissiles() && name.equals("protect from missiles") || this.config.lockProtectFromMelee() && name.equals("protect from melee") || this.config.lockRetribution() && name.equals("retribution") || this.config.lockRedemption() && name.equals("redemption") || this.config.lockSmite() && name.equals("smite") || this.config.lockSharpEye() && name.equals("sharp eye") || this.config.lockMysticWill() && name.equals("mystic will") || this.config.lockHawkEye() && name.equals("hawk eye") || this.config.lockMysticLore() && name.equals("mystic lore") || this.config.lockEagleEye() && name.equals("eagle eye") || this.config.lockMysticMight() && name.equals("mystic might") || this.config.lockChivalry() && name.equals("chivalry") || this.config.lockPiety() && name.equals("piety") || this.config.lockRigour() && name.equals("rigour") || this.config.lockAugury() && name.equals("augury")) && (!this.config.lockPreserve() || !name.equals("preserve"))) continue;
                    this.renderWidgetOverlay(graphics, prayer, this.config.uiOverlayColour());
                }
            }
        }
        if (this.config.lockSpec()) {
            Widget specBar;
            Widget specOrb = this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB);
            if (specOrb != null && !specOrb.isHidden()) {
                ThenWeFightWidgetOverlay.renderImageLocation(graphics, specOrb.getBounds().getLocation(), this.plugin.getSpecOrb());
            }
            if ((specBar = this.client.getWidget(38862888)) != null && !specBar.isHidden()) {
                this.renderWidgetOverlay(graphics, specBar, this.config.uiOverlayColour());
            }
        }
        if (this.config.lockHitpoints() && (hpOrb = this.client.getWidget(WidgetInfo.MINIMAP_HEALTH_ORB)) != null && !hpOrb.isHidden()) {
            ThenWeFightWidgetOverlay.renderImageLocation(graphics, hpOrb.getBounds().getLocation(), this.plugin.getHealthOrb());
        }
        if (this.config.lockTeles() && (spellsTab = this.client.getWidget(14286851)) != null && !spellsTab.isHidden() && (spells = spellsTab.getStaticChildren()) != null) {
            for (Widget spell : spells) {
                if (spell.isHidden() || !spell.getName().toLowerCase().contains("tele")) continue;
                this.renderWidgetOverlay(graphics, spell, this.config.uiOverlayColour());
            }
        }
        if ((skillsTab = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER)) != null && !skillsTab.isHidden() && (skills = skillsTab.getStaticChildren()) != null) {
            for (Widget skill : skills) {
                if (skill.isHidden() || skill.getId() == 20971548 || !(this.config.lockAttack() && skill.getId() == 0x1400001 || this.config.lockStrength() && skill.getId() == 20971522 || this.config.lockDefence() && skill.getId() == 20971523 || this.config.lockRange() && skill.getId() == 0x1400004 || this.config.lockPrayer() && skill.getId() == 20971525 || this.config.lockMagic() && skill.getId() == 20971526 || this.config.lockRunecrafting() && skill.getId() == 20971527 || this.config.lockConstruction() && skill.getId() == 20971528 || this.config.lockHitpoints() && skill.getId() == 20971529 || this.config.lockAgility() && skill.getId() == 20971530 || this.config.lockHerblore() && skill.getId() == 20971531 || this.config.lockThieving() && skill.getId() == 20971532 || this.config.lockCrafting() && skill.getId() == 20971533 || this.config.lockFletching() && skill.getId() == 20971534 || this.config.lockSlayer() && skill.getId() == 20971535 || this.config.lockHunter() && skill.getId() == 0x1400010 || this.config.lockMining() && skill.getId() == 0x1400011 || this.config.lockSmithing() && skill.getId() == 20971538 || this.config.lockFishing() && skill.getId() == 20971539 || this.config.lockCooking() && skill.getId() == 0x1400014 || this.config.lockFiremaking() && skill.getId() == 20971541 || this.config.lockWoodcutting() && skill.getId() == 20971542) && (!this.config.lockFarming() || skill.getId() != 20971543)) continue;
                this.renderWidgetOverlay(graphics, skill, this.config.uiOverlayColour());
            }
        }
        if (this.config.lockEmotes() && (emoteTab = this.client.getWidget(WidgetInfo.EMOTE_CONTAINER)) != null && !emoteTab.isHidden()) {
            this.renderWidgetOverlay(graphics, emoteTab, this.config.uiOverlayColour());
        }
        if (this.config.lockHopping()) {
            Widget switchWorlds;
            Widget worldList = this.client.getWidget(0x450000);
            if (worldList != null && !worldList.isHidden()) {
                this.renderWidgetOverlay(graphics, worldList, this.config.uiOverlayColour());
            }
            if ((switchWorlds = this.client.getWidget(11927559)) != null && !switchWorlds.isHidden()) {
                this.renderWidgetOverlay(graphics, switchWorlds, this.config.uiOverlayColour());
            }
        }
        return null;
    }

    private void renderPolyFill(Graphics2D graphics, Color color, Shape polygon, boolean fill) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(1.2f));
            graphics.draw(polygon);
            graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)this.config.opacity()));
            graphics.fill(polygon);
        }
    }

    private void renderWidgetOverlay(Graphics2D graphics, Widget widget, Color color) {
        Rectangle bounds = widget.getBounds();
        if (bounds != null) {
            this.renderPolyFill(graphics, color, bounds, true);
        }
    }

    public static void renderImageLocation(Graphics2D graphics, Point loc, Image image) {
        graphics.drawImage(image, loc.x, loc.y, null);
    }
}

