/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.overlay;

import com.google.common.base.Strings;
import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import com.thenwefight.utils.PluginUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThenWeFightUnlockOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ThenWeFightUnlockOverlay.class);
    @Inject
    private ItemManager itemManager;
    @Inject
    private PluginUtils pluginUtils;
    private final Client client;
    private final ThenWeFightConfig config;
    private final ThenWeFightPlugin plugin;
    private static final Font FONT = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
    private static final String TITLE = "Then We Fight Unlocks";

    @Inject
    private ThenWeFightUnlockOverlay(Client client, ThenWeFightConfig config, ThenWeFightPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        graphics.setFont(FONT);
        if (!this.plugin.unlockOverlayVisible) {
            return null;
        }
        Point overlay = new Point(this.config.overlayX(), this.config.overlayY());
        Point title = new Point(overlay.x - graphics.getFontMetrics().stringWidth(TITLE) / 2 + 244, overlay.y + graphics.getFontMetrics().getHeight() + 9);
        Point points = new Point(overlay.x + 20, overlay.y + graphics.getFontMetrics().getHeight() + 9);
        if (this.config.debug()) {
            if (this.plugin.getDebugBackground() != null) {
                ThenWeFightUnlockOverlay.renderImageLocation(graphics, overlay, this.plugin.getDebugBackground());
            }
        } else if (this.plugin.getBackground() != null) {
            ThenWeFightUnlockOverlay.renderImageLocation(graphics, overlay, this.plugin.getBackground());
        }
        ThenWeFightUnlockOverlay.renderTextLocation(graphics, title, TITLE, Color.YELLOW);
        ThenWeFightUnlockOverlay.renderTextLocation(graphics, points, this.config.points(), Color.YELLOW);
        this.renderSlots(graphics, overlay);
        return null;
    }

    public void renderSlots(Graphics2D graphics, Point overlay) {
        for (int i = this.config.unlockScroll(); i <= ThenWeFightPlugin.rawUnlockList.length && i < this.config.unlockScroll() + 6; ++i) {
            String[] parsed;
            if (i >= ThenWeFightPlugin.rawUnlockList.length || ThenWeFightPlugin.rawUnlockList[i] == null || (parsed = ThenWeFightPlugin.rawUnlockList[i].split(",")) == null || parsed.length != 4) continue;
            boolean unlocked = parsed[0].equalsIgnoreCase("y");
            boolean useItemImage = this.pluginUtils.isNumeric(parsed[1]);
            String points = parsed[2] + " Points";
            String title = parsed[3];
            int itemId = -1;
            if (useItemImage) {
                itemId = Integer.parseInt(parsed[1]);
            }
            this.renderSlot(graphics, overlay, i - this.config.unlockScroll() + 1, unlocked, title, points, useItemImage, itemId);
        }
    }

    public void renderSlot(Graphics2D graphics, Point overlay, int slot, boolean unlocked, String title, String price, boolean useItemImage, int itemId) {
        Point titlePoint = null;
        int iamgeWidth = this.config.unlockImageWidth();
        int imageHeight = this.config.unlockImageHeight();
        Image itemImage = null;
        Point imagePoint = null;
        Point pricePoint = null;
        switch (slot) {
            case 1: {
                if (title.equals("")) break;
                if (!useItemImage && this.plugin.getU1Custom() == null) {
                    useItemImage = true;
                }
                titlePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(title) / 2 + 90, overlay.y + graphics.getFontMetrics().getHeight() + 97);
                itemImage = ((Image)(useItemImage ? this.itemManager.getImage(itemId) : this.plugin.getU1Custom())).getScaledInstance(iamgeWidth, imageHeight, 1);
                imagePoint = new Point(overlay.x + 88 - iamgeWidth / 2, overlay.y + 72 - imageHeight / 2);
                pricePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(price) / 2 + 90, overlay.y + graphics.getFontMetrics().getHeight() + 122);
                break;
            }
            case 2: {
                if (title.equals("")) break;
                if (!useItemImage && this.plugin.getU2Custom() == null) {
                    useItemImage = true;
                }
                titlePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(title) / 2 + 244, overlay.y + graphics.getFontMetrics().getHeight() + 97);
                itemImage = ((Image)(useItemImage ? this.itemManager.getImage(itemId) : this.plugin.getU2Custom())).getScaledInstance(iamgeWidth, imageHeight, 1);
                imagePoint = new Point(overlay.x + 242 - iamgeWidth / 2, overlay.y + 72 - imageHeight / 2);
                pricePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(price) / 2 + 244, overlay.y + graphics.getFontMetrics().getHeight() + 122);
                break;
            }
            case 3: {
                if (title.equals("")) break;
                if (!useItemImage && this.plugin.getU3Custom() == null) {
                    useItemImage = true;
                }
                titlePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(title) / 2 + 398, overlay.y + graphics.getFontMetrics().getHeight() + 97);
                itemImage = ((Image)(useItemImage ? this.itemManager.getImage(itemId) : this.plugin.getU3Custom())).getScaledInstance(iamgeWidth, imageHeight, 1);
                imagePoint = new Point(overlay.x + 396 - iamgeWidth / 2, overlay.y + 72 - imageHeight / 2);
                pricePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(price) / 2 + 398, overlay.y + graphics.getFontMetrics().getHeight() + 122);
                break;
            }
            case 4: {
                if (title.equals("")) break;
                if (!useItemImage && this.plugin.getU4Custom() == null) {
                    useItemImage = true;
                }
                titlePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(title) / 2 + 90, overlay.y + graphics.getFontMetrics().getHeight() + 227);
                itemImage = ((Image)(useItemImage ? this.itemManager.getImage(itemId) : this.plugin.getU4Custom())).getScaledInstance(iamgeWidth, imageHeight, 1);
                imagePoint = new Point(overlay.x + 88 - iamgeWidth / 2, overlay.y + 202 - imageHeight / 2);
                pricePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(price) / 2 + 90, overlay.y + graphics.getFontMetrics().getHeight() + 252);
                break;
            }
            case 5: {
                if (title.equals("")) break;
                if (!useItemImage && this.plugin.getU5Custom() == null) {
                    useItemImage = true;
                }
                titlePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(title) / 2 + 244, overlay.y + graphics.getFontMetrics().getHeight() + 227);
                itemImage = ((Image)(useItemImage ? this.itemManager.getImage(itemId) : this.plugin.getU5Custom())).getScaledInstance(iamgeWidth, imageHeight, 1);
                imagePoint = new Point(overlay.x + 242 - iamgeWidth / 2, overlay.y + 202 - imageHeight / 2);
                pricePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(price) / 2 + 244, overlay.y + graphics.getFontMetrics().getHeight() + 252);
                break;
            }
            case 6: {
                if (title.equals("")) break;
                if (!useItemImage && this.plugin.getU6Custom() == null) {
                    useItemImage = true;
                }
                titlePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(title) / 2 + 398, overlay.y + graphics.getFontMetrics().getHeight() + 227);
                itemImage = ((Image)(useItemImage ? this.itemManager.getImage(itemId) : this.plugin.getU6Custom())).getScaledInstance(iamgeWidth, imageHeight, 1);
                imagePoint = new Point(overlay.x + 396 - iamgeWidth / 2, overlay.y + 202 - imageHeight / 2);
                pricePoint = new Point(overlay.x - graphics.getFontMetrics().stringWidth(price) / 2 + 398, overlay.y + graphics.getFontMetrics().getHeight() + 252);
            }
        }
        if (title == null) {
            return;
        }
        ThenWeFightUnlockOverlay.renderTextLocation(graphics, titlePoint, title, unlocked ? Color.GREEN : Color.YELLOW);
        ThenWeFightUnlockOverlay.renderImageLocation(graphics, imagePoint, itemImage);
        ThenWeFightUnlockOverlay.renderTextLocation(graphics, pricePoint, price, unlocked ? Color.GREEN : Color.YELLOW);
    }

    public static void renderTextLocation(Graphics2D graphics, Point txtLoc, String text, Color color) {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        int x = (int)txtLoc.getX();
        int y = (int)txtLoc.getY();
        graphics.setColor(Color.BLACK);
        graphics.drawString(text, x + 1, y + 1);
        graphics.setColor(color);
        graphics.drawString(text, x, y);
    }

    public static void renderImageLocation(Graphics2D graphics, Point loc, Image image) {
        graphics.drawImage(image, loc.x, loc.y, null);
    }
}

