/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.overlay;

import com.google.common.base.Strings;
import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThenWeFightTaskOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ThenWeFightTaskOverlay.class);
    @Inject
    private ItemManager itemManager;
    private final Client client;
    private final ThenWeFightConfig config;
    private final ThenWeFightPlugin plugin;
    private static final Font FONT = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
    private static final String TITLE = "Then We Fight Tasks";

    @Inject
    private ThenWeFightTaskOverlay(Client client, ThenWeFightConfig config, ThenWeFightPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        graphics.setFont(FONT);
        if (!this.plugin.taskOverlayVisible) {
            return null;
        }
        Point overlay = new Point(this.config.overlayX(), this.config.overlayY());
        Point title = new Point(overlay.x - graphics.getFontMetrics().stringWidth(TITLE) / 2 + 244, overlay.y + graphics.getFontMetrics().getHeight() + 9);
        Point points = new Point(overlay.x + 20, overlay.y + graphics.getFontMetrics().getHeight() + 9);
        if (this.config.debug()) {
            if (this.plugin.getDebugBackground() != null) {
                ThenWeFightTaskOverlay.renderImageLocation(graphics, overlay, this.plugin.getDebugBackground());
            }
        } else if (this.plugin.getBackground() != null) {
            ThenWeFightTaskOverlay.renderImageLocation(graphics, overlay, this.plugin.getBackground());
        }
        ThenWeFightTaskOverlay.renderTextLocation(graphics, title, TITLE, Color.YELLOW);
        ThenWeFightTaskOverlay.renderTextLocation(graphics, points, this.config.points(), Color.YELLOW);
        for (int i = this.config.taskScroll(); i <= ThenWeFightPlugin.rawTaskList.length && i < this.config.taskScroll() + 12; ++i) {
            String[] parsed;
            if (i >= ThenWeFightPlugin.rawTaskList.length || ThenWeFightPlugin.rawTaskList[i] == null || (parsed = ThenWeFightPlugin.rawTaskList[i].split(",")) == null || parsed.length != 3) continue;
            boolean taskCompleted = parsed[0].equalsIgnoreCase("y");
            String taskPoints = parsed[1] + " pts";
            String taskName = parsed[2];
            Color colour = taskCompleted ? Color.GREEN : Color.YELLOW;
            Object text = (taskCompleted ? "[x] " : "[  ] ") + taskPoints + " - " + taskName;
            int textLength = ((String)text).length();
            while (graphics.getFontMetrics().stringWidth((String)text) >= 465) {
                text = ((String)text).substring(0, ((String)text).length() - 1);
            }
            if (textLength != ((String)text).length()) {
                text = ((String)text).substring(0, ((String)text).length() - 3) + "...";
            }
            Point point = new Point(20 + overlay.x, 40 + 20 * (i - this.config.taskScroll() + 1) + overlay.y);
            ThenWeFightTaskOverlay.renderTextLocation(graphics, point, (String)text, colour);
        }
        return null;
    }

    public static void renderTextLocation(Graphics2D graphics, Point txtLoc, String text, Color color) {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        int x = (int)txtLoc.getX();
        int y = (int)txtLoc.getY();
        graphics.setColor(Color.BLACK);
        graphics.drawString(text, x + 1, y + 1);
        graphics.setColor(color);
        graphics.drawString(text, x, y);
    }

    public static void renderImageLocation(Graphics2D graphics, Point loc, Image image) {
        graphics.drawImage(image, loc.x, loc.y, null);
    }
}

