/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.overlay;

import com.google.common.base.Strings;
import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThenWeFightSceneOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ThenWeFightSceneOverlay.class);
    @Inject
    private Client client;
    private final ThenWeFightConfig config;
    private final ThenWeFightPlugin plugin;

    @Inject
    private ThenWeFightSceneOverlay(Client client, ThenWeFightConfig config, ThenWeFightPlugin plugin) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        Player local = this.client.getLocalPlayer();
        if (this.plugin == null || local == null) {
            return null;
        }
        for (NPC n : ThenWeFightPlugin.npcs) {
            this.renderNpcOverlay(graphics, this.config.gameOverlayColour(), n);
        }
        for (GameObject g : ThenWeFightPlugin.gameObjects) {
            this.renderGameObject(graphics, this.config.gameOverlayColour(), g);
        }
        for (GroundObject go : ThenWeFightPlugin.groundObjects) {
            this.renderGroundObject(graphics, this.config.gameOverlayColour(), go);
        }
        for (WallObject wo : ThenWeFightPlugin.wallObjects) {
            this.renderWallObject(graphics, this.config.gameOverlayColour(), wo);
        }
        return null;
    }

    private void renderWorldArea(Graphics2D graphics, WorldArea area, Color color) {
        WorldPoint sw = area.toWorldPoint();
        int width = area.getWidth();
        int height = area.getHeight();
        boolean widthEven = width % 2 == 0;
        boolean heightEven = height % 2 == 0;
        WorldPoint center = new WorldPoint(sw.dx(width / 2).getX(), sw.dy(height / 2).getY(), sw.getPlane());
        LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)center);
        if (local == null) {
            return;
        }
        if (!widthEven) {
            local = new LocalPoint(local.getX() + 64, local.getY());
            ++width;
        } else {
            ++width;
        }
        if (!heightEven) {
            local = new LocalPoint(local.getX(), local.getY() + 64);
            ++height;
        } else {
            ++height;
        }
        Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)local, (int)width, (int)height, (int)area.getPlane(), (int)100);
        this.renderPoly(graphics, color, tilePoly, false);
    }

    private void renderNpcText(Graphics2D graphics, NPC npc, String text, Color color) {
        Point txtLoc = npc.getCanvasTextLocation(graphics, text, npc.getLogicalHeight() - 70);
        if (npc.getConvexHull() == null || txtLoc == null) {
            return;
        }
        ThenWeFightSceneOverlay.renderTextLocation(graphics, txtLoc, text, color);
    }

    private void renderWorldPoint(Graphics2D graphics, WorldPoint worldPoint, Color color) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (lp != null) {
            this.renderTile(graphics, lp, color, 1.0);
        }
    }

    private void renderWorldPointText(Graphics2D graphics, WorldPoint worldPoint, String text, Color color) {
        Point point;
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (lp != null && (point = Perspective.localToCanvas((Client)this.client, (LocalPoint)lp, (int)worldPoint.getPlane())) != null) {
            int textWidth = graphics.getFontMetrics().stringWidth(text);
            int textHeight = graphics.getFontMetrics().getAscent();
            Point centerPoint = new Point(point.getX() - textWidth / 2, point.getY() + textHeight / 2);
            ThenWeFightSceneOverlay.renderTextLocation(graphics, centerPoint, text, color);
        }
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color, double borderWidth) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)dest);
        if (poly == null) {
            return;
        }
        this.renderPoly(graphics, color, poly, true);
    }

    public static void renderTextLocation(Graphics2D graphics, Point txtLoc, String text, Color color) {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        int x = txtLoc.getX();
        int y = txtLoc.getY();
        graphics.setColor(Color.BLACK);
        graphics.drawString(text, x + 1, y + 1);
        graphics.setColor(color);
        graphics.drawString(text, x, y);
    }

    private void renderNpcOverlay(Graphics2D graphics, Color color, NPC actor) {
        NPCComposition npcComposition = actor.getTransformedComposition();
        if (npcComposition == null || !npcComposition.isInteractible() || actor.isDead()) {
            return;
        }
        Shape objectClickbox = actor.getConvexHull();
        this.renderPolyFill(graphics, color, objectClickbox, true);
    }

    private void renderPoly(Graphics2D graphics, Color color, Shape polygon, boolean fill) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(1.2f));
            graphics.draw(polygon);
            graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)20));
            if (fill) {
                graphics.fill(polygon);
            }
        }
    }

    private void renderPolyFill(Graphics2D graphics, Color color, Shape polygon, boolean fill) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(1.2f));
            graphics.draw(polygon);
            graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)this.config.opacity()));
            graphics.fill(polygon);
        }
    }

    private void renderGroundObject(Graphics2D graphics, Color color, GroundObject object) {
        Shape shape = object.getConvexHull();
        if (shape != null) {
            this.renderPolyFill(graphics, color, shape, true);
        }
    }

    private void renderWallObject(Graphics2D graphics, Color color, WallObject object) {
        Shape shape = object.getConvexHull();
        if (shape != null) {
            this.renderPolyFill(graphics, color, shape, true);
        }
    }

    private void renderGameObject(Graphics2D graphics, Color color, GameObject object) {
        Shape shape = object.getConvexHull();
        if (shape != null) {
            this.renderPolyFill(graphics, color, shape, true);
        }
    }
}

