/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight.overlay;

import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.ThenWeFightPlugin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThenWeFightItemOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(ThenWeFightItemOverlay.class);
    private final ItemManager itemManager;
    private final ThenWeFightPlugin plugin;
    private final ThenWeFightConfig config;

    @Inject
    ThenWeFightItemOverlay(ItemManager itemManager, ThenWeFightPlugin plugin, ThenWeFightConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.showOnEquipment();
        this.showOnInventory();
        this.showOnBank();
        this.showOnInterfaces(new int[]{551, 271, 550, 672});
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (this.config.unlockItems() && !ThenWeFightPlugin.unlockedItems.contains(itemId) || this.config.lockCoins() && itemId == 995) {
            Rectangle bounds = widgetItem.getCanvasBounds();
            BufferedImage outline = this.itemManager.getItemOutline(itemId, widgetItem.getQuantity(), this.config.uiOverlayColour());
            graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
            BufferedImage image = ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(itemId, widgetItem.getQuantity(), false), (Color)this.config.uiOverlayColour());
            float opacity = this.config.opacity() == 0 ? 0.0f : (float)this.config.opacity() / 255.0f;
            graphics.setComposite(AlphaComposite.getInstance(3, opacity));
            graphics.drawImage((Image)image, (int)bounds.getX(), (int)bounds.getY(), null);
        }
    }
}

