/*
 * Decompiled with CFR 0.152.
 */
package com.thenwefight;

import com.google.inject.Provides;
import com.thenwefight.ThenWeFightConfig;
import com.thenwefight.overlay.ThenWeFightItemOverlay;
import com.thenwefight.overlay.ThenWeFightItemUnlockOverlay;
import com.thenwefight.overlay.ThenWeFightSceneOverlay;
import com.thenwefight.overlay.ThenWeFightTaskOverlay;
import com.thenwefight.overlay.ThenWeFightUnlockOverlay;
import com.thenwefight.overlay.ThenWeFightWidgetOverlay;
import com.thenwefight.utils.GameUtils;
import com.thenwefight.utils.PluginUtils;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Player;
import net.runelite.api.WallObject;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Then We Fight", description="Then We Fight Gamemode Plugin")
public class ThenWeFightPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ThenWeFightPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ThenWeFightConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ThenWeFightUnlockOverlay unlockOverlay;
    @Inject
    private ThenWeFightItemOverlay itemOverlay;
    @Inject
    private ThenWeFightSceneOverlay sceneOverlay;
    @Inject
    private ThenWeFightWidgetOverlay widgetOverlay;
    @Inject
    private ThenWeFightTaskOverlay taskOverlay;
    @Inject
    private ThenWeFightItemUnlockOverlay itemUnlockOverlay;
    @Inject
    private PluginUtils pluginUtils;
    @Inject
    private GameUtils gameUtils;
    public static String[] rawTaskList;
    public static String[] rawUnlockList;
    public static String[] rawItemUnlockList;
    public static List<Integer> unlockedItems;
    public static List<String> unlockedNpcs;
    public static List<Integer> lockedWidgets;
    public static List<String> lockedObjects;
    public static final Collection<String> BANK_NPC_NAMES;
    public static final Collection<String> BANK_OBJECT_NAMES;
    public static final Collection<String> UNDERGROUND_OBJECT_NAMES;
    public static final Collection<String> TELEPORT_OPTIONS;
    public static final Collection<String> TELEPORT_TARGETS;
    public static final Collection<String> STAIRS_OBJECT_NAMES;
    public static final Collection<String> DOOR_OBJECT_NAMES;
    public static final Collection<String> DROP_OPTIONS;
    public static final Collection<String> EAT_OPTIONS;
    public static final Collection<String> DRINK_OPTIONS;
    public static final Collection<String> THIEVE_OPTIONS;
    public static final Collection<String> WOODCUTTING_OPTIONS;
    public static final Collection<String> FISHING_OPTIONS;
    public static final Collection<String> FISHING_TARGETS;
    public static final Collection<String> SLAYER_NPC_TARGETS;
    public static Collection<GameObject> gameObjects;
    public static Collection<WallObject> wallObjects;
    public static Collection<GroundObject> groundObjects;
    public static Collection<NPC> npcs;
    public static final File THEN_WE_FIGHT_FOLDER;
    public static File U_1_CUSTOM_DIR;
    public static File U_2_CUSTOM_DIR;
    public static File U_3_CUSTOM_DIR;
    public static File U_4_CUSTOM_DIR;
    public static File U_5_CUSTOM_DIR;
    public static File U_6_CUSTOM_DIR;
    public static File IU_1_CUSTOM_DIR;
    public static File IU_2_CUSTOM_DIR;
    public static File IU_3_CUSTOM_DIR;
    public static File IU_4_CUSTOM_DIR;
    public static File IU_5_CUSTOM_DIR;
    public static File IU_6_CUSTOM_DIR;
    public static final Collection<Integer> OBJECT_ACTIONS;
    public static final Collection<Integer> NPC_ACTIONS;
    public static final Collection<Integer> GROUND_ITEM_ACTIONS;
    public static final Collection<Integer> QUEST_TAB_PARAMS;
    public static final Collection<Integer> INVENT_TAB_PARAMS;
    public static final Collection<Integer> EQUIPMENT_TAB_PARAMS;
    public static final String BACKGROUND_PATH = "background.png";
    public static final String DEBUG_PATH = "debug.png";
    public static final String HEALTH_PATH = "health.png";
    public static final String PRAYER_PATH = "prayer.png";
    public static final String RUN_PATH = "run.png";
    public static final String SPEC_PATH = "spec.png";
    public static final String THICK_SKIN_NAME = "thick skin";
    public static final String BURST_OF_STRENGTH_NAME = "burst of strength";
    public static final String CLARITY_OF_THOUGHT_NAME = "clarity of thought";
    public static final String SHARP_EYE_NAME = "sharp eye";
    public static final String MYSTIC_WILL_NAME = "mystic will";
    public static final String ROCK_SKIN_NAME = "rock skin";
    public static final String SUPERHUMAN_STRENGTH_NAME = "superhuman strength";
    public static final String IMPROVED_REFLEXES_NAME = "improved reflexes";
    public static final String RAPID_RESTORE_NAME = "rapid restore";
    public static final String RAPID_HEAL_NAME = "rapid heal";
    public static final String PROTECT_ITEM_NAME = "protect item";
    public static final String HAWK_EYE_NAME = "hawk eye";
    public static final String MYSTIC_LORE_NAME = "mystic lore";
    public static final String STEEL_SKIN_NAME = "steel skin";
    public static final String ULTIMATE_STRENGTH_NAME = "ultimate strength";
    public static final String INCREDIBLE_REFLEXES_NAME = "incredible reflexes";
    public static final String PROTECT_FROM_MAGIC_NAME = "protect from magic";
    public static final String PROTECT_FROM_MISSILES_NAME = "protect from missiles";
    public static final String PROTECT_FROM_MELEE_NAME = "protect from melee";
    public static final String EAGLE_EYE_NAME = "eagle eye";
    public static final String MYSTIC_MIGHT_NAME = "mystic might";
    public static final String RETRIBUTION_NAME = "retribution";
    public static final String REDEMPTION_NAME = "redemption";
    public static final String SMITE_NAME = "smite";
    public static final String PRESERVE_NAME = "preserve";
    public static final String CHIVALRY_NAME = "chivalry";
    public static final String PIETY_NAME = "piety";
    public static final String RIGOUR_NAME = "rigour";
    public static final String AUGURY_NAME = "augury";
    public Image background;
    public Image debugBackground;
    public Image runOrb;
    public Image prayerOrb;
    public Image specOrb;
    public Image healthOrb;
    public Image u1Custom;
    public Image u2Custom;
    public Image u3Custom;
    public Image u4Custom;
    public Image u5Custom;
    public Image u6Custom;
    public Image iu1Custom;
    public Image iu2Custom;
    public Image iu3Custom;
    public Image iu4Custom;
    public Image iu5Custom;
    public Image iu6Custom;
    public boolean unlockOverlayVisible = false;
    public boolean taskOverlayVisible = false;
    public boolean itemUnlockOverlayVisible = false;
    public int plane = -1;

    protected void startUp() throws Exception {
        if (!THEN_WE_FIGHT_FOLDER.exists()) {
            THEN_WE_FIGHT_FOLDER.mkdirs();
        }
        this.overlayManager.add((Overlay)this.itemOverlay);
        this.overlayManager.add((Overlay)this.sceneOverlay);
        this.overlayManager.add((Overlay)this.unlockOverlay);
        this.overlayManager.add((Overlay)this.widgetOverlay);
        this.overlayManager.add((Overlay)this.taskOverlay);
        this.overlayManager.add((Overlay)this.itemUnlockOverlay);
        this.pluginUtils.updateUnlockList();
        this.pluginUtils.updateItemUnlockList();
        this.pluginUtils.setCustomUnlockImageFilePaths();
        this.pluginUtils.setCustomItemUnlockImageFilePaths();
        this.pluginUtils.updateItemList();
        this.pluginUtils.updateNpcList();
        this.pluginUtils.updateWidgetList();
        this.pluginUtils.updateGameObjectList();
        this.pluginUtils.updateTaskList();
        this.pluginUtils.loadResources();
        this.unlockOverlayVisible = false;
        this.taskOverlayVisible = false;
        this.plane = -1;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.itemOverlay);
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.overlayManager.remove((Overlay)this.unlockOverlay);
        this.overlayManager.remove((Overlay)this.widgetOverlay);
        this.overlayManager.remove((Overlay)this.taskOverlay);
        this.overlayManager.remove((Overlay)this.itemUnlockOverlay);
        this.pluginUtils.updateUnlockList();
        this.pluginUtils.updateItemUnlockList();
        this.pluginUtils.setCustomUnlockImageFilePaths();
        this.pluginUtils.setCustomItemUnlockImageFilePaths();
        this.pluginUtils.updateItemList();
        this.pluginUtils.updateNpcList();
        this.pluginUtils.updateWidgetList();
        this.pluginUtils.updateGameObjectList();
        this.pluginUtils.loadResources();
        this.unlockOverlayVisible = false;
        this.taskOverlayVisible = false;
        this.plane = -1;
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("thenwefight")) {
            return;
        }
        if (event.getKey().equals("unlockedItems")) {
            this.pluginUtils.updateItemList();
        }
        if (event.getKey().equals("unlockedNpcs") || event.getKey().equals("unlockNpcs") || event.getKey().equals("lockBanks")) {
            this.pluginUtils.updateNpcList();
        }
        if (event.getKey().equals("lockedGameObjects") || event.getKey().equals("lockGameObjects") || event.getKey().equals("lockBanks") || event.getKey().equals("lockUnderground") || event.getKey().equals("lockStairs") || event.getKey().equals("lockDoors")) {
            this.pluginUtils.updateGameObjectList();
        }
        if (event.getKey().equals("lockedWidgets")) {
            this.pluginUtils.updateWidgetList();
        }
        if (event.getKey().equals("taskList")) {
            this.pluginUtils.updateTaskList();
        }
        if (event.getKey().equals("unlockList")) {
            this.pluginUtils.updateUnlockList();
            this.pluginUtils.setCustomUnlockImageFilePaths();
        }
        if (event.getKey().equals("unlockScroll")) {
            this.pluginUtils.setCustomUnlockImageFilePaths();
        }
        if (event.getKey().equals("itemUnlockList")) {
            this.pluginUtils.updateItemUnlockList();
            this.pluginUtils.setCustomItemUnlockImageFilePaths();
        }
        if (event.getKey().equals("itemUnlockScroll")) {
            this.pluginUtils.setCustomItemUnlockImageFilePaths();
        }
        if (event.getKey().equals("imageWidth") || event.getKey().equals("imageHeight")) {
            this.pluginUtils.setCustomUnlockImageFilePaths();
            this.pluginUtils.setCustomItemUnlockImageFilePaths();
        }
    }

    @Provides
    ThenWeFightConfig provideConfig(ConfigManager configManager) {
        return (ThenWeFightConfig)configManager.getConfig(ThenWeFightConfig.class);
    }

    @Subscribe
    private void onMenuEntryAdded(MenuEntryAdded event) {
        NPC[] cachedNPCs;
        NPC npc;
        String target = event.getTarget();
        String cleanTarget = Text.standardize((String)target);
        String option = event.getOption();
        String cleanOption = Text.standardize((String)option);
        int type = event.getType();
        int identifier = event.getIdentifier();
        int param1 = event.getActionParam1();
        int param0 = event.getActionParam0();
        Widget widget = event.getMenuEntry().getWidget();
        boolean shiftPressed = this.client.isKeyPressed(81);
        boolean unlockedItem = false;
        boolean lockedNpc = false;
        if (widget != null) {
            unlockedItem = unlockedItems.contains(widget.getItemId());
        }
        if (QUEST_TAB_PARAMS.contains(param1)) {
            this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)(this.unlockOverlayVisible ? "Hide Unlocks" : "View Unlocks"), (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE);
            this.client.createMenuEntry(-2).setOption(ColorUtil.prependColorTag((String)(this.taskOverlayVisible ? "Hide Tasks" : "View Tasks"), (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE);
            this.client.createMenuEntry(-3).setOption(ColorUtil.prependColorTag((String)(this.itemUnlockOverlayVisible ? "Hide Item Unlocks" : "View Item Unlocks"), (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE);
        }
        if (INVENT_TAB_PARAMS.contains(param1) && this.config.unlockItems()) {
            this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)"Lock All Inventory Items", (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE).onClick(this.pluginUtils::lockAllItems);
            this.client.createMenuEntry(-2).setOption(ColorUtil.prependColorTag((String)"Unlock All Inventory Items", (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE).onClick(this.pluginUtils::unlockAllItems);
            this.client.createMenuEntry(-3).setOption(ColorUtil.prependColorTag((String)"Lock All Inventory Food", (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE).onClick(this.pluginUtils::lockAllFood);
            this.client.createMenuEntry(-4).setOption(ColorUtil.prependColorTag((String)"Unlock All Inventory Food", (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE).onClick(this.pluginUtils::unlockAllFood);
        }
        if (EQUIPMENT_TAB_PARAMS.contains(param1) && this.config.unlockItems()) {
            this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)"Lock All Worn Items", (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE).onClick(this.pluginUtils::lockAllEquipment);
            this.client.createMenuEntry(-2).setOption(ColorUtil.prependColorTag((String)"Unlock All Worn Items", (Color)Color.ORANGE)).setParam1(param1).setDeprioritized(true).setType(MenuAction.RUNELITE).onClick(this.pluginUtils::unlockAllEquipment);
        }
        if (shiftPressed) {
            int id;
            if (param1 == WidgetInfo.INVENTORY.getId() && type == MenuAction.CC_OP_LOW_PRIORITY.getId() && identifier == 10 && widget != null && this.config.unlockItems()) {
                this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)(unlockedItem ? "Lock" : "Unlock"), (Color)Color.ORANGE)).setTarget(target).setIdentifier(identifier).setParam0(widget.getItemId()).setParam1(param1).setType(MenuAction.RUNELITE);
            }
            if (type == MenuAction.EXAMINE_NPC.getId() && this.config.unlockNpcs()) {
                id = event.getMenuEntry().getIdentifier();
                NPC[] cachedNPCs2 = this.client.getCachedNPCs();
                NPC npc2 = cachedNPCs2[id];
                if (npc2 != null && npc2.getName() != null) {
                    boolean unlocked = unlockedNpcs.contains(npc2.getName().toLowerCase());
                    this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)(unlocked ? "Lock NPC" : "Unlock NPC"), (Color)Color.ORANGE)).setTarget(target).setIdentifier(identifier).setParam0(param0).setParam1(param1).setType(MenuAction.RUNELITE);
                }
            }
            if (type == MenuAction.EXAMINE_OBJECT.getId() && this.config.lockGameObjects()) {
                id = event.getMenuEntry().getIdentifier();
                boolean unlocked = lockedObjects.contains(this.gameUtils.getGameObjectName(id));
                this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)(unlocked ? "Unlock Object" : "Lock Object"), (Color)Color.ORANGE)).setTarget(target).setIdentifier(identifier).setParam0(param0).setParam1(param1).setType(MenuAction.RUNELITE);
            }
        }
        if (this.config.unlockNpcs() && NPC_ACTIONS.contains(type) && (npc = (cachedNPCs = this.client.getCachedNPCs())[identifier]) != null && npc.getName() != null && !unlockedNpcs.contains(npc.getName().toLowerCase())) {
            lockedNpc = true;
        }
        if (this.config.lockAttacking() && type == MenuAction.NPC_SECOND_OPTION.getId() || this.config.unlockItems() && param1 == WidgetInfo.INVENTORY.getId() && widget != null && !unlockedItems.contains(widget.getItemId()) || this.config.lockDrinking() && DRINK_OPTIONS.contains(cleanOption) || this.config.lockEating() && EAT_OPTIONS.contains(cleanOption) || this.config.lockTeles() && option.toLowerCase().contains("teleport") || this.config.lockTeles() && target.toLowerCase().contains("teleport") || this.config.lockTeles() && option.toLowerCase().contains("tele") || this.config.lockTeles() && target.toLowerCase().contains("tele") || this.config.lockBanks() && (BANK_OBJECT_NAMES.contains(cleanTarget) || BANK_NPC_NAMES.contains(cleanTarget)) || this.config.lockCoins() && type == MenuAction.GROUND_ITEM_THIRD_OPTION.getId() && cleanTarget.equals("coins") || this.config.unlockItems() && GROUND_ITEM_ACTIONS.contains(type) && lockedObjects.contains(cleanTarget) || this.config.lockGameObjects() && OBJECT_ACTIONS.contains(type) && lockedObjects.contains(cleanTarget) || this.config.lockBanks() && BANK_OBJECT_NAMES.contains(cleanTarget) && OBJECT_ACTIONS.contains(type) || this.config.lockUnderground() && UNDERGROUND_OBJECT_NAMES.contains(cleanTarget) && OBJECT_ACTIONS.contains(type) || this.config.lockBanks() && BANK_NPC_NAMES.contains(cleanTarget) && NPC_ACTIONS.contains(type) || this.config.lockThieving() && THIEVE_OPTIONS.contains(cleanOption) || this.config.lockWoodcutting() && WOODCUTTING_OPTIONS.contains(cleanOption) || this.config.lockFishing() && FISHING_TARGETS.contains(cleanTarget) || this.config.lockSlayer() && NPC_ACTIONS.contains(type) && SLAYER_NPC_TARGETS.contains(cleanTarget) || lockedNpc) {
            event.getMenuEntry().setOption(ColorUtil.prependColorTag((String)option, (Color)this.config.uiOverlayColour()));
            event.getMenuEntry().setTarget(ColorUtil.prependColorTag((String)Text.removeTags((String)target), (Color)this.config.uiOverlayColour()));
            event.getMenuEntry().setDeprioritized(true);
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        boolean unlocked;
        String target = event.getMenuTarget();
        String cleanTarget = Text.standardize((String)target);
        String option = event.getMenuOption();
        int type = event.getMenuAction().getId();
        int identifier = event.getId();
        int param1 = event.getParam1();
        int param0 = event.getParam0();
        MenuEntry entry = event.getMenuEntry();
        Widget widget = entry.getWidget();
        if (param1 == WidgetInfo.INVENTORY.getId() && widget != null && this.config.unlockItems() && !this.client.isKeyPressed(81) && !(unlocked = unlockedItems.contains(widget.getItemId()))) {
            event.consume();
            return;
        }
        if (option.equals("Walk here") && (this.taskOverlayVisible || this.unlockOverlayVisible || this.itemUnlockOverlayVisible)) {
            this.unlockOverlayVisible = false;
            this.taskOverlayVisible = false;
            this.itemUnlockOverlayVisible = false;
        }
        if (QUEST_TAB_PARAMS.contains(param1)) {
            if (option.equals(ColorUtil.prependColorTag((String)"View Unlocks", (Color)Color.ORANGE))) {
                event.consume();
                this.unlockOverlayVisible = true;
                this.taskOverlayVisible = false;
                this.itemUnlockOverlayVisible = false;
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Hide Unlocks", (Color)Color.ORANGE))) {
                event.consume();
                this.unlockOverlayVisible = false;
            }
            if (option.equals(ColorUtil.prependColorTag((String)"View Tasks", (Color)Color.ORANGE))) {
                event.consume();
                this.taskOverlayVisible = true;
                this.unlockOverlayVisible = false;
                this.itemUnlockOverlayVisible = false;
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Hide Tasks", (Color)Color.ORANGE))) {
                event.consume();
                this.taskOverlayVisible = false;
            }
            if (option.equals(ColorUtil.prependColorTag((String)"View Item Unlocks", (Color)Color.ORANGE))) {
                event.consume();
                this.itemUnlockOverlayVisible = true;
                this.unlockOverlayVisible = false;
                this.taskOverlayVisible = false;
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Hide Item Unlocks", (Color)Color.ORANGE))) {
                event.consume();
                this.itemUnlockOverlayVisible = false;
            }
        }
        if (param1 == WidgetInfo.INVENTORY.getId() && type == MenuAction.RUNELITE.getId() && param0 != 0) {
            if (option.equals(ColorUtil.prependColorTag((String)"Unlock", (Color)Color.ORANGE))) {
                event.consume();
                unlockedItems.add(param0);
                this.configManager.setConfiguration("thenwefight", "unlockedItems", unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Lock", (Color)Color.ORANGE))) {
                event.consume();
                unlockedItems.remove((Object)param0);
                this.configManager.setConfiguration("thenwefight", "unlockedItems", unlockedItems.toString().replace(" ", "").replace("[", "").replace("]", ""));
            }
        }
        if (type == MenuAction.RUNELITE.getId()) {
            NPC npc;
            if (option.equals(ColorUtil.prependColorTag((String)"Unlock NPC", (Color)Color.ORANGE))) {
                event.consume();
                NPC[] cachedNPCs = this.client.getCachedNPCs();
                npc = cachedNPCs[identifier];
                if (npc != null && npc.getName() != null) {
                    unlockedNpcs.add(npc.getName().toLowerCase());
                    this.configManager.setConfiguration("thenwefight", "unlockedNpcs", unlockedNpcs.toString().replace("[", "").replace("]", ""));
                }
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Lock NPC", (Color)Color.ORANGE))) {
                event.consume();
                NPC[] cachedNPCs = this.client.getCachedNPCs();
                npc = cachedNPCs[identifier];
                if (npc != null && npc.getName() != null) {
                    unlockedNpcs.remove(npc.getName().toLowerCase());
                    this.configManager.setConfiguration("thenwefight", "unlockedNpcs", unlockedNpcs.toString().replace("[", "").replace("]", ""));
                }
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Lock Object", (Color)Color.ORANGE))) {
                event.consume();
                lockedObjects.add(this.gameUtils.getGameObjectName(identifier));
                this.configManager.setConfiguration("thenwefight", "lockedGameObjects", lockedObjects.toString().replace("[", "").replace("]", ""));
            }
            if (option.equals(ColorUtil.prependColorTag((String)"Unlock Object", (Color)Color.ORANGE))) {
                event.consume();
                lockedObjects.remove(this.gameUtils.getGameObjectName(identifier));
                this.configManager.setConfiguration("thenwefight", "lockedGameObjects", lockedObjects.toString().replace("[", "").replace("]", ""));
                this.pluginUtils.updateGameObjects();
            }
        }
    }

    @Subscribe
    private void onMenuOpened(MenuOpened event) {
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>();
        for (MenuEntry entry : event.getMenuEntries()) {
            NPC[] cachedNPCs;
            NPC npc;
            String target = entry.getTarget();
            String cleanTarget = Text.standardize((String)target);
            String option = entry.getOption();
            String cleanOption = Text.standardize((String)option);
            int type = entry.getType().getId();
            int identifier = entry.getIdentifier();
            int param1 = entry.getParam1();
            int param0 = entry.getParam0();
            Widget widget = entry.getWidget();
            boolean shiftPressed = this.client.isKeyPressed(81);
            boolean lockedNpc = false;
            if (this.config.unlockNpcs() && NPC_ACTIONS.contains(type) && (npc = (cachedNPCs = this.client.getCachedNPCs())[identifier]) != null && npc.getName() != null && !unlockedNpcs.contains(npc.getName().toLowerCase())) {
                lockedNpc = true;
            }
            if ((this.config.lockAttacking() && type == MenuAction.NPC_SECOND_OPTION.getId() || this.config.unlockItems() && param1 == WidgetInfo.INVENTORY.getId() && widget != null && !unlockedItems.contains(widget.getItemId()) || this.config.lockDrinking() && DRINK_OPTIONS.contains(cleanOption) || this.config.lockEating() && EAT_OPTIONS.contains(cleanOption) || this.config.lockTeles() && option.toLowerCase().contains("teleport") || this.config.lockTeles() && target.toLowerCase().contains("teleport") || this.config.lockTeles() && option.toLowerCase().contains("tele") || this.config.lockTeles() && target.toLowerCase().contains("tele") || this.config.lockBanks() && (BANK_OBJECT_NAMES.contains(cleanTarget) || BANK_NPC_NAMES.contains(cleanTarget)) || this.config.lockCoins() && type == MenuAction.GROUND_ITEM_THIRD_OPTION.getId() && target.contains("Coins") || this.config.unlockItems() && GROUND_ITEM_ACTIONS.contains(type) && lockedObjects.contains(cleanTarget) || this.config.lockGameObjects() && OBJECT_ACTIONS.contains(type) && lockedObjects.contains(cleanTarget) || this.config.lockBanks() && BANK_OBJECT_NAMES.contains(cleanTarget) && OBJECT_ACTIONS.contains(type) || this.config.lockUnderground() && UNDERGROUND_OBJECT_NAMES.contains(cleanTarget) && OBJECT_ACTIONS.contains(type) || this.config.lockBanks() && BANK_NPC_NAMES.contains(cleanTarget) && NPC_ACTIONS.contains(type) || this.config.lockThieving() && THIEVE_OPTIONS.contains(cleanOption) || this.config.lockThieving() && THIEVE_OPTIONS.contains(cleanOption) || this.config.lockWoodcutting() && WOODCUTTING_OPTIONS.contains(cleanOption) || this.config.lockFishing() && FISHING_TARGETS.contains(cleanTarget) || this.config.lockSlayer() && NPC_ACTIONS.contains(type) && SLAYER_NPC_TARGETS.contains(cleanTarget) || lockedNpc) && !shiftPressed) continue;
            entries.add(entry);
        }
        this.client.setMenuEntries(entries.toArray(new MenuEntry[0]));
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject object = event.getGameObject();
        ObjectComposition objectComposition = this.gameUtils.getObjectComposition(object.getId());
        if (objectComposition == null || objectComposition.getName() == null || objectComposition.getName().equals("")) {
            return;
        }
        String name = objectComposition.getName().toLowerCase();
        if (this.config.lockBanks() && BANK_OBJECT_NAMES.contains(name) && !gameObjects.contains(object)) {
            gameObjects.add(object);
        }
        if (this.config.lockUnderground() && UNDERGROUND_OBJECT_NAMES.contains(name) && !gameObjects.contains(object)) {
            gameObjects.add(object);
        }
        if (this.config.lockGameObjects() && lockedObjects.contains(name) && !gameObjects.contains(object)) {
            gameObjects.add(object);
        }
        if (this.config.lockDoors() && DOOR_OBJECT_NAMES.contains(name) && !gameObjects.contains(object)) {
            gameObjects.add(object);
        }
        if (this.config.lockStairs() && STAIRS_OBJECT_NAMES.contains(name) && !gameObjects.contains(object)) {
            gameObjects.add(object);
        }
    }

    @Subscribe
    private void onGameObjectDespawned(GameObjectDespawned event) {
        gameObjects.remove(event.getGameObject());
    }

    @Subscribe
    private void onWallObjectSpawned(WallObjectSpawned event) {
        WallObject object = event.getWallObject();
        ObjectComposition objectComposition = this.gameUtils.getObjectComposition(object.getId());
        if (objectComposition == null || objectComposition.getName() == null || objectComposition.getName().equals("")) {
            return;
        }
        String name = objectComposition.getName().toLowerCase();
        if (this.config.lockBanks() && BANK_OBJECT_NAMES.contains(name) && !wallObjects.contains(object)) {
            wallObjects.add(object);
        }
        if (this.config.lockUnderground() && UNDERGROUND_OBJECT_NAMES.contains(name) && !wallObjects.contains(object)) {
            wallObjects.add(object);
        }
        if (this.config.lockGameObjects() && lockedObjects.contains(name) && !wallObjects.contains(object)) {
            wallObjects.add(object);
        }
        if (this.config.lockDoors() && DOOR_OBJECT_NAMES.contains(name) && !wallObjects.contains(object)) {
            wallObjects.add(object);
        }
        if (this.config.lockStairs() && STAIRS_OBJECT_NAMES.contains(name) && !wallObjects.contains(object)) {
            wallObjects.add(object);
        }
    }

    @Subscribe
    private void onWallObjectDespawned(WallObjectDespawned event) {
        wallObjects.remove(event.getWallObject());
    }

    @Subscribe
    private void onGroundObjectSpawned(GroundObjectSpawned event) {
        GroundObject object = event.getGroundObject();
        ObjectComposition objectComposition = this.gameUtils.getObjectComposition(object.getId());
        if (objectComposition == null || objectComposition.getName() == null || objectComposition.getName().equals("")) {
            return;
        }
        String name = objectComposition.getName().toLowerCase();
        if (this.config.lockBanks() && BANK_OBJECT_NAMES.contains(name) && !groundObjects.contains(object)) {
            groundObjects.add(object);
        }
        if (this.config.lockUnderground() && UNDERGROUND_OBJECT_NAMES.contains(name) && !groundObjects.contains(object)) {
            groundObjects.add(object);
        }
        if (this.config.lockGameObjects() && lockedObjects.contains(name) && !groundObjects.contains(object)) {
            groundObjects.add(object);
        }
        if (this.config.lockDoors() && DOOR_OBJECT_NAMES.contains(name) && !groundObjects.contains(object)) {
            groundObjects.add(object);
        }
        if (this.config.lockStairs() && STAIRS_OBJECT_NAMES.contains(name) && !groundObjects.contains(object)) {
            groundObjects.add(object);
        }
    }

    @Subscribe
    private void onGroundObjectDespawned(GroundObjectDespawned event) {
        groundObjects.remove(event.getGroundObject());
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (npc.getName() == null || npc.getName().equals("")) {
            return;
        }
        if (this.config.lockBanks() && BANK_NPC_NAMES.contains(npc.getName().toLowerCase()) && !npcs.contains(npc)) {
            npcs.add(npc);
        }
        if (this.config.unlockNpcs() && !unlockedNpcs.contains(npc.getName().toLowerCase()) && !npcs.contains(npc)) {
            npcs.add(npc);
        }
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned event) {
        npcs.remove(event.getNpc());
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.pluginUtils.updateNpcs();
            this.pluginUtils.updateGameObjects();
        }
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return;
        }
        int localPlane = local.getWorldLocation().getPlane();
        if (this.plane == -1 || this.plane != localPlane) {
            this.plane = localPlane;
            this.pluginUtils.updateGameObjects();
        }
    }

    public Image getBackground() {
        return this.background;
    }

    public Image getDebugBackground() {
        return this.debugBackground;
    }

    public Image getRunOrb() {
        return this.runOrb;
    }

    public Image getPrayerOrb() {
        return this.prayerOrb;
    }

    public Image getSpecOrb() {
        return this.specOrb;
    }

    public Image getHealthOrb() {
        return this.healthOrb;
    }

    public Image getU1Custom() {
        return this.u1Custom;
    }

    public Image getU2Custom() {
        return this.u2Custom;
    }

    public Image getU3Custom() {
        return this.u3Custom;
    }

    public Image getU4Custom() {
        return this.u4Custom;
    }

    public Image getU5Custom() {
        return this.u5Custom;
    }

    public Image getU6Custom() {
        return this.u6Custom;
    }

    public Image getIu1Custom() {
        return this.iu1Custom;
    }

    public Image getIu2Custom() {
        return this.iu2Custom;
    }

    public Image getIu3Custom() {
        return this.iu3Custom;
    }

    public Image getIu4Custom() {
        return this.iu4Custom;
    }

    public Image getIu5Custom() {
        return this.iu5Custom;
    }

    public Image getIu6Custom() {
        return this.iu6Custom;
    }

    static {
        unlockedItems = new ArrayList<Integer>();
        unlockedNpcs = new ArrayList<String>();
        lockedWidgets = new ArrayList<Integer>();
        lockedObjects = new ArrayList<String>();
        BANK_NPC_NAMES = Arrays.asList("banker", "grand exchange clerk", "banker tutor");
        BANK_OBJECT_NAMES = Arrays.asList("bank booth", "bank chest", "bank deposit box", "bank deposit chest", "grand exchange booth");
        UNDERGROUND_OBJECT_NAMES = Arrays.asList("trapdoor", "dark hole", "hole", "rope", "cavern entrance", "dive", "cave", "tunnel entrance");
        TELEPORT_OPTIONS = Arrays.asList("teleport", "tele");
        TELEPORT_TARGETS = Arrays.asList("teleport", "tele");
        STAIRS_OBJECT_NAMES = Arrays.asList("stairs", "staircase");
        DOOR_OBJECT_NAMES = Arrays.asList("door", "large door");
        DROP_OPTIONS = Arrays.asList("drop", "destroy");
        EAT_OPTIONS = Arrays.asList("eat", "consume");
        DRINK_OPTIONS = Arrays.asList("drink");
        THIEVE_OPTIONS = Arrays.asList("pickpocket", "steal");
        WOODCUTTING_OPTIONS = Arrays.asList("chop down");
        FISHING_OPTIONS = Arrays.asList("bait", "fish", "cast-net", "lure");
        FISHING_TARGETS = Arrays.asList("fishing spot", "rod fishing spot");
        SLAYER_NPC_TARGETS = Arrays.asList("turael", "spria", "krystilia", "mazchna", "vannaka", "chaeldar", "konar quo maten", "nieve", "steve", "duradel");
        gameObjects = new ArrayList<GameObject>();
        wallObjects = new ArrayList<WallObject>();
        groundObjects = new ArrayList<GroundObject>();
        npcs = new ArrayList<NPC>();
        THEN_WE_FIGHT_FOLDER = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "thenwefight");
        U_1_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/1.png");
        U_2_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/2.png");
        U_3_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/3.png");
        U_4_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/4.png");
        U_5_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/5.png");
        U_6_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/6.png");
        IU_1_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/1.png");
        IU_2_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/2.png");
        IU_3_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/3.png");
        IU_4_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/4.png");
        IU_5_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/5.png");
        IU_6_CUSTOM_DIR = new File(RuneLite.RUNELITE_DIR, "/thenwefight/6.png");
        OBJECT_ACTIONS = Arrays.asList(MenuAction.EXAMINE_OBJECT.getId(), MenuAction.GAME_OBJECT_FIRST_OPTION.getId(), MenuAction.GAME_OBJECT_SECOND_OPTION.getId(), MenuAction.GAME_OBJECT_THIRD_OPTION.getId(), MenuAction.GAME_OBJECT_FOURTH_OPTION.getId(), MenuAction.GAME_OBJECT_FIFTH_OPTION.getId());
        NPC_ACTIONS = Arrays.asList(MenuAction.EXAMINE_NPC.getId(), MenuAction.NPC_FIRST_OPTION.getId(), MenuAction.NPC_SECOND_OPTION.getId(), MenuAction.NPC_THIRD_OPTION.getId(), MenuAction.NPC_FOURTH_OPTION.getId(), MenuAction.NPC_FIFTH_OPTION.getId());
        GROUND_ITEM_ACTIONS = Arrays.asList(MenuAction.EXAMINE_ITEM_GROUND.getId(), MenuAction.GROUND_ITEM_FIRST_OPTION.getId(), MenuAction.GROUND_ITEM_SECOND_OPTION.getId(), MenuAction.GROUND_ITEM_THIRD_OPTION.getId(), MenuAction.GROUND_ITEM_FOURTH_OPTION.getId(), MenuAction.GROUND_ITEM_FIFTH_OPTION.getId());
        QUEST_TAB_PARAMS = Arrays.asList(10747957, 10551356, 0x2240040);
        INVENT_TAB_PARAMS = Arrays.asList(10747958, 10551357, 35913793);
        EQUIPMENT_TAB_PARAMS = Arrays.asList(10747959, 10551358, 0x2240042);
    }
}

