/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmagicala.gnomeRestaurant.recipe;

import io.github.mmagicala.gnomeRestaurant.recipe.Ingredient;
import io.github.mmagicala.gnomeRestaurant.recipe.RecipeInstruction;
import java.util.ArrayList;

public class RecipeStep {
    private final RecipeInstruction instruction;
    private final ArrayList<Ingredient> ingredients;
    private final int producedItemId;

    public RecipeStep(RecipeInstruction instruction, ArrayList<Ingredient> ingredients, int producedItemId) {
        this.instruction = instruction;
        this.ingredients = ingredients;
        this.producedItemId = producedItemId;
    }

    public RecipeStep(RecipeInstruction instruction, Ingredient ingredient, int producedItemId) {
        this(instruction, new ArrayList<Ingredient>(), producedItemId);
        this.ingredients.add(ingredient);
    }

    public ArrayList<Ingredient> getRawIngredients() {
        ArrayList<Ingredient> rawIngredients = new ArrayList<Ingredient>(this.ingredients);
        rawIngredients.removeIf(Ingredient::isIntermediate);
        return rawIngredients;
    }

    public RecipeInstruction getInstruction() {
        return this.instruction;
    }

    public ArrayList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public int getProducedItemId() {
        return this.producedItemId;
    }
}

