/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmagicala.gnomeRestaurant.recipe;

import io.github.mmagicala.gnomeRestaurant.recipe.Ingredient;
import io.github.mmagicala.gnomeRestaurant.recipe.RecipeStep;
import java.util.ArrayList;

public class Recipe {
    private String name;
    private ArrayList<RecipeStep> steps;

    public Recipe(String name, ArrayList<RecipeStep> steps) {
        this.name = name;
        this.steps = steps;
    }

    public int getItemId() {
        int numSteps = this.steps.size();
        RecipeStep deliveryStep = this.steps.get(numSteps - 1);
        return deliveryStep.getIngredients().get(0).getItemId();
    }

    public ArrayList<Ingredient> getNextRawIngredients(int stepIdx) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        int numSteps = this.steps.size();
        for (int i = stepIdx + 1; i < numSteps; ++i) {
            ArrayList<Ingredient> rawIngredients = this.steps.get(i).getRawIngredients();
            ingredients.addAll(rawIngredients);
        }
        return ingredients;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<RecipeStep> getSteps() {
        return this.steps;
    }
}

