/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmagicala.gnomeRestaurant.overlay;

import io.github.mmagicala.gnomeRestaurant.GnomeRestaurantPlugin;
import io.github.mmagicala.gnomeRestaurant.overlay.OverlayHeader;
import io.github.mmagicala.gnomeRestaurant.overlay.OverlayTableEntry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class GnomeRestaurantOverlay
extends OverlayPanel {
    private final OverlayHeader header;
    private final ArrayList<OverlayTableEntry> stepIngredientsOverlayTable;
    private final ArrayList<OverlayTableEntry> futureRawIngredientsOverlayTable;
    private final GnomeRestaurantPlugin plugin;
    private static final int PADDING = 10;

    @Inject
    public GnomeRestaurantOverlay(GnomeRestaurantPlugin plugin, OverlayHeader header, ArrayList<OverlayTableEntry> stepIngredientsOverlayTable, ArrayList<OverlayTableEntry> futureRawIngredientsOverlayTable) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.header = header;
        this.stepIngredientsOverlayTable = stepIngredientsOverlayTable;
        this.futureRawIngredientsOverlayTable = futureRawIngredientsOverlayTable;
        this.panelComponent.setBorder(new Rectangle(10, 10, 10, 10));
        this.panelComponent.setGap(new Point(0, 4));
    }

    public Dimension render(Graphics2D graphics) {
        String headerText = "Step " + this.header.stepNum + "/" + this.header.totalSteps + ": " + this.header.instruction;
        LineComponent headerComponent = LineComponent.builder().left(headerText).build();
        this.panelComponent.getChildren().add(headerComponent);
        this.renderOverlayTable(this.stepIngredientsOverlayTable, "Current Step");
        if (this.futureRawIngredientsOverlayTable.size() > 0) {
            this.renderOverlayTable(this.futureRawIngredientsOverlayTable, "Needed Later");
        }
        return super.render(graphics);
    }

    private void renderOverlayTable(ArrayList<OverlayTableEntry> overlayTable, String title) {
        TitleComponent titleComponent = TitleComponent.builder().text(title).build();
        this.panelComponent.getChildren().add(titleComponent);
        for (OverlayTableEntry tableEntry : overlayTable) {
            Color ingredientColor = tableEntry.getInventoryCount() >= tableEntry.getRequiredCount() ? Color.GREEN : (tableEntry.getInventoryCount() == 0 ? Color.RED : Color.YELLOW);
            LineComponent ingredientRow = LineComponent.builder().left(tableEntry.getItemName()).leftColor(ingredientColor).right(tableEntry.getInventoryCount() + "/" + tableEntry.getRequiredCount()).rightColor(ingredientColor).build();
            this.panelComponent.getChildren().add(ingredientRow);
        }
    }
}

