/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmagicala.gnomeRestaurant.data;

import io.github.mmagicala.gnomeRestaurant.recipe.Ingredient;
import io.github.mmagicala.gnomeRestaurant.recipe.Recipe;
import io.github.mmagicala.gnomeRestaurant.recipe.RecipeInstruction;
import io.github.mmagicala.gnomeRestaurant.recipe.RecipeStep;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class Recipes {
    private static final int NO_PRODUCED_ITEM_ID = -1;
    public static final ArrayList<Recipe> list = new ArrayList<Recipe>(){
        {
            this.add(new Recipe("worm hole", Recipes.createBakedRecipe(BakedRecipeType.GNOMEBOWL, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2162, 4));
                    this.add(new Ingredient(1957, 2));
                    this.add(new Ingredient(2169, 1));
                }
            }, 9559, 9560, new Ingredient(2128, 1), 2191)));
            this.add(new Recipe("vegetable ball", Recipes.createBakedRecipe(BakedRecipeType.GNOMEBOWL, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(1942, 2));
                    this.add(new Ingredient(1957, 2));
                    this.add(new Ingredient(2169, 1));
                }
            }, 9561, 9562, new Ingredient(2128, 1), 2195)));
            this.add(new Recipe("tangled toads legs", Recipes.createBakedRecipe(BakedRecipeType.GNOMEBOWL, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2152, 4));
                    this.add(new Ingredient(2169, 1));
                    this.add(new Ingredient(1985, 2));
                    this.add(new Ingredient(2126, 1));
                    this.add(new Ingredient(2128, 2));
                }
            }, 9558, 2187)));
            this.add(new Recipe("chocolate bomb", Recipes.createBakedRecipe(BakedRecipeType.GNOMEBOWL, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(1973, 4));
                    this.add(new Ingredient(2128, 1));
                }
            }, 9563, 9564, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(1975, 1));
                    this.add(new Ingredient(2130, 2));
                }
            }, 2185)));
            this.add(new Recipe("fruit batta", Recipes.createBakedRecipe(BakedRecipeType.BATTA, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2128, 4));
                    this.add(new Ingredient(2122, 1));
                    this.add(new Ingredient(2110, 1));
                    this.add(new Ingredient(2116, 1));
                }
            }, 9478, 9479, new Ingredient(2169, 1), 2277)));
            this.add(new Recipe("toad batta", Recipes.createBakedRecipe(BakedRecipeType.BATTA, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2128, 1));
                    this.add(new Ingredient(2169, 1));
                    this.add(new Ingredient(1985, 1));
                    this.add(new Ingredient(2152, 1));
                }
            }, 9482, 2255)));
            this.add(new Recipe("worm batta", Recipes.createBakedRecipe(BakedRecipeType.BATTA, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2162, 1));
                    this.add(new Ingredient(1985, 1));
                    this.add(new Ingredient(2169, 1));
                }
            }, 9480, 9481, new Ingredient(2128, 1), 2253)));
            this.add(new Recipe("vegetable batta", Recipes.createBakedRecipe(BakedRecipeType.BATTA, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(1982, 2));
                    this.add(new Ingredient(2126, 1));
                    this.add(new Ingredient(1957, 1));
                    this.add(new Ingredient(1985, 1));
                    this.add(new Ingredient(1965, 1));
                }
            }, 9485, 9486, new Ingredient(2128, 1), 2281)));
            this.add(new Recipe("cheese and tomato batta", Recipes.createBakedRecipe(BakedRecipeType.BATTA, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(1985, 1));
                    this.add(new Ingredient(1982, 1));
                }
            }, 9483, 9484, new Ingredient(2128, 1), 2259)));
            this.add(new Recipe("choc chip crunchies", Recipes.createBakedRecipe(BakedRecipeType.CRUNCHIES, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(1973, 2));
                    this.add(new Ingredient(2169, 1));
                }
            }, 9577, 9578, new Ingredient(1975, 1), 2209)));
            this.add(new Recipe("spicy crunchies", Recipes.createBakedRecipe(BakedRecipeType.CRUNCHIES, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2128, 2));
                    this.add(new Ingredient(2169, 1));
                }
            }, 9579, 9580, new Ingredient(2169, 1), 2213)));
            this.add(new Recipe("toad crunchies", Recipes.createBakedRecipe(BakedRecipeType.CRUNCHIES, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2152, 2));
                    this.add(new Ingredient(2169, 1));
                }
            }, 9581, 9582, new Ingredient(2128, 1), 2217)));
            this.add(new Recipe("worm crunchies", Recipes.createBakedRecipe(BakedRecipeType.CRUNCHIES, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2162, 2));
                    this.add(new Ingredient(2169, 1));
                    this.add(new Ingredient(2128, 1));
                }
            }, 9583, 9584, new Ingredient(2169, 1), 2205)));
            this.add(new Recipe("fruit blast", Recipes.createCocktailRecipe(new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2114, 1));
                    this.add(new Ingredient(2102, 1));
                    this.add(new Ingredient(2108, 1));
                }
            }, 9568, new Ingredient(2106, 1), 2084)));
            this.add(new Recipe("pineapple punch", Recipes.createCocktailRecipe(new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2114, 2));
                    this.add(new Ingredient(2102, 1));
                    this.add(new Ingredient(2108, 1));
                }
            }, 9569, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2122, 1));
                    this.add(new Ingredient(2116, 1));
                    this.add(new Ingredient(2112, 1));
                }
            }, 2048)));
            this.add(new Recipe("wizard blizzard", Recipes.createCocktailRecipe(new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2015, 2));
                    this.add(new Ingredient(2019, 1));
                    this.add(new Ingredient(2120, 1));
                    this.add(new Ingredient(2102, 1));
                    this.add(new Ingredient(2108, 1));
                }
            }, 9566, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2116, 1));
                    this.add(new Ingredient(2124, 1));
                }
            }, 2054)));
            this.add(new Recipe("short green guy", Recipes.createCocktailRecipe(new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2015, 1));
                    this.add(new Ingredient(2120, 3));
                }
            }, 9567, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2124, 1));
                    this.add(new Ingredient(2128, 1));
                }
            }, 2080)));
            this.add(new Recipe("drunk dragon", Recipes.createDrunkDragonRecipe()));
            this.add(new Recipe("chocolate saturday", Recipes.createChocSaturdayRecipe()));
            this.add(new Recipe("Blurberry special", Recipes.createCocktailRecipe(new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2015, 1));
                    this.add(new Ingredient(2021, 1));
                    this.add(new Ingredient(2019, 1));
                    this.add(new Ingredient(2102, 2));
                    this.add(new Ingredient(2108, 1));
                }
            }, 9570, new ArrayList<Ingredient>(){
                {
                    this.add(new Ingredient(2104, 1));
                    this.add(new Ingredient(2110, 1));
                    this.add(new Ingredient(2128, 1));
                    this.add(new Ingredient(2124, 1));
                }
            }, 2064)));
        }
    };

    private static ArrayList<RecipeStep> createBakedRecipeHelper(final BakedRecipeType bakedRecipeType, final ArrayList<Ingredient> ingredients, int halfMadeId) {
        ArrayList<RecipeStep> unfinishedRecipe = new ArrayList<RecipeStep>();
        unfinishedRecipe.add(new RecipeStep(RecipeInstruction.CREATE_RAW, new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(2171, 1));
                this.add(new Ingredient(bakedRecipeType.getToolId(), 1));
            }
        }, bakedRecipeType.getRawId()));
        unfinishedRecipe.add(new RecipeStep(RecipeInstruction.CREATE_HALF_BAKED, new Ingredient(bakedRecipeType.getRawId(), 1, true), bakedRecipeType.getHalfBakedId()));
        unfinishedRecipe.add(new RecipeStep(RecipeInstruction.COMBINE_INGREDIENTS, new ArrayList<Ingredient>(){
            {
                this.addAll(ingredients);
                this.add(new Ingredient(bakedRecipeType.getHalfBakedId(), 1, true));
            }
        }, halfMadeId));
        return unfinishedRecipe;
    }

    private static ArrayList<RecipeStep> createBakedRecipe(BakedRecipeType bakedRecipeType, ArrayList<Ingredient> ingredients, int halfMadeId, int finishedId) {
        ArrayList<RecipeStep> recipe = Recipes.createBakedRecipeHelper(bakedRecipeType, ingredients, halfMadeId);
        recipe.add(new RecipeStep(RecipeInstruction.BAKE_HALF_MADE, new Ingredient(halfMadeId, 1, true), finishedId));
        recipe.add(new RecipeStep(RecipeInstruction.DELIVER, new Ingredient(finishedId, 1, true), -1));
        return recipe;
    }

    private static ArrayList<RecipeStep> createBakedRecipe(BakedRecipeType bakedRecipeType, ArrayList<Ingredient> firstIngredients, int halfMadeId, final int unfinishedId, final ArrayList<Ingredient> toppingIngredients, int finishedId) {
        ArrayList<RecipeStep> recipe = Recipes.createBakedRecipeHelper(bakedRecipeType, firstIngredients, halfMadeId);
        recipe.add(new RecipeStep(RecipeInstruction.BAKE_HALF_MADE, new Ingredient(halfMadeId, 1, true), unfinishedId));
        recipe.add(new RecipeStep(RecipeInstruction.ADD_TOPPINGS, new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(unfinishedId, 1, true));
                this.addAll(toppingIngredients);
            }
        }, finishedId));
        recipe.add(new RecipeStep(RecipeInstruction.DELIVER, new Ingredient(finishedId, 1, true), -1));
        return recipe;
    }

    private static ArrayList<RecipeStep> createBakedRecipe(BakedRecipeType bakedRecipeType, ArrayList<Ingredient> firstIngredients, int halfMadeId, int unfinishedId, Ingredient toppingIngredient, int finishedId) {
        ArrayList<Ingredient> toppingIngredients = new ArrayList<Ingredient>();
        toppingIngredients.add(toppingIngredient);
        return Recipes.createBakedRecipe(bakedRecipeType, firstIngredients, halfMadeId, unfinishedId, toppingIngredients, finishedId);
    }

    private static ArrayList<RecipeStep> createCocktailRecipeHelper(final ArrayList<Ingredient> shakedIngredients, int mixedItem) {
        ArrayList<RecipeStep> unfinishedRecipe = new ArrayList<RecipeStep>();
        unfinishedRecipe.add(new RecipeStep(RecipeInstruction.MIX_COCKTAIL, new ArrayList<Ingredient>(){
            {
                this.addAll(shakedIngredients);
                this.add(new Ingredient(2025, 1, true));
            }
        }, mixedItem));
        return unfinishedRecipe;
    }

    private static ArrayList<RecipeStep> createCocktailRecipeHelper(ArrayList<Ingredient> shakedIngredients, final int mixedItem, final ArrayList<Ingredient> pouredIngredients, int pouredItem, boolean isCompleteRecipe) {
        ArrayList<RecipeStep> recipe = Recipes.createCocktailRecipeHelper(shakedIngredients, mixedItem);
        recipe.add(new RecipeStep(RecipeInstruction.POUR, new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(2026, 1, true));
                this.add(new Ingredient(mixedItem, 1, true));
                this.addAll(pouredIngredients);
            }
        }, pouredItem));
        if (isCompleteRecipe) {
            recipe.add(new RecipeStep(RecipeInstruction.DELIVER, new Ingredient(pouredItem, 1, true), -1));
        }
        return recipe;
    }

    private static ArrayList<RecipeStep> createCocktailRecipe(ArrayList<Ingredient> shakedIngredients, int mixedItem, ArrayList<Ingredient> pouredIngredients, int finishedItem) {
        return Recipes.createCocktailRecipeHelper(shakedIngredients, mixedItem, pouredIngredients, finishedItem, true);
    }

    private static ArrayList<RecipeStep> createCocktailRecipe(ArrayList<Ingredient> shakedIngredients, int mixedItem, Ingredient pouredIngredient, int finishedItem) {
        ArrayList<Ingredient> pouredIngredients = new ArrayList<Ingredient>();
        pouredIngredients.add(pouredIngredient);
        return Recipes.createCocktailRecipe(shakedIngredients, mixedItem, pouredIngredients, finishedItem);
    }

    private static ArrayList<RecipeStep> createDrunkDragonRecipe() {
        ArrayList<Ingredient> shakedIngredients = new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(2015, 1));
                this.add(new Ingredient(2019, 1));
                this.add(new Ingredient(2126, 1));
            }
        };
        final ArrayList<Ingredient> toppedIngredients = new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(2116, 1));
                this.add(new Ingredient(2130, 1));
            }
        };
        ArrayList<RecipeStep> recipe = Recipes.createCocktailRecipeHelper(shakedIngredients, 9574, new ArrayList<Ingredient>(), 9575, false);
        recipe.add(new RecipeStep(RecipeInstruction.ADD_TOPPINGS, new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(9575, 1, true));
                this.addAll(toppedIngredients);
            }
        }, 9576));
        recipe.add(new RecipeStep(RecipeInstruction.HEAT_COCKTAIL, new Ingredient(9576, 1, true), 2092));
        recipe.add(new RecipeStep(RecipeInstruction.DELIVER, new Ingredient(2092, 1, true), -1));
        return recipe;
    }

    private static ArrayList<RecipeStep> createChocSaturdayRecipe() {
        ArrayList<Ingredient> shakedIngredients = new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(2017, 1));
                this.add(new Ingredient(1973, 1));
                this.add(new Ingredient(2128, 1));
                this.add(new Ingredient(1927, 1));
            }
        };
        ArrayList<RecipeStep> recipe = Recipes.createCocktailRecipeHelper(shakedIngredients, 9571, new ArrayList<Ingredient>(), 9572, false);
        recipe.add(new RecipeStep(RecipeInstruction.HEAT_COCKTAIL, new Ingredient(9572, 1, true), 9573));
        recipe.add(new RecipeStep(RecipeInstruction.ADD_TOPPINGS, new ArrayList<Ingredient>(){
            {
                this.add(new Ingredient(9573, 1, true));
                this.add(new Ingredient(1975, 1));
                this.add(new Ingredient(2130, 1));
            }
        }, 2074));
        recipe.add(new RecipeStep(RecipeInstruction.DELIVER, new Ingredient(2074, 1, true), -1));
        return recipe;
    }

    public static Recipe getRecipe(String name) {
        for (Recipe recipe : list) {
            if (!recipe.getName().equals(name)) continue;
            return recipe;
        }
        throw new InvalidParameterException("Recipe with name " + name + " not found");
    }

    private static enum BakedRecipeType {
        CRUNCHIES(2202, 2165, 2201),
        BATTA(2250, 2164, 2249),
        GNOMEBOWL(2178, 2166, 2177);

        private int rawId;
        private int toolId;
        private int halfBakedId;

        private BakedRecipeType(int rawId, int toolId, int halfBakedId) {
            this.rawId = rawId;
            this.halfBakedId = halfBakedId;
            this.toolId = toolId;
        }

        public int getRawId() {
            return this.rawId;
        }

        public int getToolId() {
            return this.toolId;
        }

        public int getHalfBakedId() {
            return this.halfBakedId;
        }
    }
}

