/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmagicala.gnomeRestaurant;

import com.google.inject.Provides;
import io.github.mmagicala.gnomeRestaurant.GnomeRestaurantConfig;
import io.github.mmagicala.gnomeRestaurant.data.OrderRecipients;
import io.github.mmagicala.gnomeRestaurant.data.Recipes;
import io.github.mmagicala.gnomeRestaurant.order.OrderDifficulty;
import io.github.mmagicala.gnomeRestaurant.order.OrderRecipient;
import io.github.mmagicala.gnomeRestaurant.overlay.GnomeRestaurantOverlay;
import io.github.mmagicala.gnomeRestaurant.overlay.OverlayHeader;
import io.github.mmagicala.gnomeRestaurant.overlay.OverlayTableEntry;
import io.github.mmagicala.gnomeRestaurant.recipe.Ingredient;
import io.github.mmagicala.gnomeRestaurant.recipe.Recipe;
import java.awt.image.BufferedImage;
import java.security.InvalidParameterException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.Timer;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Gnome Restaurant")
public class GnomeRestaurantPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GnomeRestaurantPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GnomeRestaurantConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private Timer timer;
    private Overlay overlay;
    private WorldMapPoint worldMapPoint;
    private String tooltipText;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;
    private static final int VARBIT_IS_DELIVERING = 2478;
    private boolean isDelayed = false;
    private Recipe recipe;
    private OrderRecipient recipient;
    private int stepIdx;
    private final OverlayHeader overlayHeader = new OverlayHeader("null", -1, -1);
    private final ArrayList<OverlayTableEntry> stepIngredientsOverlayTable = new ArrayList();
    private final ArrayList<OverlayTableEntry> nextRawIngredientsOverlayTable = new ArrayList();
    private static final Pattern DELIVERY_START_PATTERN = Pattern.compile("([\\w .]+) wants (?:some|a) ([\\w ]+)");
    private static final String EASY_DELIVERY_CANCEL_TEXT = "Fine, your loss. If you want another easy job one come back in five minutes and maybe I'll be able to find you one.";
    private static final String HARD_DELIVERY_CANCEL_TEXT = "Fine, your loss. I may have an easier job for you, since you chickened out of that one, If you want another hard one come back in five minutes and maybe I'll be able to find you a something.";
    public static final String SHOW_DELAY_TIMER = "showDelayTimer";
    public static final String SHOW_ORDER_TIMER = "showOrderTimer";
    public static final String SHOW_OVERLAY = "showOverlay";
    public static final String SHOW_HINT_ARROW = "showHintArrow";
    public static final String SHOW_WORLD_MAP_POINT = "showWorldMapPoint";

    protected void shutDown() throws Exception {
        this.resetPlugin();
    }

    private void resetPlugin() {
        this.removeTimer();
        this.removeOverlay();
        this.removeWorldMapPoint();
        this.client.clearHintArrow();
        this.stepIdx = 0;
        this.isDelayed = false;
        this.recipe = null;
        this.recipient = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean playerCancelledOrder;
        boolean isDialogueOpen;
        boolean bl = isDialogueOpen = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME) != null;
        if (!isDialogueOpen) {
            return;
        }
        boolean isTalkingToGianneJnr = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME).getText().equals("Gianne jnr.");
        if (!isTalkingToGianneJnr) {
            return;
        }
        String dialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT).getText();
        Matcher matcher = DELIVERY_START_PATTERN.matcher(dialog = dialog.replace("<br>", " "));
        if (matcher.find()) {
            String matchedRecipient = matcher.group(1);
            String matchedRecipe = matcher.group(2);
            if (this.recipient != null && this.recipient.getAddressedName().equals(matchedRecipient) && this.recipe != null && this.recipe.getName().equals(matchedRecipe)) {
                return;
            }
            this.resetPlugin();
            this.startPlugin(matchedRecipient, matchedRecipe);
        }
        boolean bl2 = playerCancelledOrder = dialog.contains(EASY_DELIVERY_CANCEL_TEXT) || dialog.contains(HARD_DELIVERY_CANCEL_TEXT);
        if (this.config.showDelayTimer() && !this.isDelayed && playerCancelledOrder) {
            this.cancelOrder();
        }
    }

    private void cancelOrder() {
        this.resetPlugin();
        this.setupDelayTimer();
        this.isDelayed = true;
    }

    private void startPlugin(String recipientName, String recipeName) {
        this.parseOrder(recipientName, recipeName);
        this.updateStep();
        this.setupUI();
    }

    private void setupDelayTimer() {
        this.timer = new Timer(5L, ChronoUnit.MINUTES, (BufferedImage)this.itemManager.getImage(9477), (Plugin)this);
        this.timer.setTooltip("Cannot place an order at this time");
        this.infoBoxManager.addInfoBox((InfoBox)this.timer);
    }

    private void parseOrder(String addressedName, String recipeName) {
        this.recipe = Recipes.getRecipe(recipeName);
        this.recipient = OrderRecipients.getRecipient(addressedName);
    }

    private boolean updateStep() {
        int newStepIdx = 0;
        for (int i = 0; i < this.recipe.getSteps().size() - 1; ++i) {
            int producedId = this.recipe.getSteps().get(i).getProducedItemId();
            if (this.getItemCount(producedId) <= 0) continue;
            newStepIdx = i + 1;
        }
        boolean stepUpdated = false;
        if (newStepIdx != this.stepIdx) {
            stepUpdated = true;
        }
        this.stepIdx = newStepIdx;
        return stepUpdated;
    }

    private int getItemCount(int itemId) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            return 0;
        }
        return inventory.count(itemId);
    }

    private void setupUI() {
        this.tooltipText = "Deliver " + this.recipe.getName() + " to " + this.recipient.getInGameName();
        if (this.config.showOverlay()) {
            this.setupOverlay();
        }
        if (this.config.showOrderTimer()) {
            this.setupOrderTimer();
        }
        if (this.config.showHintArrow()) {
            this.showHintArrow();
        }
        if (this.config.showWorldMapPoint()) {
            this.showWorldMapPoint();
        }
    }

    private void setupOverlay() {
        this.updateOverlayHeader();
        this.rebuildOverlayTables();
        this.overlay = new GnomeRestaurantOverlay(this, this.overlayHeader, this.stepIngredientsOverlayTable, this.nextRawIngredientsOverlayTable);
        this.overlayManager.add(this.overlay);
    }

    private void setupOrderTimer() {
        int numSecondsLeft = this.recipient.getDifficulty() == OrderDifficulty.HARD ? 660 : 360;
        this.timer = new Timer((long)numSecondsLeft, ChronoUnit.SECONDS, (BufferedImage)this.itemManager.getImage(this.recipe.getItemId()), (Plugin)this);
        this.timer.setTooltip(this.tooltipText);
        this.infoBoxManager.addInfoBox((InfoBox)this.timer);
    }

    private void showHintArrow() {
        if (!this.markNPCInCache()) {
            this.client.setHintArrow(this.recipient.getLocation());
        }
    }

    private void showWorldMapPoint() {
        this.worldMapPoint = new WorldMapPoint(this.recipient.getLocation(), (BufferedImage)this.itemManager.getImage(9477));
        this.worldMapPoint.setSnapToEdge(true);
        this.worldMapPoint.setJumpOnClick(true);
        this.worldMapPoint.setTooltip(this.tooltipText);
        this.worldMapPointManager.add(this.worldMapPoint);
    }

    private boolean markNPCInCache() {
        List npcs = this.client.getNpcs();
        for (NPC npc : npcs) {
            if (npc.getName() == null || !npc.getName().equals(this.recipient.getInGameName())) continue;
            this.client.setHintArrow(npc);
            return true;
        }
        return false;
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc() == null || event.getNpc().getName() == null) {
            return;
        }
        if (this.recipe != null && event.getNpc().getName().equals(this.recipient.getInGameName()) && this.config.showHintArrow()) {
            this.client.setHintArrow(event.getNpc());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc() == null || event.getNpc().getName() == null) {
            return;
        }
        if (this.recipe != null && event.getNpc().getName().equals(this.recipient.getInGameName()) && this.config.showHintArrow()) {
            this.client.setHintArrow(this.recipient.getLocation());
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.recipe != null && this.client.getVarbitValue(2478) == 0) {
            this.resetPlugin();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.overlay != null) {
            if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
                return;
            }
            if (this.updateStep()) {
                this.updateOverlayHeader();
                this.rebuildOverlayTables();
            } else {
                this.updateOverlayTables();
            }
        }
    }

    private void updateOverlayHeader() {
        this.overlayHeader.instruction = this.recipe.getSteps().get(this.stepIdx).getInstruction().getOverlayDirections();
        this.overlayHeader.stepNum = this.stepIdx + 1;
        this.overlayHeader.totalSteps = this.recipe.getSteps().size();
    }

    private void rebuildOverlayTables() {
        this.clearOverlayTables();
        ArrayList<Ingredient> stepIngredients = this.recipe.getSteps().get(this.stepIdx).getIngredients();
        this.rebuildOverlayTable(stepIngredients, this.stepIngredientsOverlayTable);
        ArrayList<Ingredient> nextRawIngredients = this.recipe.getNextRawIngredients(this.stepIdx);
        this.rebuildOverlayTable(nextRawIngredients, this.nextRawIngredientsOverlayTable);
    }

    private void rebuildOverlayTable(ArrayList<Ingredient> ingredients, ArrayList<OverlayTableEntry> overlayTable) {
        for (Ingredient ingredient : ingredients) {
            int itemId = ingredient.getItemId();
            String itemName = this.itemManager.getItemComposition(itemId).getName();
            int inventoryCount = this.getItemCount(itemId);
            int expectedCount = ingredient.getCount();
            overlayTable.add(new OverlayTableEntry(itemId, itemName, inventoryCount, expectedCount));
        }
    }

    private void updateOverlayTables() {
        this.updateOverlayTable(this.stepIngredientsOverlayTable);
        this.updateOverlayTable(this.nextRawIngredientsOverlayTable);
    }

    private void updateOverlayTable(ArrayList<OverlayTableEntry> overlayTable) {
        for (OverlayTableEntry entry : overlayTable) {
            int inventoryCount = this.getItemCount(entry.getItemId());
            if (entry.getInventoryCount() == inventoryCount) continue;
            entry.setInventoryCount(inventoryCount);
        }
    }

    @Provides
    GnomeRestaurantConfig provideConfig(ConfigManager configManager) {
        return (GnomeRestaurantConfig)configManager.getConfig(GnomeRestaurantConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.recipe != null) {
            if (event.getKey().equals(SHOW_ORDER_TIMER)) {
                if (event.getNewValue().equals("false")) {
                    this.removeTimer();
                }
            } else if (event.getKey().equals(SHOW_OVERLAY)) {
                if (event.getNewValue().equals("false")) {
                    this.removeOverlay();
                } else {
                    this.clientThread.invoke(this::setupOverlay);
                }
            } else if (event.getKey().equals(SHOW_HINT_ARROW)) {
                if (event.getNewValue().equals("false")) {
                    this.client.clearHintArrow();
                } else {
                    this.showHintArrow();
                }
            } else if (event.getKey().equals(SHOW_WORLD_MAP_POINT)) {
                if (event.getNewValue().equals("false")) {
                    this.removeWorldMapPoint();
                } else {
                    this.showWorldMapPoint();
                }
            }
        } else {
            if (!event.getGroup().equals("gnomerestaurant")) {
                return;
            }
            if (event.getKey().equals(SHOW_DELAY_TIMER) && this.isDelayed && event.getNewValue().equals("false")) {
                this.removeTimer();
            }
        }
    }

    private void removeTimer() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.timer);
        this.timer = null;
    }

    private void removeOverlay() {
        this.clearOverlayTables();
        this.overlayManager.remove(this.overlay);
        this.overlay = null;
    }

    private void removeWorldMapPoint() {
        this.worldMapPointManager.remove(this.worldMapPoint);
        this.worldMapPoint = null;
    }

    private void clearOverlayTables() {
        this.stepIngredientsOverlayTable.clear();
        this.nextRawIngredientsOverlayTable.clear();
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (!this.developerMode) {
            return;
        }
        if (!commandExecuted.getCommand().equals("gnome")) {
            return;
        }
        if (commandExecuted.getArguments().length < 1) {
            this.printUsage();
            return;
        }
        if (commandExecuted.getArguments()[0].equals("reset")) {
            this.resetTestOrder();
            return;
        }
        if (commandExecuted.getArguments()[0].equals("cancel")) {
            this.cancelTestOrder();
            return;
        }
        if (commandExecuted.getArguments().length < 2) {
            this.printUsage();
            return;
        }
        if (this.recipe != null) {
            this.printChatMessage("Cannot test an order while another delivery is in progress");
            return;
        }
        String recipientName = commandExecuted.getArguments()[0].replace("_", " ");
        String recipeName = commandExecuted.getArguments()[1].replace("_", " ");
        this.printChatMessage("Testing order with recipient: '" + recipientName + "' and recipe '" + recipeName + "'");
        try {
            this.startPlugin(recipientName, recipeName);
        }
        catch (InvalidParameterException e) {
            this.resetTestOrder();
            this.printChatMessage("Error: InvalidParameterException caught: " + e.getMessage());
        }
        this.client.setVarbitValue(this.client.getVarps(), 2478, 1);
    }

    private void cancelTestOrder() {
        this.cancelOrder();
        this.client.setVarbitValue(this.client.getVarps(), 2478, 0);
        this.printChatMessage("Order cancelled");
    }

    private void resetTestOrder() {
        this.resetPlugin();
        this.client.setVarbitValue(this.client.getVarps(), 2478, 0);
        this.printChatMessage("Plugin reset");
    }

    private void printUsage() {
        this.printChatMessage("Usage '::gnome npc_addressed_name recipe_name'");
        this.printChatMessage("Usage '::gnome reset'");
    }

    private void printChatMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value(message).build());
    }
}

