/*
 * Decompiled with CFR 0.152.
 */
package com.pathfinder;

import com.google.inject.Provides;
import com.pathfinder.PathDisplaySetting;
import com.pathfinder.PathHighlightConfig;
import com.pathfinder.PathHighlightOverlay;
import com.pathfinder.PathKeyListener;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pathfinder", description="Highlight the path your character will take to the hovered tile", tags={"highlight", "overlay", "path", "tile", "tiles", "gauntlet", "zalcano"}, enabledByDefault=false)
public class PathHighlightPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PathHighlightPlugin.class);
    @Inject
    private PathHighlightConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PathHighlightOverlay overlay;
    @Inject
    private KeyManager keyManager;
    @Inject
    private PathKeyListener keyListener;
    boolean display;

    @Provides
    PathHighlightConfig provideConfig(ConfigManager configManager) {
        return (PathHighlightConfig)configManager.getConfig(PathHighlightConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.keyManager.registerKeyListener((KeyListener)this.keyListener);
        this.setDisplay(this.config.displaySetting() == PathDisplaySetting.ALWAYS_DISPLAY);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.keyListener);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("pathfinder") && event.getKey().equals("displaySetting")) {
            this.setDisplay(this.config.displaySetting() == PathDisplaySetting.ALWAYS_DISPLAY);
        }
    }

    boolean isDisplay() {
        return this.display;
    }

    void setDisplay(boolean display) {
        this.display = display;
    }
}

