/*
 * Decompiled with CFR 0.152.
 */
package com.pathfinder;

import com.pathfinder.PathHighlightConfig;
import com.pathfinder.PathHighlightPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class PathHighlightOverlay
extends Overlay {
    private final Client client;
    private final PathHighlightConfig config;
    private final PathHighlightPlugin plugin;

    @Inject
    private PathHighlightOverlay(Client client, PathHighlightConfig config, PathHighlightPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isDisplay()) {
            return null;
        }
        WorldPoint currPoint = this.client.getLocalPlayer().getWorldLocation();
        Tile selectedTile = this.client.getSelectedSceneTile();
        if (selectedTile != null && currPoint != null) {
            LocalPoint pt;
            boolean isRunning;
            WorldPoint selectedPoint = selectedTile.getWorldLocation();
            int xDist = selectedPoint.getX() - currPoint.getX();
            int yDist = selectedPoint.getY() - currPoint.getY();
            int dx = 0;
            int dy = 0;
            if (Math.abs(xDist) > Math.abs(yDist)) {
                dx = (int)Math.signum(xDist);
            } else {
                dy = (int)Math.signum(yDist);
            }
            boolean jumpedOver = isRunning = true;
            while (Math.abs(xDist) != Math.abs(yDist)) {
                currPoint = currPoint.dx(dx).dy(dy);
                pt = LocalPoint.fromWorld((Client)this.client, (int)currPoint.getX(), (int)currPoint.getY());
                if (!jumpedOver || !this.config.skipJumpedTiles()) {
                    this.renderTile(graphics, pt, this.config.highlightPathColor());
                }
                jumpedOver ^= isRunning;
                xDist = selectedPoint.getX() - currPoint.getX();
                yDist = selectedPoint.getY() - currPoint.getY();
            }
            dx = (int)Math.signum(xDist);
            dy = (int)Math.signum(yDist);
            while (xDist != 0 && yDist != 0) {
                currPoint = currPoint.dx(dx).dy(dy);
                pt = LocalPoint.fromWorld((Client)this.client, (int)currPoint.getX(), (int)currPoint.getY());
                if (!this.config.skipJumpedTiles() || !jumpedOver) {
                    this.renderTile(graphics, pt, this.config.highlightPathColor());
                }
                jumpedOver ^= isRunning;
                xDist = selectedPoint.getX() - currPoint.getX();
                yDist = selectedPoint.getY() - currPoint.getY();
            }
            if (!jumpedOver && this.config.skipJumpedTiles()) {
                pt = LocalPoint.fromWorld((Client)this.client, (int)currPoint.getX(), (int)currPoint.getY());
                this.renderTile(graphics, pt, this.config.highlightPathColor());
            }
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)dest);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
    }
}

