/*
 * Decompiled with CFR 0.152.
 */
package com.pathfinder;

import com.pathfinder.PathDisplaySetting;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Keybind;
import net.runelite.client.util.OSType;

@ConfigGroup(value="pathfinder")
public interface PathHighlightConfig
extends Config {
    @Alpha
    @ConfigItem(keyName="highlightPathColor", name="Path Color", description="Configures the color of the path")
    default public Color highlightPathColor() {
        return new Color(0, 127, 0, 127);
    }

    @ConfigItem(keyName="skipJumpedTiles", name="Hide Tiles Jumped Over", description="Hides tiles you would jump over when you run")
    default public boolean skipJumpedTiles() {
        return true;
    }

    @ConfigItem(keyName="displaySetting", name="Display Setting", description="Configures when the path should be displayed")
    default public PathDisplaySetting displaySetting() {
        return PathDisplaySetting.ALWAYS_DISPLAY;
    }

    @ConfigItem(keyName="displayKeybind", name="Keybind", description="Sets the keybind if configured to display the path on toggle or while a key is pressed.\nCan be combined with Shift, Ctrl and Alt as well as Command on Mac.")
    default public Keybind displayKeybind() {
        OSType osType = OSType.getOSType();
        int modifier = osType == OSType.MacOS ? 256 : 128;
        return new Keybind(90, modifier);
    }
}

