/*
 * Decompiled with CFR 0.152.
 */
package dev.yequi.emotes;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Provides;
import dev.yequi.emotes.Emote;
import dev.yequi.emotes.EmoteHighlight;
import dev.yequi.emotes.EmoteOverlay;
import dev.yequi.emotes.EmotesConfig;
import dev.yequi.emotes.ScrollMode;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Emotes", description="Highlights and labels for emotes")
public class EmotesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EmotesPlugin.class);
    public static final Map<Integer, Emote> EMOTE_SPRITE_LOOKUP = Arrays.stream(Emote.values()).collect(HashMap::new, (m, e) -> Arrays.stream(e.getSpriteIds()).forEach(i -> m.put(i, e)), HashMap::putAll);
    private static final Map<String, Emote> EMOTE_NAME_LOOKUP = Arrays.stream(Emote.values()).collect(Collectors.toMap(e -> e.getLabel().toLowerCase(), e -> e));
    @Inject
    private Client client;
    @Inject
    private EmoteOverlay overlay;
    @Inject
    private EmotesConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private Gson gson;
    private Map<Integer, EmoteHighlight> highlights = new HashMap<Integer, EmoteHighlight>();
    private boolean shouldScroll;

    @Nullable
    public static Emote emoteFromWidget(Widget w) {
        if (w.getActions() == null) {
            return null;
        }
        String emoteName = "";
        for (String action : w.getActions()) {
            if (action.equals("Perform")) {
                emoteName = w.getName();
                continue;
            }
            if (!action.startsWith("Perform ")) continue;
            emoteName = action.replace("Perform ", "");
        }
        return EMOTE_NAME_LOOKUP.get(Text.removeTags((String)emoteName).toLowerCase());
    }

    @Provides
    EmotesConfig provideConfig(ConfigManager configManager) {
        return (EmotesConfig)configManager.getConfig(EmotesConfig.class);
    }

    protected void startUp() {
        if (this.config.scrollToHighlighted()) {
            log.debug("migrating emote scroll config");
            this.config.setScrollToHighlighted(false);
            this.config.setScrollMode(ScrollMode.MIDDLE);
        }
        if (!this.config.savedHighlightInfo().isEmpty()) {
            Map<Integer, EmoteHighlight> highlights = this.getHighlights(true).values().stream().filter(e -> EMOTE_SPRITE_LOOKUP.containsKey(e.getSpriteId())).map(h -> {
                Emote emote = EMOTE_SPRITE_LOOKUP.get(h.getSpriteId());
                return h.withSpriteId(emote.ordinal());
            }).collect(Collectors.toMap(EmoteHighlight::getSpriteId, e -> e, (a, b) -> a));
            log.debug("migrated old highlights: {} values", (Object)highlights.size());
            this.config.setSavedHighlightInfoV2(this.gson.toJson(highlights.values()));
            this.config.setSavedHighlightInfo("");
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.refreshHighlights();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("emotes") || !event.getKey().equals("savedHighlightInfo")) {
            return;
        }
        this.refreshHighlights();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 216) {
            this.shouldScroll = true;
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (!this.client.isKeyPressed(81)) {
            return;
        }
        Emote emote = Arrays.stream(event.getMenuEntries()).map(MenuEntry::getWidget).filter(w -> w != null && w.getActions() != null).map(EmotesPlugin::emoteFromWidget).filter(Objects::nonNull).findFirst().orElse(null);
        if (emote != null) {
            int emoteId = emote.ordinal();
            EmoteHighlight highlight = this.highlights.get(emoteId);
            boolean highlighted = highlight != null;
            this.client.createMenuEntry(1).setOption(highlighted ? "Remove highlight" : "Add highlight").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.toggleHighlight(emoteId, highlighted));
            if (highlighted && this.config.rememberEmoteColors()) {
                this.client.createMenuEntry(1).setOption("Update colors").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.updateColors(highlight));
            }
            if (highlighted && this.config.displayLabels()) {
                this.client.createMenuEntry(1).setOption("Change label").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.editLabel(emoteId, highlight.getLabel()));
            }
            this.client.createMenuEntry(1).setOption("Scroll-on-reset").setTarget("").setType(MenuAction.RUNELITE).onClick(e -> this.config.setEmoteToScrollTo(emote));
        }
    }

    void scrollToHighlight(Widget widget) {
        if (!this.shouldScroll || this.config.scrollMode() == ScrollMode.DISABLED || widget == null) {
            return;
        }
        Widget parent = this.client.getWidget(WidgetInfo.EMOTE_SCROLL_CONTAINER);
        if (parent == null) {
            return;
        }
        this.shouldScroll = false;
        int y = widget.getRelativeY();
        int offset = 0;
        switch (this.config.scrollMode()) {
            case TOP: {
                y -= 6;
                break;
            }
            case MIDDLE: {
                y += widget.getHeight() / 2;
                offset += parent.getHeight() / 2;
                break;
            }
            case BOTTOM: {
                y += widget.getHeight();
                offset += parent.getHeight();
            }
        }
        int scroll = Math.max(0, Math.min(parent.getScrollHeight(), y - offset));
        log.debug("scrolling widget {} to {}", (Object)widget.getSpriteId(), (Object)scroll);
        this.client.runScript(new Object[]{72, WidgetInfo.EMOTE_SCROLLBAR.getId(), WidgetInfo.EMOTE_SCROLL_CONTAINER.getId(), scroll});
    }

    private void toggleHighlight(int emoteId, boolean highlighted) {
        if (highlighted) {
            this.highlights.remove(emoteId);
        } else {
            EmoteHighlight highlight = new EmoteHighlight(emoteId, this.config.fillColor(), this.config.borderColor(), this.config.labelColor(), "");
            this.highlights.put(emoteId, highlight);
        }
        this.saveHighlights();
    }

    private void updateColors(EmoteHighlight highlight) {
        EmoteHighlight newHighlight = new EmoteHighlight(highlight.getSpriteId(), this.config.fillColor(), this.config.borderColor(), this.config.labelColor(), highlight.getLabel());
        this.highlights.put(highlight.getSpriteId(), newHighlight);
        this.saveHighlights();
    }

    private void editLabel(int emoteId, String currentLabel) {
        this.chatboxPanelManager.openTextInput("Emote label").value(Optional.ofNullable(currentLabel).orElse("")).onDone(label -> {
            EmoteHighlight highlight = this.highlights.get(emoteId);
            if (highlight != null) {
                this.highlights.put(emoteId, highlight.withLabel((String)label));
                this.saveHighlights();
            }
        }).build();
    }

    private void refreshHighlights() {
        this.highlights = this.getHighlights(false);
    }

    private Map<Integer, EmoteHighlight> getHighlights(boolean legacy) {
        String json;
        String string = json = legacy ? this.config.savedHighlightInfo() : this.config.savedHighlightInfoV2();
        if (Strings.isNullOrEmpty((String)json)) {
            return new HashMap<Integer, EmoteHighlight>();
        }
        Type type = new TypeToken<Collection<EmoteHighlight>>(){}.getType();
        Collection saved = (Collection)this.gson.fromJson(json, type);
        return saved.stream().collect(Collectors.toMap(EmoteHighlight::getSpriteId, s -> s));
    }

    private void saveHighlights() {
        this.config.setSavedHighlightInfoV2(this.gson.toJson(this.highlights.values()));
    }

    public Map<Integer, EmoteHighlight> getHighlights() {
        return this.highlights;
    }

    static {
        EMOTE_NAME_LOOKUP.put("fragment unlock", Emote.RELIC_UNLOCK);
    }
}

