/*
 * Decompiled with CFR 0.152.
 */
package dev.yequi.emotes;

import dev.yequi.emotes.Emote;
import dev.yequi.emotes.ScrollMode;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="emotes")
public interface EmotesConfig
extends Config {
    public static final String GROUP = "emotes";
    public static final String KEY_SAVED = "savedHighlightInfo";

    @Alpha
    @ConfigItem(position=1, keyName="borderColor", name="Border color", description="Color of border around the emote")
    default public Color borderColor() {
        return Color.ORANGE;
    }

    @Alpha
    @ConfigItem(position=2, keyName="fillColor", name="Fill color", description="Color of fill highlight on emote")
    default public Color fillColor() {
        return new Color(0, 255, 0, 20);
    }

    @ConfigItem(position=3, keyName="labelColor", name="Label color", description="Color of label on emote")
    default public Color labelColor() {
        return Color.WHITE;
    }

    @ConfigItem(position=4, keyName="rememberEmoteColors", name="Remember color per emote", description="Uses the colors from time of placement on each emote")
    default public boolean rememberEmoteColors() {
        return false;
    }

    @ConfigItem(position=5, keyName="displayLabels", name="Display labels", description="Shows/hides labels for all emotes")
    default public boolean displayLabels() {
        return true;
    }

    @ConfigItem(position=6, keyName="scrollToHighlighted", name="Scroll to first highlight", description="Scrolls the emotes tab to the first highlighted item whenever the tab is reset", hidden=true)
    default public boolean scrollToHighlighted() {
        return true;
    }

    @ConfigItem(position=6, keyName="scrollToHighlighted", name="Scroll to first highlight", description="Scrolls the emotes tab to the first highlighted item whenever the tab is reset", hidden=true)
    public void setScrollToHighlighted(boolean var1);

    @ConfigItem(position=6, keyName="emoteToScrollTo", name="Emote to scroll to", description="Scrolls to this emote whenever the tab resets (if scroll mode enabled)")
    default public Emote emoteToScrollTo() {
        return Emote.YES;
    }

    @ConfigItem(position=6, keyName="emoteToScrollTo", name="Emote to scroll to", description="Scrolls to this emote whenever the tab resets (if scroll mode enabled)", hidden=true)
    public void setEmoteToScrollTo(Emote var1);

    @ConfigItem(position=7, keyName="scrollMode", name="Scroll mode", description="Where the scrolled-to emote will appear relative to the container")
    default public ScrollMode scrollMode() {
        return ScrollMode.DISABLED;
    }

    @ConfigItem(position=7, keyName="scrollMode", name="Scroll mode", description="Where the scrolled-to emote will appear relative to the container", hidden=true)
    public void setScrollMode(ScrollMode var1);

    @ConfigItem(keyName="savedHighlightInfoV2", name="Highlighted emote info", description="Map of sprite ids to highlight", hidden=true)
    default public String savedHighlightInfoV2() {
        return "";
    }

    @ConfigItem(keyName="savedHighlightInfoV2", name="Highlighted emote info", description="Map of sprite ids to highlight", hidden=true)
    public void setSavedHighlightInfoV2(String var1);

    @ConfigItem(keyName="savedHighlightInfo", name="Highlighted emote info", description="Map of sprite ids to highlight", hidden=true)
    default public String savedHighlightInfo() {
        return "";
    }

    @ConfigItem(keyName="savedHighlightInfo", name="Highlighted emote info", description="Map of sprite ids to highlight", hidden=true)
    public void setSavedHighlightInfo(String var1);
}

