/*
 * Decompiled with CFR 0.152.
 */
package dev.yequi.emotes;

import com.google.common.base.Strings;
import dev.yequi.emotes.Emote;
import dev.yequi.emotes.EmoteHighlight;
import dev.yequi.emotes.EmotesConfig;
import dev.yequi.emotes.EmotesPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.TextComponent;

public class EmoteOverlay
extends Overlay {
    private final EmotesPlugin plugin;
    private final EmotesConfig config;
    private final Client client;
    private final TextComponent textComponent = new TextComponent();

    @Inject
    private EmoteOverlay(EmotesPlugin plugin, EmotesConfig config, Client client) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        Widget emoteContainer = this.client.getWidget(WidgetInfo.EMOTE_CONTAINER);
        if (emoteContainer == null || emoteContainer.isHidden()) {
            return null;
        }
        Widget emoteWindow = this.client.getWidget(WidgetInfo.EMOTE_WINDOW);
        if (emoteWindow == null) {
            return null;
        }
        Map<Integer, EmoteHighlight> highlights = this.plugin.getHighlights();
        int[] spriteIds = this.config.emoteToScrollTo().getSpriteIds();
        for (Widget emoteWidget : emoteContainer.getDynamicChildren()) {
            EmoteHighlight value;
            Emote emote;
            for (int spriteId : spriteIds) {
                if (spriteId != emoteWidget.getSpriteId()) continue;
                this.plugin.scrollToHighlight(emoteWidget);
                break;
            }
            if ((emote = EmotesPlugin.emoteFromWidget(emoteWidget)) == null || (value = highlights.get(emote.ordinal())) == null) continue;
            this.highlight(graphics, value, emoteWidget, emoteWindow);
        }
        return null;
    }

    private void highlight(Graphics2D graphics, EmoteHighlight value, Widget emoteWidget, Widget container) {
        Point canvasLocation = emoteWidget.getCanvasLocation();
        if (canvasLocation == null) {
            return;
        }
        Point windowLocation = container.getCanvasLocation();
        if (windowLocation.getY() > canvasLocation.getY() + emoteWidget.getHeight() || windowLocation.getY() + container.getHeight() < canvasLocation.getY()) {
            return;
        }
        Area widgetArea = new Area(new Rectangle(canvasLocation.getX(), Math.max(canvasLocation.getY(), windowLocation.getY()), emoteWidget.getWidth(), Math.min(Math.min(windowLocation.getY() + container.getHeight() - canvasLocation.getY(), emoteWidget.getHeight()), Math.min(canvasLocation.getY() + emoteWidget.getHeight() - windowLocation.getY(), emoteWidget.getHeight()))));
        Color fillColor = this.config.rememberEmoteColors() ? value.getFillColor() : this.config.fillColor();
        Color borderColor = this.config.rememberEmoteColors() ? value.getBorderColor() : this.config.borderColor();
        Color borderHoverColor = borderColor.darker();
        OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)widgetArea, (Point)this.client.getMouseCanvasPosition(), (Color)fillColor, (Color)borderColor, (Color)borderHoverColor);
        String text = value.getLabel();
        if (!this.config.displayLabels() || Strings.isNullOrEmpty((String)text) || emoteWidget.getHeight() + canvasLocation.getY() > windowLocation.getY() + container.getHeight()) {
            return;
        }
        Color textColor = this.config.rememberEmoteColors() ? value.getTextColor() : this.config.labelColor();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.textComponent.setPosition(new java.awt.Point(canvasLocation.getX() + emoteWidget.getWidth() / 2 - fontMetrics.stringWidth(text) / 2, canvasLocation.getY() + emoteWidget.getHeight()));
        this.textComponent.setText(text);
        this.textComponent.setColor(textColor);
        this.textComponent.render(graphics);
    }
}

