/*
 * Decompiled with CFR 0.152.
 */
package com.firetimer;

import com.firetimer.FireTimeLocation;
import com.firetimer.FireTimerConfig;
import com.firetimer.FireTimerOverlay;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fire Timer")
public class FireTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FireTimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FireTimerOverlay fireTimerOverlay;
    private long lastTrueTickUpdate;
    private Map<Long, FireTimeLocation> fireIds;

    protected void startUp() throws Exception {
        this.fireIds = new HashMap<Long, FireTimeLocation>();
        this.overlayManager.add((Overlay)this.fireTimerOverlay);
    }

    protected void shutDown() throws Exception {
        this.fireIds.clear();
        this.overlayManager.remove((Overlay)this.fireTimerOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.fireIds.clear();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned objectSpawned) {
        if (objectSpawned.getGameObject().getId() == 26185) {
            this.fireIds.putIfAbsent(objectSpawned.getGameObject().getHash(), new FireTimeLocation(objectSpawned.getGameObject(), objectSpawned.getGameObject().getWorldLocation(), 0L, this.lastTrueTickUpdate));
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned objectDespawned) {
        if (objectDespawned.getGameObject().getId() == 26185) {
            this.fireIds.remove(objectDespawned.getGameObject().getHash());
        }
    }

    @Subscribe
    public void onGameTick(GameTick change) {
        this.lastTrueTickUpdate = this.client.getTickCount();
        this.fireIds.forEach((fireIdHash, fireTimeLocation) -> fireTimeLocation.setTicksSinceFireLit(this.lastTrueTickUpdate - fireTimeLocation.getTickFireStarted()));
    }

    @Provides
    FireTimerConfig provideConfig(ConfigManager configManager) {
        return (FireTimerConfig)configManager.getConfig(FireTimerConfig.class);
    }

    long getLastTrueTickUpdate() {
        return this.lastTrueTickUpdate;
    }

    Map<Long, FireTimeLocation> getFireIds() {
        return this.fireIds;
    }
}

