/*
 * Decompiled with CFR 0.152.
 */
package com.firetimer;

import com.firetimer.FireTimeLocation;
import com.firetimer.FireTimerConfig;
import com.firetimer.FireTimerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class FireTimerOverlay
extends Overlay {
    private final FireTimerPlugin plugin;
    private final FireTimerConfig config;
    NumberFormat format = new DecimalFormat("#");
    final int FIRE_MAX_TICKS = 200;
    final int FIRE_MIN_TICKS = 100;

    @Inject
    FireTimerOverlay(FireTimerPlugin plugin, FireTimerConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        this.plugin.getFireIds().forEach((fireIdHash, fireTimeLocation) -> this.renderTimer((FireTimeLocation)fireTimeLocation, graphics));
        return null;
    }

    private void renderTimer(FireTimeLocation fireTimeLocation, Graphics2D graphics) {
        Objects.requireNonNull(this);
        double timeLeft = 200L - fireTimeLocation.getTicksSinceFireLit();
        Color timerColor = this.config.normalTimerColor();
        if (timeLeft < 0.0) {
            timeLeft = 0.0;
        }
        if (timeLeft <= (double)this.FIRE_MIN_TICKS) {
            timerColor = this.config.lowTimerColor();
        }
        String timeLeftString = String.valueOf(this.format.format(timeLeft));
        Point canvasPoint = fireTimeLocation.getFire().getCanvasTextLocation(graphics, timeLeftString, 40);
        if (canvasPoint != null && timeLeft >= 0.0) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasPoint, (String)timeLeftString, (Color)timerColor);
        }
    }
}

