/*
 * Decompiled with CFR 0.152.
 */
package com.metronomeinfobox;

import com.google.inject.Provides;
import com.metronomeinfobox.MetronomeInfoBox;
import com.metronomeinfobox.MetronomeInfoBoxConfig;
import javax.inject.Inject;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Metronome Infobox")
public class MetronomeInfoBoxPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MetronomeInfoBoxPlugin.class);
    @Inject
    private MetronomeInfoBoxConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    private MetronomeInfoBox infoBox;

    protected void startUp() throws Exception {
        this.infoBox = new MetronomeInfoBox(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"metronome-0.png"), this, this.config);
        this.infoBoxManager.addInfoBox((InfoBox)this.infoBox);
    }

    protected void shutDown() throws Exception {
        if (this.infoBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.infoBox != null) {
            this.infoBox.onGameTick();
            this.infoBoxManager.updateInfoBoxImage((InfoBox)this.infoBox);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.infoBox != null && event.getGroup().equals("metronomeinfobox")) {
            this.infoBox.onConfigChanged(this.config);
        }
    }

    @Provides
    MetronomeInfoBoxConfig provideConfig(ConfigManager configManager) {
        return (MetronomeInfoBoxConfig)configManager.getConfig(MetronomeInfoBoxConfig.class);
    }
}

