/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog.util;

import com.evansloan.collectionlog.CollectionLog;
import com.evansloan.collectionlog.CollectionLogItem;
import com.evansloan.collectionlog.CollectionLogKillCount;
import com.evansloan.collectionlog.CollectionLogPage;
import com.evansloan.collectionlog.CollectionLogTab;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CollectionLogDeserializer
implements JsonDeserializer<CollectionLog> {
    private static final String COLLECTION_LOG_ITEMS_KEY = "items";
    private static final String COLLECTION_LOG_KILL_COUNTS_KEY = "killCounts";
    private static final String COLLECTION_LOG_TABS_KEY = "tabs";
    private static final String COLLECTION_LOG_TOTAL_OBTAINED_KEY = "totalObtained";
    private static final String COLLECTION_LOG_TOTAL_ITEMS_KEY = "totalItems";
    private static final String COLLECTION_LOG_UNIQUE_OBTAINED_KEY = "uniqueObtained";
    private static final String COLLECTION_LOG_UNIQUE_ITEMS_KEY = "uniqueItems";
    private static final String COLLECTION_LOG_IS_UPDATED_KEY = "isUpdated";
    private final Map<String, String> keyMap = new HashMap<String, String>(){
        {
            this.put(CollectionLogDeserializer.COLLECTION_LOG_KILL_COUNTS_KEY, CollectionLogDeserializer.COLLECTION_LOG_KILL_COUNTS_KEY);
            this.put(CollectionLogDeserializer.COLLECTION_LOG_TOTAL_OBTAINED_KEY, CollectionLogDeserializer.COLLECTION_LOG_TOTAL_OBTAINED_KEY);
            this.put(CollectionLogDeserializer.COLLECTION_LOG_TOTAL_ITEMS_KEY, CollectionLogDeserializer.COLLECTION_LOG_TOTAL_ITEMS_KEY);
            this.put(CollectionLogDeserializer.COLLECTION_LOG_UNIQUE_OBTAINED_KEY, CollectionLogDeserializer.COLLECTION_LOG_UNIQUE_OBTAINED_KEY);
            this.put(CollectionLogDeserializer.COLLECTION_LOG_UNIQUE_ITEMS_KEY, CollectionLogDeserializer.COLLECTION_LOG_UNIQUE_ITEMS_KEY);
        }
    };

    public CollectionLog deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObjectLog = jsonElement.getAsJsonObject();
        JsonObject jsonObjectTabs = jsonObjectLog.get(COLLECTION_LOG_TABS_KEY).getAsJsonObject();
        HashMap<String, CollectionLogTab> newTabs = new HashMap<String, CollectionLogTab>();
        for (String tabKey : jsonObjectTabs.keySet()) {
            JsonObject tab = jsonObjectTabs.get(tabKey).getAsJsonObject();
            HashMap<String, CollectionLogPage> newPages = new HashMap<String, CollectionLogPage>();
            for (String pageKey : tab.keySet()) {
                JsonObject page = tab.get(pageKey).getAsJsonObject();
                ArrayList<CollectionLogItem> newItems = new ArrayList<CollectionLogItem>();
                for (JsonElement item : page.get(COLLECTION_LOG_ITEMS_KEY).getAsJsonArray()) {
                    CollectionLogItem newItem = (CollectionLogItem)context.deserialize(item, CollectionLogItem.class);
                    newItems.add(newItem);
                }
                ArrayList<CollectionLogKillCount> newKillCounts = new ArrayList<CollectionLogKillCount>();
                JsonElement pageKillCounts = page.get(this.keyMap.get(COLLECTION_LOG_KILL_COUNTS_KEY));
                if (pageKillCounts != null) {
                    for (JsonElement killCount : pageKillCounts.getAsJsonArray()) {
                        CollectionLogKillCount newKillCount = (CollectionLogKillCount)context.deserialize(killCount, CollectionLogKillCount.class);
                        newKillCounts.add(newKillCount);
                    }
                }
                boolean isUpdated = page.get(COLLECTION_LOG_IS_UPDATED_KEY) != null && page.get(COLLECTION_LOG_IS_UPDATED_KEY).getAsBoolean();
                CollectionLogPage newPage = new CollectionLogPage(pageKey, newItems, newKillCounts, isUpdated);
                newPages.put(pageKey, newPage);
            }
            CollectionLogTab newTab = new CollectionLogTab(tabKey, newPages);
            newTabs.put(tabKey, newTab);
        }
        return new CollectionLog("", jsonObjectLog.get(this.keyMap.get(COLLECTION_LOG_TOTAL_OBTAINED_KEY)).getAsInt(), jsonObjectLog.get(this.keyMap.get(COLLECTION_LOG_TOTAL_ITEMS_KEY)).getAsInt(), jsonObjectLog.get(this.keyMap.get(COLLECTION_LOG_UNIQUE_OBTAINED_KEY)).getAsInt(), jsonObjectLog.get(this.keyMap.get(COLLECTION_LOG_UNIQUE_ITEMS_KEY)).getAsInt(), newTabs);
    }
}

