/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog.ui;

import com.evansloan.collectionlog.CollectionLogPlugin;
import java.awt.image.BufferedImage;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.swing.ImageIcon;
import net.runelite.client.util.ImageUtil;

public enum Icon {
    ACCOUNT("/account.png"),
    COLLECTION_LOG("/collection_log.png"),
    COLLECTION_LOG_TOOLBAR("/collection_log_toolbar.png"),
    DISCORD("/discord.png"),
    GITHUB("/github.png"),
    HELP("/help.png"),
    RANDOM("/random.png"),
    INFO("/info.png");

    private final String file;

    private Icon(String file) {
        this.file = file;
    }

    public BufferedImage getImage() {
        return ImageUtil.loadImageResource(CollectionLogPlugin.class, (String)this.file);
    }

    public ImageIcon getIcon() {
        return this.getIcon(UnaryOperator.identity());
    }

    public ImageIcon getIcon(@Nonnull UnaryOperator<BufferedImage> func) {
        BufferedImage img = (BufferedImage)func.apply(this.getImage());
        return new ImageIcon(img);
    }
}

