/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.runelite.api.GameState;

public class GameStatePanel
extends JPanel {
    private static List<GameStatePanel> gameStatePanelList = new ArrayList<GameStatePanel>();
    private JComponent loggedInContent;
    private JComponent loggedOutContent;

    public GameStatePanel() {
        gameStatePanelList.add(this);
    }

    public static void updatePanels(GameState gameState) {
        boolean isLoggedIn = gameState == GameState.LOGGED_IN;
        for (GameStatePanel gameStatePanel : gameStatePanelList) {
            gameStatePanel.updateContent(isLoggedIn);
        }
    }

    public void updateContent(boolean isLoggedIn) {
        this.removeAll();
        if (isLoggedIn) {
            this.add(this.loggedInContent);
        } else {
            this.add(this.loggedOutContent);
        }
        this.revalidate();
        this.repaint();
    }

    public JComponent getLoggedInContent() {
        return this.loggedInContent;
    }

    public JComponent getLoggedOutContent() {
        return this.loggedOutContent;
    }

    public void setLoggedInContent(JComponent loggedInContent) {
        this.loggedInContent = loggedInContent;
    }

    public void setLoggedOutContent(JComponent loggedOutContent) {
        this.loggedOutContent = loggedOutContent;
    }
}

