/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class ExpandablePanel
extends JPanel {
    private final JPanel titlePanel;
    private final JLabel titleLabel;
    private final JComponent content;
    private boolean isExpanded;

    public ExpandablePanel(String title, JComponent content, boolean isExpanded) {
        this.isExpanded = isExpanded;
        this.content = content;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.titlePanel = new JPanel();
        this.titlePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.titlePanel.setBackground(isExpanded ? ColorScheme.BRAND_ORANGE : ColorScheme.DARKER_GRAY_COLOR);
        this.titlePanel.setCursor(Cursor.getPredefinedCursor(12));
        this.titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExpandablePanel.this.handleMouseClick();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ExpandablePanel.this.handleMouseHover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ExpandablePanel.this.handleMouseHover(false);
            }
        });
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(FontManager.getRunescapeBoldFont());
        this.titleLabel.setForeground(isExpanded ? Color.BLACK : Color.WHITE);
        this.titlePanel.add(this.titleLabel);
        content.setVisible(isExpanded);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)content, "Center");
    }

    public ExpandablePanel(String title, JComponent content) {
        this(title, content, false);
    }

    private void handleMouseClick() {
        this.isExpanded = !this.isExpanded;
        Color color = this.isExpanded ? ColorScheme.BRAND_ORANGE : ColorScheme.DARKER_GRAY_COLOR;
        Color textColor = this.isExpanded ? Color.BLACK : Color.WHITE;
        this.titlePanel.setBackground(color);
        this.titleLabel.setForeground(textColor);
        this.content.setVisible(this.isExpanded);
    }

    private void handleMouseHover(boolean isHovering) {
        Color color = ColorScheme.DARKER_GRAY_COLOR;
        if (isHovering) {
            color = ColorScheme.DARKER_GRAY_HOVER_COLOR;
            if (this.isExpanded) {
                color = ColorScheme.BRAND_ORANGE.darker();
            }
        } else if (this.isExpanded) {
            color = ColorScheme.BRAND_ORANGE;
        }
        this.titlePanel.setBackground(color);
    }
}

