/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog;

import com.evansloan.collectionlog.CollectionLog;
import com.evansloan.collectionlog.CollectionLogApiClient;
import com.evansloan.collectionlog.CollectionLogConfig;
import com.evansloan.collectionlog.CollectionLogItem;
import com.evansloan.collectionlog.CollectionLogKillCount;
import com.evansloan.collectionlog.CollectionLogList;
import com.evansloan.collectionlog.CollectionLogManager;
import com.evansloan.collectionlog.CollectionLogPage;
import com.evansloan.collectionlog.CollectionLogPanel;
import com.evansloan.collectionlog.CollectionLogTab;
import com.evansloan.collectionlog.UserSettings;
import com.evansloan.collectionlog.ui.Icon;
import com.evansloan.collectionlog.util.CollectionLogDeserializer;
import com.evansloan.collectionlog.util.JsonUtils;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Collection Log", description="Share your collection log progress on collectionlog.net", tags={"collection", "log"})
public class CollectionLogPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogPlugin.class);
    private static final String CONFIG_GROUP = "collectionlog";
    private static final String CONFIG_SHOW_PANEL = "show_collection_log_panel";
    private static final int COLLECTION_LOG_CONTAINER = 1;
    private static final int COLLECTION_LOG_ACTIVE_TAB_VARBIT_ID = 6905;
    private static final int COLLECTION_LOG_ACTIVE_PAGE_VARBIT_ID = 6906;
    private static final int COLLECTION_LOG_COMPLETED_PAGE_COLOR = 901389;
    private static final String COLLECTION_LOG_TITLE = "Collection Log";
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log: (.*)");
    private static final String COLLECTION_LOG_TARGET = "Collection log";
    private static final String COLLECTION_LOG_EXPORT = "Export";
    private static final String COLLECTION_LOG_COMMAND_STRING = "!log";
    private static final List<String> COLLECTION_LOG_COMMAND_FILTERS = ImmutableList.of((Object)"missing", (Object)"obtained", (Object)"dupes");
    private static final Pattern COLLECTION_LOG_COMMAND_PATTERN = Pattern.compile("!log\\s*(" + String.join((CharSequence)"|", COLLECTION_LOG_COMMAND_FILTERS) + ")?\\s*([\\w\\s]+)?", 2);
    private static final int ADVENTURE_LOG_COLLECTION_LOG_SELECTED_VARBIT_ID = 12061;
    private static final Pattern ADVENTURE_LOG_TITLE_PATTERN = Pattern.compile("The Exploits of (.+)");
    private CollectionLogPanel collectionLogPanel;
    private NavigationButton navigationButton;
    private boolean isCollectionLogDeleted = false;
    private boolean isUserLoggedIn = false;
    private boolean userSettingsLoaded = false;
    private boolean isPohOwner = false;
    private String obtainedItemName;
    private Multiset<Integer> inventoryItems;
    private Map<Integer, Integer> loadedCollectionLogIcons;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private CollectionLogConfig config;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ItemManager itemManager;
    @Inject
    private CollectionLogApiClient apiClient;
    @Inject
    private CollectionLogManager collectionLogManager;
    @Inject
    private JsonUtils jsonUtils;

    @Provides
    CollectionLogConfig provideConfig(ConfigManager configManager) {
        return (CollectionLogConfig)configManager.getConfig(CollectionLogConfig.class);
    }

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.isUserLoggedIn = true;
            this.unsetOldConfigs();
        }
        if (this.config.showCollectionLogSidePanel()) {
            this.initPanel();
        }
        this.executor.submit(() -> this.collectionLogManager.loadCollectionLogFiles());
        this.loadedCollectionLogIcons = new HashMap<Integer, Integer>();
        this.chatCommandManager.registerCommandAsync(COLLECTION_LOG_COMMAND_STRING, this::collectionLogLookup);
    }

    protected void shutDown() {
        this.destroyPanel();
        this.chatCommandManager.unregisterCommand(COLLECTION_LOG_COMMAND_STRING);
        this.loadedCollectionLogIcons.clear();
    }

    private void initPanel() {
        this.collectionLogPanel = new CollectionLogPanel(this, this.collectionLogManager, this.clientThread, this.config, this.itemManager);
        this.collectionLogPanel.create(this.client.getGameState());
        if (this.navigationButton == null) {
            BufferedImage navigationButtonIcon = Icon.COLLECTION_LOG_TOOLBAR.getImage();
            this.navigationButton = NavigationButton.builder().tooltip(COLLECTION_LOG_TITLE).icon(navigationButtonIcon).panel((PluginPanel)this.collectionLogPanel).priority(10).build();
        }
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    private void destroyPanel() {
        this.collectionLogPanel = null;
        this.clientToolbar.removeNavigation(this.navigationButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        if (configChanged.getKey().equals(CONFIG_SHOW_PANEL)) {
            if (this.config.showCollectionLogSidePanel()) {
                this.initPanel();
            } else {
                this.destroyPanel();
            }
        }
        if (this.collectionLogPanel != null) {
            this.collectionLogPanel.onConfigChanged(configChanged);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (!this.isValidWorldType()) {
            return;
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.isUserLoggedIn = true;
            if (this.collectionLogPanel != null) {
                this.collectionLogPanel.setStatus("", false, true);
            }
            this.unsetOldConfigs();
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.saveCollectionLogData();
            this.collectionLogManager.reset();
            this.resetFlags();
        }
        if (this.collectionLogPanel != null) {
            this.collectionLogPanel.onGameStateChanged(gameStateChanged);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.userSettingsLoaded) {
            return;
        }
        if (!this.isUserLoggedIn) {
            return;
        }
        this.collectionLogManager.setUsername(this.client.getLocalPlayer().getName());
        this.executor.execute(() -> {
            UserSettings userSettings = this.collectionLogManager.loadUserSettingsFile();
            if (userSettings == null) {
                userSettings = new UserSettings();
            }
            this.collectionLogManager.setUserSettings(userSettings);
            this.collectionLogPanel.setUserSettings(userSettings);
        });
        this.userSettingsLoaded = true;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 2730) {
            this.clientThread.invokeLater(this::getPage);
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (event.getMenuEntries().length < 2) {
            return;
        }
        MenuEntry entry = event.getMenuEntries()[1];
        String entryTarget = entry.getTarget();
        if (entryTarget.equals("")) {
            entryTarget = entry.getOption();
        }
        if (!entryTarget.toLowerCase().endsWith(COLLECTION_LOG_TARGET.toLowerCase())) {
            return;
        }
        this.client.createMenuEntry(1).setOption(COLLECTION_LOG_EXPORT).setTarget(entryTarget).setType(MenuAction.RUNELITE).onClick(e -> {
            boolean collectionLogSaved = this.collectionLogManager.saveCollectionLogFile(true);
            if (collectionLogSaved) {
                String filePath = this.collectionLogManager.getExportFilePath();
                String message = "Collection log exported to " + filePath;
                if (this.config.sendExportChatMessage()) {
                    String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                }
            }
        });
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 187) {
            Widget adventureLog = this.client.getWidget(WidgetInfo.ADVENTURE_LOG);
            if (adventureLog == null) {
                return;
            }
            this.clientThread.invokeLater(() -> {
                Matcher adventureLogUser = ADVENTURE_LOG_TITLE_PATTERN.matcher(adventureLog.getChild(1).getText());
                if (adventureLogUser.find()) {
                    this.isPohOwner = adventureLogUser.group(1).equals(this.client.getLocalPlayer().getName());
                }
            });
        }
        if (widgetLoaded.getGroupId() == 621) {
            if (!this.collectionLogManager.isInitialized()) {
                this.collectionLogManager.initCollectionLog();
            }
            this.collectionLogManager.updateUniqueCounts();
        }
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (this.obtainedItemName == null) {
            this.inventoryItems = null;
            return;
        }
        ItemStack obtainedItem = null;
        Collection items = lootReceived.getItems();
        for (ItemStack item : items) {
            ItemComposition itemComp = this.itemManager.getItemComposition(item.getId());
            if (!itemComp.getName().equals(this.obtainedItemName)) continue;
            obtainedItem = item;
        }
        if (obtainedItem == null) {
            this.obtainedItemName = null;
            this.inventoryItems = null;
            return;
        }
        this.updateObtainedItem(obtainedItem);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        Matcher m = COLLECTION_LOG_ITEM_REGEX.matcher(chatMessage.getMessage());
        if (!m.matches()) {
            return;
        }
        this.obtainedItemName = Text.removeTags((String)m.group(1));
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            this.obtainedItemName = null;
            this.inventoryItems = null;
            return;
        }
        Arrays.stream(inventory.getItems()).forEach(item -> this.inventoryItems.add((Object)item.getId(), item.getQuantity()));
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        if (this.obtainedItemName == null) {
            this.inventoryItems = HashMultiset.create();
            return;
        }
        if (this.inventoryItems == null) {
            this.inventoryItems = HashMultiset.create();
        }
        ItemContainer inventory = itemContainerChanged.getItemContainer();
        HashMultiset currentInventoryItems = HashMultiset.create();
        Arrays.stream(inventory.getItems()).forEach(arg_0 -> CollectionLogPlugin.lambda$onItemContainerChanged$5((Multiset)currentInventoryItems, arg_0));
        Multiset invDiff = Multisets.difference((Multiset)currentInventoryItems, this.inventoryItems);
        ItemStack obtainedItemStack = null;
        for (Multiset.Entry item : invDiff.entrySet()) {
            ItemComposition itemComp = this.itemManager.getItemComposition(((Integer)item.getElement()).intValue());
            if (!itemComp.getName().equals(this.obtainedItemName)) continue;
            obtainedItemStack = new ItemStack(((Integer)item.getElement()).intValue(), item.getCount(), this.client.getLocalPlayer().getLocalLocation());
            break;
        }
        if (obtainedItemStack == null) {
            if (this.client.getWidget(WidgetInfo.CLUE_SCROLL_REWARD_ITEM_CONTAINER) != null) {
                return;
            }
            this.obtainedItemName = null;
            this.inventoryItems = HashMultiset.create();
            return;
        }
        this.updateObtainedItem(obtainedItemStack);
    }

    public void saveCollectionLogData() {
        if (!this.collectionLogManager.isInitialized()) {
            this.collectionLogPanel.setStatus("Unable to save collection log, please open the collection log in game and try again.", true, true);
            return;
        }
        if (!this.isValidWorldType()) {
            this.collectionLogPanel.setStatus("Unable to save collection log, please log in to a normal free to play or members world and try again", true, true);
            return;
        }
        if (this.isCollectionLogDeleted) {
            return;
        }
        boolean isSaved = this.collectionLogManager.saveCollectionLogFile(false);
        isSaved = isSaved && this.collectionLogManager.saveUserSettingsFile();
        String statusMessage = isSaved ? null : "Unable to save collection log data. Check Runelite logs for full error.";
        this.collectionLogPanel.setStatus(statusMessage, isSaved, !this.config.allowApiConnections());
        if (!this.config.allowApiConnections() || !isSaved) {
            return;
        }
        if (this.client.getAccountHash() == -1L) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        String username = localPlayer.getName();
        String accountHash = String.valueOf(this.client.getAccountHash());
        String accountType = this.client.getAccountType().toString();
        boolean isFemale = localPlayer.getPlayerComposition().getGender() == 1;
        JsonObject collectionLogJson = this.collectionLogManager.getCollectionLogJsonObject();
        JsonObject userSettingsJson = this.collectionLogManager.getUserSettingsJsonObject();
        this.uploadCollectionLog(username, accountType, accountHash, isFemale, userSettingsJson, collectionLogJson);
    }

    private void updatePage(Widget pageHead, CollectionLogPage pageToUpdate) {
        Widget[] killCountWidgets;
        Widget[] widgetItems;
        Widget itemsContainer = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_ITEMS);
        if (itemsContainer == null) {
            return;
        }
        List<CollectionLogItem> items = pageToUpdate.getItems();
        items.clear();
        for (Widget widgetItem : widgetItems = itemsContainer.getDynamicChildren()) {
            String itemName = this.itemManager.getItemComposition(widgetItem.getItemId()).getMembersName();
            boolean isObtained = widgetItem.getOpacity() == 0;
            int quantity = isObtained ? widgetItem.getItemQuantity() : 0;
            items.add(new CollectionLogItem(widgetItem.getItemId(), itemName, quantity, isObtained, items.size()));
            if (!this.config.showQuantityForAllObtainedItems() || quantity <= 0) continue;
            widgetItem.setItemQuantityMode(1);
        }
        Widget[] children = pageHead.getDynamicChildren();
        if (children.length < 3) {
            pageToUpdate.setUpdated(true);
            return;
        }
        List<CollectionLogKillCount> killCounts = pageToUpdate.getKillCounts();
        killCounts.clear();
        for (Widget killCountWidget : killCountWidgets = Arrays.copyOfRange(children, 2, children.length)) {
            String killCountString = killCountWidget.getText();
            CollectionLogKillCount killCount = CollectionLogKillCount.fromString(killCountString, killCounts.size());
            killCounts.add(killCount);
        }
        pageToUpdate.setUpdated(true);
    }

    private void getPage() {
        boolean openedFromAdventureLog;
        if (!this.isValidWorldType()) {
            return;
        }
        boolean bl = openedFromAdventureLog = this.client.getVarbitValue(12061) != 0;
        if (openedFromAdventureLog && !this.isPohOwner) {
            return;
        }
        Widget activeTab = this.getActiveTab();
        if (activeTab == null) {
            return;
        }
        String activeTabName = Text.removeTags((String)activeTab.getName());
        CollectionLogTab collectionLogTab = this.collectionLogManager.getTabByName(activeTabName);
        if (collectionLogTab == null) {
            return;
        }
        Widget pageHead = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_HEADER);
        if (pageHead == null) {
            return;
        }
        String pageTitle = pageHead.getDynamicChildren()[0].getText();
        if (!collectionLogTab.containsPage(pageTitle)) {
            return;
        }
        CollectionLogPage pageToUpdate = this.collectionLogManager.getPageByName(pageTitle);
        if (pageToUpdate == null) {
            return;
        }
        int prevObtainedItemCount = pageToUpdate.getObtainedItemCount();
        this.updatePage(pageHead, pageToUpdate);
        int newObtainedItemCount = pageToUpdate.getObtainedItemCount();
        if (this.collectionLogManager.getTabByName(activeTabName) != null && prevObtainedItemCount > newObtainedItemCount) {
            return;
        }
        if (prevObtainedItemCount == newObtainedItemCount) {
            this.update();
            return;
        }
        CollectionLog collectionLog = this.collectionLogManager.getCollectionLog();
        int prevTotalObtained = collectionLog.getTotalObtained();
        int newTotalObtained = prevTotalObtained + (newObtainedItemCount - prevObtainedItemCount);
        collectionLog.setTotalObtained(newTotalObtained);
        this.update();
    }

    private void highlightPages() {
        Widget[] pageNameWidgets;
        Widget pageList = this.getActivePageList();
        if (pageList == null) {
            return;
        }
        for (Widget pageNameWidget : pageNameWidgets = pageList.getDynamicChildren()) {
            String pageName = pageNameWidget.getText().replace(" *", "");
            CollectionLogPage collectionLogPage = this.collectionLogManager.getPageByName(pageName);
            if (!collectionLogPage.isUpdated()) {
                pageNameWidget.setText(pageName + " *");
            }
            Color pageNameColor = this.getPageNameColor(collectionLogPage, pageNameWidget);
            pageNameWidget.setTextColor(pageNameColor.getRGB());
        }
    }

    private Widget getActiveTab() {
        Widget tabsWidget = this.client.getWidget(WidgetInfo.COLLECTION_LOG_TABS);
        if (tabsWidget == null) {
            return null;
        }
        int tabIndex = this.client.getVarbitValue(6905);
        return tabsWidget.getStaticChildren()[tabIndex];
    }

    private Widget getActivePageList() {
        Widget tab = this.getActiveTab();
        if (tab == null) {
            return null;
        }
        String tabName = Text.removeTags((String)tab.getName());
        int listIndex = CollectionLogList.valueOf(tabName.toUpperCase()).getListIndex();
        return this.client.getWidget(621, listIndex);
    }

    private Color getPageNameColor(CollectionLogPage collectionLogPage, Widget pageNameWidget) {
        Color pageNameColor = CollectionLogConfig.DEFAULT_ORANGE;
        int obtainedItemCount = collectionLogPage.getObtainedItemCount();
        if (obtainedItemCount == 0 && this.config.highlightIncompletePages()) {
            pageNameColor = this.config.emptyHighlightColor();
        }
        if (obtainedItemCount > 0 && obtainedItemCount < collectionLogPage.getItems().size() && this.config.highlightIncompletePages()) {
            pageNameColor = this.config.inProgressHighlightColor();
        }
        if (pageNameWidget.getTextColor() == 901389) {
            pageNameColor = this.config.highlightColor();
        }
        return pageNameColor;
    }

    private String buildTitle() {
        String prefix;
        StringBuilder titleBuilder = new StringBuilder(COLLECTION_LOG_TITLE);
        ArrayList<String> titleSections = new ArrayList<String>();
        boolean displayUnique = this.config.displayUniqueItems();
        boolean displayTotal = this.config.displayTotalItems();
        if (!this.collectionLogManager.isInitialized()) {
            return "";
        }
        CollectionLog collectionLog = this.collectionLogManager.getCollectionLog();
        if (displayUnique) {
            int uniqueObtained = collectionLog.getUniqueObtained();
            int uniqueTotal = collectionLog.getUniqueItems();
            prefix = displayTotal ? "U: " : "";
            String uniqueTitle = String.format("%s%d/%d", prefix, uniqueObtained, uniqueTotal);
            if (this.config.displayAsPercentage()) {
                uniqueTitle = String.format("%s%.2f%%", prefix, (double)uniqueObtained / (double)uniqueTotal * 100.0);
            }
            titleSections.add(uniqueTitle);
        }
        if (this.config.displayTotalItems()) {
            int totalItemsObtained = collectionLog.getTotalObtained();
            int totalItems = collectionLog.getTotalItems();
            prefix = displayUnique ? "T: " : "";
            String totalTitle = String.format("%s%d/%d", prefix, totalItemsObtained, totalItems);
            if (this.config.displayAsPercentage()) {
                totalTitle = String.format("%s%.2f%%", prefix, (double)totalItemsObtained / (double)totalItems * 100.0);
            }
            titleSections.add(totalTitle);
        }
        if (titleSections.size() > 0) {
            titleBuilder.append(" - ");
        }
        titleBuilder.append(String.join((CharSequence)" ", titleSections));
        return titleBuilder.toString();
    }

    private void update() {
        this.collectionLogManager.updateTotalItems();
        this.setCollectionLogTitle();
        this.highlightPages();
    }

    private void setCollectionLogTitle() {
        String title = this.buildTitle();
        this.setCollectionLogTitle(title);
    }

    private void setCollectionLogTitle(String title) {
        Widget collectionLogTitleWidget = this.getCollectionLogTitle();
        if (collectionLogTitleWidget == null) {
            return;
        }
        collectionLogTitleWidget.setText(title);
    }

    private boolean isValidWorldType() {
        ImmutableList invalidTypes = ImmutableList.of((Object)WorldType.DEADMAN, (Object)WorldType.NOSAVE_MODE, (Object)WorldType.SEASONAL, (Object)WorldType.TOURNAMENT_WORLD);
        for (WorldType worldType : invalidTypes) {
            if (!this.client.getWorldType().contains(worldType)) continue;
            return false;
        }
        return true;
    }

    private void collectionLogLookup(final ChatMessage chatMessage, final String message) {
        Player localPlayer = this.client.getLocalPlayer();
        String username = chatMessage.getName();
        if (chatMessage.getType().equals((Object)ChatMessageType.PRIVATECHATOUT)) {
            username = localPlayer.getName();
        }
        try {
            this.apiClient.getCollectionLog(Text.sanitize((String)username), new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    if (call == null) {
                        throw new NullPointerException("call is marked non-null but is null");
                    }
                    if (e == null) {
                        throw new NullPointerException("e is marked non-null but is null");
                    }
                    log.error("Unable to resolve !log command: " + e.getMessage());
                    CollectionLogPlugin.this.clientThread.invoke(() -> CollectionLogPlugin.this.replaceCommandMessage(chatMessage, message, null));
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                    if (call == null) {
                        throw new NullPointerException("call is marked non-null but is null");
                    }
                    if (response == null) {
                        throw new NullPointerException("response is marked non-null but is null");
                    }
                    JsonObject collectionLogJson = CollectionLogPlugin.this.apiClient.processResponse(response);
                    response.close();
                    if (collectionLogJson == null) {
                        CollectionLogPlugin.this.clientThread.invoke(() -> CollectionLogPlugin.this.replaceCommandMessage(chatMessage, message, null));
                        return;
                    }
                    CollectionLog collectionLog = CollectionLogPlugin.this.jsonUtils.fromJsonObject(collectionLogJson.getAsJsonObject("collectionLog"), CollectionLog.class, new CollectionLogDeserializer());
                    CollectionLogPlugin.this.clientThread.invoke(() -> CollectionLogPlugin.this.replaceCommandMessage(chatMessage, message, collectionLog));
                }
            });
        }
        catch (IOException e) {
            log.error("Unable to resolve !log command: " + e.getMessage());
        }
    }

    private void replaceCommandMessage(ChatMessage chatMessage, String message, CollectionLog collectionLog) {
        Object replacementMessage;
        Matcher commandMatcher = COLLECTION_LOG_COMMAND_PATTERN.matcher(message);
        if (!commandMatcher.matches()) {
            return;
        }
        String commandFilter = commandMatcher.group(1);
        String commandPage = commandMatcher.group(2);
        if (collectionLog == null) {
            replacementMessage = "No Collection Log data found for user.";
        } else if (commandPage == null) {
            replacementMessage = "Collection Log: " + collectionLog.getUniqueObtained() + "/" + collectionLog.getUniqueItems();
        } else {
            String pageArgument = CollectionLogPage.aliasPageName(commandPage);
            CollectionLogPage collectionLogPage = pageArgument.equals("any") ? collectionLog.randomPage() : collectionLog.searchForPage(pageArgument);
            if (collectionLogPage == null) {
                replacementMessage = "No Collection Log page found.";
            } else {
                this.loadPageIcons(collectionLogPage.getItems());
                replacementMessage = this.buildMessageReplacement(collectionLogPage, commandFilter);
            }
        }
        chatMessage.getMessageNode().setValue((String)replacementMessage);
        this.client.runScript(new Object[]{216});
    }

    private void loadPageIcons(List<CollectionLogItem> collectionLogItems) {
        List itemsToLoad = collectionLogItems.stream().filter(item -> !this.loadedCollectionLogIcons.containsKey(item.getId())).collect(Collectors.toList());
        IndexedSprite[] modIcons = this.client.getModIcons();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + itemsToLoad.size());
        int modIconIdx = modIcons.length;
        for (int i = 0; i < itemsToLoad.size(); ++i) {
            CollectionLogItem item2 = (CollectionLogItem)itemsToLoad.get(i);
            ItemComposition itemComposition = this.itemManager.getItemComposition(item2.getId());
            BufferedImage image = ImageUtil.resizeImage((BufferedImage)this.itemManager.getImage(itemComposition.getId()), (int)18, (int)16);
            IndexedSprite sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
            int spriteIndex = modIconIdx + i;
            newModIcons[spriteIndex] = sprite;
            this.loadedCollectionLogIcons.put(item2.getId(), spriteIndex);
        }
        this.client.setModIcons(newModIcons);
    }

    private String buildMessageReplacement(CollectionLogPage collectionLogPage, String commandFilter) {
        if (commandFilter == null) {
            commandFilter = "obtained";
        }
        List<CollectionLogItem> items = collectionLogPage.applyItemFilter(commandFilter.toLowerCase());
        StringBuilder itemBuilder = new StringBuilder();
        for (CollectionLogItem item : items) {
            String itemString = "<img=" + this.loadedCollectionLogIcons.get(item.getId()) + ">";
            if (item.getQuantity() > 1) {
                itemString = itemString + "x" + item.getQuantity();
            }
            itemString = itemString + "  ";
            itemBuilder.append(itemString);
        }
        String replacementMessage = collectionLogPage.getName() + " (" + commandFilter + "): " + items.size() + "/" + collectionLogPage.getItems().size() + " ";
        replacementMessage = replacementMessage + itemBuilder.toString();
        return replacementMessage;
    }

    private Widget getCollectionLogTitle() {
        Widget collLogContainer = this.client.getWidget(621, 1);
        if (collLogContainer == null) {
            return null;
        }
        return collLogContainer.getDynamicChildren()[1];
    }

    private void updateObtainedItem(ItemStack itemStack) {
        boolean itemUpdated = this.collectionLogManager.updateObtainedItem(itemStack);
        if (!itemUpdated) {
            this.collectionLogPanel.setStatus("Unable to update data for item \"" + this.obtainedItemName + "\". Open the collection log page(s)it exists in to update.", true, true);
        }
        this.obtainedItemName = null;
        this.inventoryItems = HashMultiset.create();
    }

    public void deleteCollectionLog() {
        String username = this.client.getLocalPlayer().getName();
        String accountHash = String.valueOf(this.client.getAccountHash());
        this.apiClient.deleteCollectionLog(username, accountHash, new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                log.error("Unable to delete collectionlog.net profile: " + e.getMessage());
                CollectionLogPlugin.this.collectionLogPanel.setStatus("Error deleting collectionlog.net profile. Check Runelite logs for full error.", true, true);
                CollectionLogPlugin.this.isCollectionLogDeleted = false;
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                response.close();
                CollectionLogPlugin.this.collectionLogPanel.setStatus("collectionlog.net profile successfully deleted.", false, true);
                CollectionLogPlugin.this.isCollectionLogDeleted = true;
            }
        });
    }

    private void unsetOldConfigs() {
        this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP, "completed_categories");
        this.configManager.unsetConfiguration(CONFIG_GROUP, "highlight_completed");
        this.configManager.unsetConfiguration(CONFIG_GROUP, "new_item_chat_message");
        this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP, "obtained_counts");
        this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP, "obtained_items");
        this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP, "kill_counts");
        this.configManager.unsetConfiguration(CONFIG_GROUP, "total_items");
    }

    private void resetFlags() {
        this.isUserLoggedIn = false;
        this.isCollectionLogDeleted = false;
        this.userSettingsLoaded = false;
    }

    private void uploadCollectionLog(String username, String accountType, String accountHash, boolean isFemale, JsonObject userSettings, JsonObject collectionLog) {
        this.apiClient.updateUser(username, accountType, accountHash, isFemale, userSettings, this.uploadCollectionLogCallback(() -> this.apiClient.updateCollectionLog(collectionLog, accountHash, this.uploadCollectionLogCallback(null))));
    }

    private Callback uploadCollectionLogCallback(final Runnable onSuccess) {
        final String errorDisplay = "Error uploading data to collectionlog.net. Check Runelite logs for full error.";
        final String errorLog = "Unable to upload data to collectionlog.net: ";
        return new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                log.error(errorLog + e.getMessage());
                CollectionLogPlugin.this.collectionLogPanel.setStatus(errorDisplay, true, true);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                response.close();
                CollectionLogPlugin.this.collectionLogPanel.setStatus("Collection log successfully uploaded to collectionlog.net", false, true);
                if (onSuccess != null) {
                    onSuccess.run();
                }
            }
        };
    }

    public void setCollectionLogDeleted(boolean isCollectionLogDeleted) {
        this.isCollectionLogDeleted = isCollectionLogDeleted;
    }

    public Client getClient() {
        return this.client;
    }

    private static /* synthetic */ void lambda$onItemContainerChanged$5(Multiset currentInventoryItems, Item item) {
        currentInventoryItems.add((Object)item.getId(), item.getQuantity());
    }
}

