/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog;

import com.evansloan.collectionlog.CollectionLogConfig;
import com.evansloan.collectionlog.CollectionLogItem;
import com.evansloan.collectionlog.CollectionLogManager;
import com.evansloan.collectionlog.CollectionLogPlugin;
import com.evansloan.collectionlog.DisplayRankType;
import com.evansloan.collectionlog.UserSettings;
import com.evansloan.collectionlog.ui.ExpandablePanel;
import com.evansloan.collectionlog.ui.GameStatePanel;
import com.evansloan.collectionlog.ui.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionLogPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogPanel.class);
    private static final ImageIcon ACCOUNT_ICON;
    private static final ImageIcon DISCORD_ICON;
    private static final ImageIcon GITHUB_ICON;
    private static final ImageIcon HELP_ICON;
    private static final ImageIcon RANDOM_ICON;
    private static final ImageIcon INFO_ICON;
    private static final ImageIcon WEBSITE_ICON;
    private static final EmptyBorder DEFAULT_BORDER;
    private static GameState currentGameState;
    private final CollectionLogPlugin collectionLogPlugin;
    private final CollectionLogManager collectionLogManager;
    private final ClientThread clientThread;
    private final CollectionLogConfig config;
    private final ItemManager itemManager;
    private GameStatePanel accountPanel;
    private JLabel clnEnabledLabel;
    private JButton uploadCollectionLogBtn;
    private JButton deleteCollectionLogBtn;
    private JTextArea statusTextArea;
    private JPanel accountSettingsPanel;
    private JComboBox<DisplayRankType> displayRankComboBox;
    private JCheckBox showQuantityCheck;
    private JButton randomCollectionLogBtn;
    private JLabel randomItemSprite;
    private JLabel randomItemLabel;

    public CollectionLogPanel(CollectionLogPlugin collectionLogPlugin, CollectionLogManager collectionLogManager, ClientThread clientThread, CollectionLogConfig config, ItemManager itemManager) {
        super(false);
        this.collectionLogPlugin = collectionLogPlugin;
        this.collectionLogManager = collectionLogManager;
        this.clientThread = clientThread;
        this.config = config;
        this.itemManager = itemManager;
    }

    public void create(GameState gameState) {
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.setBorder(DEFAULT_BORDER);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        JPanel titlePanel = this.createTitlePanel();
        JPanel tabPanel = this.createTabPanel(gameState);
        layoutPanel.add(titlePanel);
        layoutPanel.add(tabPanel);
        this.add(layoutPanel, "North");
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Collection Log");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        JPanel infoButtons = new JPanel(new GridLayout(1, 3, 10, 0));
        infoButtons.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JButton websiteBtn = this.createTitleButton(WEBSITE_ICON, "Open collectionlog.net", "https://collectionlog.net");
        infoButtons.add(websiteBtn);
        JButton discordBtn = this.createTitleButton(DISCORD_ICON, "Join the Log Hunters Discord Server", "https://discord.gg/loghunters");
        infoButtons.add(discordBtn);
        JButton githubBtn = this.createTitleButton(GITHUB_ICON, "View the Collection Log plugin source code on GitHub", "https://github.com/evansloan/collection-log");
        infoButtons.add(githubBtn);
        titlePanel.add((Component)infoButtons, "East");
        JPanel titleContainer = new JPanel();
        titleContainer.setLayout(new BorderLayout());
        titleContainer.add((Component)titlePanel, "North");
        return titleContainer;
    }

    private JPanel createTabPanel(GameState gameState) {
        boolean isLoggedIn = gameState == GameState.LOGGED_IN;
        JPanel tabPanel = new JPanel();
        tabPanel.setLayout(new BoxLayout(tabPanel, 1));
        JPanel activeTabPanel = new JPanel();
        activeTabPanel.setLayout(new BoxLayout(activeTabPanel, 1));
        MaterialTabGroup tabGroup = new MaterialTabGroup(activeTabPanel);
        tabGroup.setLayout((LayoutManager)new GridLayout(1, 4, 10, 10));
        tabGroup.setBorder((Border)new EmptyBorder(0, 0, 10, 0));
        tabPanel.add((Component)tabGroup);
        tabPanel.add(activeTabPanel);
        JPanel infoPanel = this.createInfoPanel();
        activeTabPanel.add(infoPanel);
        this.createTab(INFO_ICON, "Info", tabGroup, infoPanel).select();
        this.accountPanel = this.createAccountPanel(isLoggedIn);
        this.createTab(ACCOUNT_ICON, "Account", tabGroup, this.accountPanel);
        JPanel randomPanel = this.createRandomPanel();
        this.createTab(RANDOM_ICON, "Random", tabGroup, randomPanel);
        JPanel helpPanel = this.createHelpPanel();
        this.createTab(HELP_ICON, "Help", tabGroup, helpPanel);
        return tabPanel;
    }

    private JPanel createInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        JPanel pluginInfoPanel = new JPanel(new GridLayout(0, 1));
        pluginInfoPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        pluginInfoPanel.setBorder(DEFAULT_BORDER);
        infoPanel.add(pluginInfoPanel);
        JLabel versionLabel = this.createKeyValueLabel("Version: ", "3.1.0");
        this.clnEnabledLabel = this.createKeyValueLabel("collectionlog.net uploads: ", this.config.allowApiConnections() ? "Enabled" : "Disabled");
        pluginInfoPanel.add(versionLabel);
        pluginInfoPanel.add(this.clnEnabledLabel);
        JPanel changeLogContent = this.createTabContentPanel();
        String changeLogText = "v3.1.0\n\n* Added random collection log item button in sidebar\n* Fixed inconsistent page name highlighting";
        JTextArea changeLogTextArea = this.createTextArea(changeLogText);
        changeLogContent.add(changeLogTextArea);
        ExpandablePanel changeLogPanel = new ExpandablePanel("What's new", changeLogContent);
        infoPanel.add(changeLogPanel);
        JPanel quickStartContent = this.createTabContentPanel();
        String quickStartText = "The collection log plugin allows you to sync your in-game collection log data with collectionlog.net.\n\nTo get started, first enable the collectionlog.net connections plugin config.\n\nAfter enabling the config, open your collection log and click through each page in the log in order for the plugin to grab your collection log data. Pages that haven't been loaded into the plugin will be marked with * in your collection log.\n\nOnce all the collection log pages have been clicked through, your data can be uploaded by clicking on the upload button in the account tab in the plugin side panel. Your data will also be uploaded automatically upon log out.";
        JTextArea quickStartTextArea = this.createTextArea(quickStartText);
        quickStartContent.add(quickStartTextArea);
        ExpandablePanel quickStartPanel = new ExpandablePanel("Quick start", quickStartContent, true);
        infoPanel.add(quickStartPanel);
        return infoPanel;
    }

    private GameStatePanel createAccountPanel(boolean isLoggedIn) {
        GameStatePanel gameStatePanel = new GameStatePanel();
        gameStatePanel.setLayout(new BoxLayout(gameStatePanel, 1));
        JLabel accountLoggedOutLabel = new JLabel("Log in to manage your account");
        accountLoggedOutLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        gameStatePanel.setLoggedOutContent(accountLoggedOutLabel);
        JPanel accountLoggedInPanel = new JPanel();
        accountLoggedInPanel.setLayout(new BorderLayout());
        gameStatePanel.setLoggedInContent(accountLoggedInPanel);
        this.statusTextArea = this.createTextArea("");
        accountLoggedInPanel.add((Component)this.statusTextArea, "North");
        JPanel accountButtonPanel = this.createAccountButtonPanel();
        accountLoggedInPanel.add((Component)accountButtonPanel, "Center");
        this.accountSettingsPanel = this.createAccountSettingsPanel();
        this.accountSettingsPanel.setVisible(this.config.allowApiConnections());
        accountLoggedInPanel.add((Component)this.accountSettingsPanel, "South");
        gameStatePanel.updateContent(isLoggedIn);
        return gameStatePanel;
    }

    private JPanel createAccountSettingsPanel() {
        JPanel settingsPanel = new JPanel(new BorderLayout());
        settingsPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        JLabel settingsLabel = this.createTitleLabel("Account settings");
        settingsPanel.add((Component)settingsLabel, "North");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        JPanel showQuantityPanel = new JPanel(new BorderLayout());
        showQuantityPanel.setMinimumSize(new Dimension(225, 0));
        JLabel showQuantityLabel = new JLabel("Show item quantities");
        showQuantityLabel.setForeground(Color.WHITE);
        showQuantityLabel.setToolTipText("Toggle the display of item quantities on collectionlog.net");
        showQuantityPanel.add((Component)showQuantityLabel, "Center");
        this.showQuantityCheck = this.createCheckBox(event -> this.collectionLogManager.getUserSettings().setShowQuantity(event.getStateChange() == 1));
        showQuantityPanel.add((Component)this.showQuantityCheck, "East");
        controlPanel.add(showQuantityPanel);
        JPanel displayRankPanel = new JPanel(new BorderLayout());
        displayRankPanel.setMinimumSize(new Dimension(225, 0));
        JLabel displayRankLabel = new JLabel("Display rank");
        displayRankLabel.setForeground(Color.WHITE);
        displayRankLabel.setToolTipText("Rank type to display on collectionlog.net profile");
        displayRankPanel.add((Component)displayRankLabel, "Center");
        this.displayRankComboBox = this.createComboBox(DisplayRankType.values(), event -> this.collectionLogManager.getUserSettings().setDisplayRank((DisplayRankType)((Object)((Object)event.getItem()))));
        displayRankPanel.add(this.displayRankComboBox, "East");
        controlPanel.add(displayRankPanel);
        settingsPanel.add((Component)controlPanel, "Center");
        return settingsPanel;
    }

    private JPanel createAccountButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1));
        buttonPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        JLabel titleLabel = this.createTitleLabel("Account management");
        buttonPanel.add(titleLabel);
        this.uploadCollectionLogBtn = this.createButton("Upload collection log", event -> {
            this.collectionLogPlugin.setCollectionLogDeleted(false);
            this.setStatus("Uploading collection log to collectionlog.net...", false, false);
            this.clientThread.invokeLater(this.collectionLogPlugin::saveCollectionLogData);
        });
        this.uploadCollectionLogBtn.setVisible(this.config.allowApiConnections());
        buttonPanel.add(this.uploadCollectionLogBtn);
        JButton clearCollectionLogBtn = this.createButton("Reset collection log data", event -> this.collectionLogManager.deleteSaveFile());
        buttonPanel.add(clearCollectionLogBtn);
        this.deleteCollectionLogBtn = this.createButton("Delete collection log", event -> {
            int confirm = JOptionPane.showOptionDialog(this.deleteCollectionLogBtn, "Are you sure you want to delete your collection log from collectionlog.net?\nMake sure to disable \"Allow collectionlog.net connections\" config to prevent future uploads.", "Delete collection log?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (confirm == 0) {
                this.setStatus("Deleting collection log from collectionlog.net...", false, false);
                this.clientThread.invokeLater(this.collectionLogPlugin::deleteCollectionLog);
            }
        });
        this.deleteCollectionLogBtn.setBackground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.deleteCollectionLogBtn.setVisible(this.config.allowApiConnections());
        buttonPanel.add(this.deleteCollectionLogBtn);
        return buttonPanel;
    }

    private JPanel createHelpPanel() {
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new BoxLayout(helpPanel, 1));
        JPanel notUploadingContent = this.createTabContentPanel();
        String notUploadingText = "If your collection log is not appearing on collectionlog.net, follow these steps:\n\n1. Make sure the \"Allow collectionlog.net connections\" config is enabled.\n\n2. Click through every page in the collection log to gather your obtained item data.\n\n3. Click the \"Upload collection log\" button in the account tab or log out to upload your collection log.\n\n4. If the above steps do not solve your problem, click the \"Reset collection log\" button in the accounts tab and try the above steps again.";
        JTextArea notUploadingTextArea = this.createTextArea(notUploadingText);
        notUploadingContent.add(notUploadingTextArea);
        ExpandablePanel notUploadingPanel = new ExpandablePanel("Collection log not uploading?", notUploadingContent);
        helpPanel.add(notUploadingPanel);
        JPanel missingItemsContent = this.createTabContentPanel();
        String missingItemsText = "1. Click through any page in the collection log you may have received a new item in.\n\n2. Click the \"Upload collection log\" button in the account tab or log out to upload your collection log.";
        JTextArea missingItemsTextArea = this.createTextArea(missingItemsText);
        missingItemsContent.add(missingItemsTextArea);
        ExpandablePanel missingItemsPanel = new ExpandablePanel("Missing obtained items?", missingItemsContent);
        helpPanel.add(missingItemsPanel);
        JPanel duplicateItemsContent = this.createTabContentPanel();
        String duplicateItemsText = "If your collectionlog.net collection log page is showing dupliate items/kill counts, join the Log Hunters Discord server by clicking on the Discord icon above and reporting a bug in the bugs-and-support forum with the \"Plug-in\" tag";
        JTextArea duplicateItemsTextArea = this.createTextArea(duplicateItemsText);
        duplicateItemsContent.add(duplicateItemsTextArea);
        ExpandablePanel duplicateItemsPanel = new ExpandablePanel("Duplicate items?", duplicateItemsContent);
        helpPanel.add(duplicateItemsPanel);
        JPanel suggestionContent = this.createTabContentPanel();
        String suggestionText = "If you have a suggestion for the collection log plugin or collectionlog.net, feel free to post it in the Log Hunters Discord server in the suggestions forum";
        JTextArea suggestionTextArea = this.createTextArea(suggestionText);
        suggestionContent.add(suggestionTextArea);
        ExpandablePanel suggestionPanel = new ExpandablePanel("Have a suggestion?", suggestionContent);
        helpPanel.add(suggestionPanel);
        return helpPanel;
    }

    private JPanel createRandomPanel() {
        JPanel randomPanel = new JPanel();
        randomPanel.setLayout(new BoxLayout(randomPanel, 1));
        JPanel childPanel = this.createChildRandomPanel();
        randomPanel.add(childPanel);
        return randomPanel;
    }

    private JPanel createChildRandomPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1));
        buttonPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        JLabel titleLabel = this.createTitleLabel("Random Collection Log Item Picker");
        titleLabel.setVerticalAlignment(0);
        titleLabel.setHorizontalAlignment(0);
        buttonPanel.add(titleLabel);
        this.randomCollectionLogBtn = this.createButton("Roll New Item", event -> this.clientThread.invokeLater(() -> {
            CollectionLogItem item = this.collectionLogManager.getRandomItem();
            if (item == null) {
                this.randomItemLabel.setText("Open Collection Log first");
                return;
            }
            AsyncBufferedImage itemImage = this.itemManager.getImage(item.getId(), 1, false);
            itemImage.addTo(this.randomItemSprite);
            this.randomItemLabel.setText(item.getName());
        }));
        buttonPanel.add(this.randomCollectionLogBtn);
        this.randomItemSprite = new JLabel();
        this.randomItemSprite.setVerticalAlignment(0);
        this.randomItemSprite.setHorizontalAlignment(0);
        this.randomItemSprite.setMinimumSize(new Dimension(36, 36));
        this.randomItemSprite.setPreferredSize(new Dimension(36, 36));
        this.randomItemSprite.setBorder(new LineBorder(Color.BLACK, 1));
        buttonPanel.add(this.randomItemSprite);
        this.randomItemLabel = this.createTitleLabel("");
        this.randomItemLabel.setVerticalAlignment(0);
        this.randomItemLabel.setHorizontalAlignment(0);
        buttonPanel.add(this.randomItemLabel);
        return buttonPanel;
    }

    private JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(0, 22);
        textArea.setText(text);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setOpaque(false);
        return textArea;
    }

    private JButton createTitleButton(ImageIcon icon, String toolTip, String url) {
        final JButton btn = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)btn);
        btn.setIcon(icon);
        btn.setToolTipText(toolTip);
        btn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        btn.setUI(new BasicButtonUI());
        btn.addActionListener(event -> LinkBrowser.browse((String)url));
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                btn.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                btn.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        return btn;
    }

    private JButton createButton(String text, ActionListener actionListener) {
        JButton btn = new JButton();
        btn.setBorder(new EmptyBorder(15, 0, 15, 0));
        btn.setText(text);
        btn.setForeground(Color.WHITE);
        btn.setPreferredSize(new Dimension(220, 30));
        btn.addActionListener(actionListener);
        btn.setFocusable(false);
        return btn;
    }

    private MaterialTab createTab(ImageIcon icon, String toolTipText, MaterialTabGroup tabGroup, JComponent content) {
        MaterialTab tab = new MaterialTab(icon, tabGroup, content);
        tab.setToolTipText(toolTipText);
        tabGroup.addTab(tab);
        return tab;
    }

    private JPanel createTabContentPanel() {
        JPanel tabContentPanel = new JPanel(new GridLayout(0, 1));
        tabContentPanel.setBorder(DEFAULT_BORDER);
        tabContentPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        return tabContentPanel;
    }

    private String htmlText(String text) {
        return "<html><body style='color:#A5A5A5'>" + text + "</body></html>";
    }

    private String getKeyValueText(String key, String value) {
        return this.htmlText(key + "<span style='color:white'>" + value + "</span>");
    }

    private JLabel createKeyValueLabel(String key, String value) {
        return new JLabel(this.getKeyValueText(key, value));
    }

    private JLabel createTitleLabel(String text) {
        JLabel titleLabel = new JLabel(text);
        titleLabel.setBorder(new EmptyBorder(10, 0, 10, 0));
        titleLabel.setFont(FontManager.getRunescapeBoldFont());
        titleLabel.setForeground(Color.WHITE);
        return titleLabel;
    }

    private JCheckBox createCheckBox(ItemListener itemListener) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
        checkBox.addItemListener(itemListener);
        checkBox.setSelected(true);
        return checkBox;
    }

    private <T extends Enum<T>> JComboBox<T> createComboBox(T[] items, ItemListener itemListener) {
        JComboBox<T> comboBox = new JComboBox<T>(items);
        comboBox.setRenderer((ListCellRenderer<T>)new ComboBoxListRenderer());
        comboBox.setForeground(Color.WHITE);
        comboBox.setFocusable(false);
        comboBox.addItemListener(itemListener);
        return comboBox;
    }

    public void setUserSettings(UserSettings userSettings) {
        this.displayRankComboBox.setSelectedItem((Object)userSettings.getDisplayRank());
        this.showQuantityCheck.setSelected(userSettings.isShowQuantity());
    }

    public void setStatus(String message, boolean isError, boolean enableBtn) {
        Color textColor = Color.WHITE;
        if (isError) {
            textColor = ColorScheme.PROGRESS_ERROR_COLOR;
        }
        if (message != null) {
            this.statusTextArea.setText(message);
            this.statusTextArea.setForeground(textColor);
        }
        this.uploadCollectionLogBtn.setEnabled(enableBtn);
        this.deleteCollectionLogBtn.setEnabled(enableBtn);
    }

    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getKey().equals("upload_collection_log")) {
            this.clnEnabledLabel.setText(this.getKeyValueText("collectionlog.net uploads: ", this.config.allowApiConnections() ? "Enabled" : "Disabled"));
            this.uploadCollectionLogBtn.setVisible(this.config.allowApiConnections());
            this.deleteCollectionLogBtn.setVisible(this.config.allowApiConnections());
            this.accountSettingsPanel.setVisible(this.config.allowApiConnections());
            this.accountPanel.revalidate();
            this.accountPanel.repaint();
        }
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        boolean isNewGameState;
        GameState gameState = gameStateChanged.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOGIN_SCREEN) {
            return;
        }
        boolean bl = isNewGameState = gameState != currentGameState;
        if (!isNewGameState) {
            return;
        }
        currentGameState = gameState;
        GameStatePanel.updatePanels(gameState);
        if (gameState == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(() -> {
                Client client = this.collectionLogPlugin.getClient();
                EnumSet<DisplayRankType> displayRankTypes = DisplayRankType.getRankTypesFromAccountType(client.getAccountType());
                this.displayRankComboBox.removeAllItems();
                for (DisplayRankType displayRankType : displayRankTypes) {
                    this.displayRankComboBox.addItem(displayRankType);
                }
            });
        }
    }

    static {
        DEFAULT_BORDER = new EmptyBorder(10, 10, 10, 10);
        ACCOUNT_ICON = Icon.ACCOUNT.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
        DISCORD_ICON = Icon.DISCORD.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
        GITHUB_ICON = Icon.GITHUB.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
        HELP_ICON = Icon.HELP.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)20, (int)20));
        RANDOM_ICON = Icon.RANDOM.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)20, (int)20));
        INFO_ICON = Icon.INFO.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)20, (int)20));
        WEBSITE_ICON = Icon.COLLECTION_LOG.getIcon(img -> ImageUtil.resizeImage((BufferedImage)img, (int)16, (int)16));
    }
}

