/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog;

import com.evansloan.collectionlog.CollectionLog;
import com.evansloan.collectionlog.CollectionLogItem;
import com.evansloan.collectionlog.CollectionLogKillCount;
import com.evansloan.collectionlog.CollectionLogPage;
import com.evansloan.collectionlog.CollectionLogTab;
import com.evansloan.collectionlog.UserSettings;
import com.evansloan.collectionlog.util.CollectionLogDeserializer;
import com.evansloan.collectionlog.util.CollectionLogSerializer;
import com.evansloan.collectionlog.util.JsonUtils;
import com.evansloan.collectionlog.util.UserSettingsDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.ItemComposition;
import net.runelite.api.StructComposition;
import net.runelite.client.RuneLite;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CollectionLogManager {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogManager.class);
    private static final List<Integer> COLLECTION_LOG_TAB_STRUCT_IDS = ImmutableList.of((Object)471, (Object)472, (Object)473, (Object)474, (Object)475);
    private static final List<Integer> COLLECTION_LOG_TAB_ENUM_IDS = ImmutableList.of((Object)2103, (Object)2104, (Object)2105, (Object)2106, (Object)2107);
    private static final int COLLECTION_LOG_TAB_NAME_PARAM_ID = 682;
    private static final int COLLECTION_LOG_TAB_ENUM_PARAM_ID = 683;
    private static final int COLLECTION_LOG_PAGE_NAME_PARAM_ID = 689;
    private static final int COLLECTION_LOG_PAGE_ITEMS_ENUM_PARAM_ID = 690;
    private static final int COLLECTION_LOG_KILL_COUNT_SCRIPT_ID = 2735;
    private static final int COLLECTION_LOG_UNIQUE_OBTAINED_VARP_ID = 2943;
    private static final int COLLECTION_LOG_UNIQUE_ITEMS_VARP_ID = 2944;
    private static final File COLLECTION_LOG_DIR = new File(RuneLite.RUNELITE_DIR, "collectionlog");
    private static final File COLLECTION_LOG_SAVE_DATA_DIR = new File(COLLECTION_LOG_DIR, "data");
    private static final File COLLECTION_LOG_EXPORT_DIR = new File(COLLECTION_LOG_DIR, "exports");
    private static final Pattern COLLECTION_LOG_FILE_PATTERN = Pattern.compile("collectionlog-([\\w\\s-]+).json");
    private static final Map<Integer, Integer> ITEM_ID_MAP = new ImmutableMap.Builder().put((Object)10859, (Object)25617).put((Object)10877, (Object)25618).put((Object)10878, (Object)25619).put((Object)10879, (Object)25620).put((Object)10880, (Object)25621).put((Object)10881, (Object)25622).put((Object)10882, (Object)25623).put((Object)13273, (Object)25624).put((Object)12019, (Object)25627).put((Object)12020, (Object)25628).put((Object)24882, (Object)25629).put((Object)12854, (Object)25630).build();
    private final Map<String, CollectionLog> loadedCollectionLogs = new HashMap<String, CollectionLog>();
    private String username;
    private boolean isInitialized;
    private CollectionLog collectionLog;
    private UserSettings userSettings = new UserSettings();
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private JsonUtils jsonUtils;

    public void initCollectionLog() {
        CollectionLog saveFileCollectionLog = this.loadedCollectionLogs.get(this.username);
        boolean saveDataExists = saveFileCollectionLog != null;
        int totalObtained = 0;
        int totalItems = 0;
        HashMap<String, CollectionLogTab> collectionLogTabs = new HashMap<String, CollectionLogTab>();
        for (Integer structId : COLLECTION_LOG_TAB_STRUCT_IDS) {
            StructComposition tabStruct = this.client.getStructComposition(structId.intValue());
            String tabName = tabStruct.getStringValue(682);
            int tabEnumId = tabStruct.getIntValue(683);
            EnumComposition tabEnum = this.client.getEnum(tabEnumId);
            HashMap<String, CollectionLogPage> collectionLogPages = new HashMap<String, CollectionLogPage>();
            int[] nArray = tabEnum.getIntVals();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer pageStructId = nArray[i];
                StructComposition pageStruct = this.client.getStructComposition(pageStructId.intValue());
                String pageName = pageStruct.getStringValue(689);
                int pageItemsEnumId = pageStruct.getIntValue(690);
                EnumComposition pageItemsEnum = this.client.getEnum(pageItemsEnumId);
                ArrayList<CollectionLogItem> pageItems = new ArrayList<CollectionLogItem>();
                ArrayList<CollectionLogKillCount> pageKillCounts = new ArrayList<CollectionLogKillCount>();
                CollectionLogPage saveFilePage = null;
                if (saveDataExists) {
                    saveFilePage = saveFileCollectionLog.searchForPage(pageName);
                }
                int[] nArray2 = pageItemsEnum.getIntVals();
                int n2 = nArray2.length;
                for (int j = 0; j < n2; ++j) {
                    CollectionLogItem saveFileItem;
                    Integer pageItemId = nArray2[j];
                    ItemComposition itemComposition = this.itemManager.getItemComposition(pageItemId.intValue());
                    CollectionLogItem item = CollectionLogItem.fromItemComposition(itemComposition, pageItems.size());
                    if (ITEM_ID_MAP.containsKey(item.getId())) {
                        item.setId(ITEM_ID_MAP.get(item.getId()));
                    }
                    if (saveDataExists && saveFilePage != null && (saveFileItem = saveFilePage.getItemById(item.getId())) != null) {
                        item.setQuantity(saveFileItem.getQuantity());
                        item.setObtained(saveFileItem.isObtained());
                    }
                    pageItems.add(item);
                    ++totalItems;
                    if (!item.isObtained()) continue;
                    ++totalObtained;
                }
                this.client.runScript(new Object[]{2735, pageStruct.getId()});
                ArrayList<String> killCountStrings = new ArrayList<String>(Arrays.asList(Arrays.copyOfRange(this.client.getStringStack(), 0, 3)));
                Collections.reverse(killCountStrings);
                for (String killCountString : killCountStrings) {
                    CollectionLogKillCount saveFileKc;
                    if (killCountString.isEmpty()) continue;
                    CollectionLogKillCount killCount = CollectionLogKillCount.fromString(killCountString, pageKillCounts.size());
                    int killCountAmount = 0;
                    if (saveFilePage != null && (saveFileKc = saveFilePage.getKillCountByName(killCount.getName())) != null) {
                        killCountAmount = saveFileKc.getAmount();
                    }
                    killCount.setAmount(killCountAmount);
                    pageKillCounts.add(killCount);
                }
                boolean isUpdated = saveFilePage != null && saveFilePage.isUpdated();
                CollectionLogPage collectionLogPage = new CollectionLogPage(pageName, pageItems, pageKillCounts, isUpdated);
                collectionLogPages.put(pageName, collectionLogPage);
            }
            collectionLogTabs.put(tabName, new CollectionLogTab(tabName, collectionLogPages));
        }
        this.collectionLog = new CollectionLog(this.username, totalObtained, totalItems, this.client.getVarpValue(2943), this.client.getVarpValue(2944), collectionLogTabs);
        this.isInitialized = true;
    }

    private String getDataFilePath(String fileName) {
        File directory = new File(COLLECTION_LOG_SAVE_DATA_DIR + File.separator + this.username);
        directory.mkdirs();
        return directory + File.separator + fileName;
    }

    public String getCollectionLogFilePath() {
        String fileName = "collectionlog-" + this.username + ".json";
        return this.getDataFilePath(fileName);
    }

    public String getUserSettingsFilePath() {
        String fileName = "settings-" + this.username + ".json";
        return this.getDataFilePath(fileName);
    }

    public String getExportFilePath() {
        File directory = COLLECTION_LOG_EXPORT_DIR;
        String exportDate = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new Date());
        String fileName = exportDate + "-collectionlog-" + this.username + ".json";
        directory.mkdir();
        return directory + File.separator + fileName;
    }

    public void loadCollectionLogFiles(File directory) {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            Matcher matcher = COLLECTION_LOG_FILE_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            String fileUsername = matcher.group(1);
            CollectionLog loadedCollectionLog = this.jsonUtils.readJsonFile(file.getPath(), CollectionLog.class, new CollectionLogDeserializer());
            this.loadedCollectionLogs.put(fileUsername, loadedCollectionLog);
        }
    }

    public void loadCollectionLogFiles() {
        if (!COLLECTION_LOG_SAVE_DATA_DIR.exists() || !COLLECTION_LOG_SAVE_DATA_DIR.isDirectory()) {
            log.error("Directory: \"" + COLLECTION_LOG_DIR.getPath() + "\" does not exist");
            return;
        }
        File[] userDirectories = COLLECTION_LOG_SAVE_DATA_DIR.listFiles();
        if (userDirectories == null) {
            log.warn("No collection logs have been found");
            return;
        }
        for (File userDirectory : userDirectories) {
            this.loadCollectionLogFiles(userDirectory);
        }
    }

    public UserSettings loadUserSettingsFile() {
        return this.jsonUtils.readJsonFile(this.getUserSettingsFilePath(), UserSettings.class, new UserSettingsDeserializer());
    }

    public boolean saveCollectionLogFile(boolean isExport) {
        boolean isSaved;
        String filePath = this.getCollectionLogFilePath();
        if (isExport) {
            filePath = this.getExportFilePath();
        }
        if (isSaved = this.jsonUtils.writeJsonFile(filePath, this.collectionLog, new CollectionLogSerializer())) {
            this.loadedCollectionLogs.put(this.username, this.collectionLog);
        }
        return isSaved;
    }

    public boolean saveUserSettingsFile() {
        return this.jsonUtils.writeJsonFile(this.getUserSettingsFilePath(), this.userSettings);
    }

    public void deleteSaveFile() {
        String filePath = this.getCollectionLogFilePath();
        File savedData = new File(filePath);
        if (!savedData.delete()) {
            log.error("Unable to delete collection log save file: " + filePath);
            return;
        }
        this.loadedCollectionLogs.remove(this.username);
        this.isInitialized = false;
        this.collectionLog = null;
    }

    public void reset() {
        this.collectionLog = null;
        this.isInitialized = false;
        this.username = null;
        this.userSettings = new UserSettings();
    }

    public void updateUniqueCounts() {
        this.collectionLog.setUniqueObtained(this.client.getVarpValue(2943));
        this.collectionLog.setUniqueItems(this.client.getVarpValue(2944));
    }

    public void updateTotalItems() {
        int newTotal = 0;
        for (CollectionLogTab tab : this.collectionLog.getTabs().values()) {
            Collection<CollectionLogPage> pages = tab.getPages().values();
            newTotal += pages.stream().mapToInt(page -> page.getItems().size()).sum();
        }
        if (newTotal > this.collectionLog.getTotalItems()) {
            this.collectionLog.setTotalItems(newTotal);
        }
    }

    public CollectionLogTab getTabByName(String tabName) {
        return this.collectionLog.getTabs().get(tabName);
    }

    public CollectionLogPage getPageByName(String pageName) {
        return this.collectionLog.searchForPage(pageName);
    }

    public boolean updateObtainedItem(ItemStack itemStack) {
        if (!this.isInitialized) {
            return false;
        }
        boolean itemUpdated = false;
        for (CollectionLogTab tab : this.collectionLog.getTabs().values()) {
            for (CollectionLogPage page : tab.getPages().values()) {
                CollectionLogItem existingItem = page.getItemById(itemStack.getId());
                if (existingItem == null) continue;
                itemUpdated = true;
                existingItem.setQuantity(existingItem.getQuantity() + itemStack.getQuantity());
                existingItem.setObtained(true);
                this.collectionLog.setTotalObtained(this.collectionLog.getTotalObtained() + 1);
            }
        }
        if (itemUpdated) {
            this.collectionLog.setUniqueObtained(this.collectionLog.getUniqueObtained() + 1);
        }
        return false;
    }

    public JsonObject getCollectionLogJsonObject() {
        return this.jsonUtils.toJsonObject(this.collectionLog, new CollectionLogSerializer());
    }

    public JsonObject getUserSettingsJsonObject() {
        return this.jsonUtils.toJsonObject(this.userSettings);
    }

    public CollectionLogItem getRandomItem() {
        if (!this.isInitialized()) {
            return null;
        }
        int totalMissing = Math.min(this.collectionLog.getUniqueItems() - this.collectionLog.getTotalObtained(), 16);
        ArrayList<CollectionLogItem> items = new ArrayList<CollectionLogItem>(totalMissing);
        for (Map.Entry<String, CollectionLogTab> entry : this.collectionLog.getTabs().entrySet()) {
            CollectionLogTab collectionLogTab = entry.getValue();
            for (CollectionLogPage page : collectionLogTab.getPages().values()) {
                List<CollectionLogItem> pageItems = page.applyItemFilter("missing");
                items.addAll(pageItems);
            }
        }
        int index = RandomUtils.nextInt((int)0, (int)(items.size() - 1));
        return (CollectionLogItem)items.get(index);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public CollectionLog getCollectionLog() {
        return this.collectionLog;
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(UserSettings userSettings) {
        this.userSettings = userSettings;
    }
}

