/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="collectionlog")
public interface CollectionLogConfig
extends Config {
    public static final String PLUGIN_VERSION = "3.1.0";
    public static final Color DEFAULT_GREEN = new Color(13, 193, 13);
    public static final Color DEFAULT_ORANGE = new Color(255, 152, 31);
    public static final Color DEFAULT_RED = new Color(204, 44, 44);
    @ConfigSection(name="Appearance", description="Modify the appearance of the collection log", position=2)
    public static final String appearanceSection = "appearance";
    @ConfigSection(name="Exporting", description="Config options for exporting collection log data", position=4)
    public static final String exportingSection = "exporting";

    @ConfigItem(keyName="show_collection_log_panel", name="Show the collection log side panel", description="Show the collection log side panel", position=1)
    default public boolean showCollectionLogSidePanel() {
        return true;
    }

    @ConfigItem(keyName="display_unique_items", name="Display unique items", description="Display unique obtained collection log items", position=1, section="appearance")
    default public boolean displayUniqueItems() {
        return true;
    }

    @ConfigItem(keyName="display_total_items", name="Display total items", description="Display total obtained collection log items", position=2, section="appearance")
    default public boolean displayTotalItems() {
        return false;
    }

    @ConfigItem(keyName="display_as_percentage", name="Display item counts as percentage", description="Display collection log progress as a percentage", position=3, section="appearance")
    default public boolean displayAsPercentage() {
        return false;
    }

    @ConfigItem(keyName="highlight_incomplete_pages", name="Highlight incomplete pages", description="Highlight incomplete page titles", position=4, section="appearance")
    default public boolean highlightIncompletePages() {
        return false;
    }

    @Alpha
    @ConfigItem(keyName="highlight_color", name="Completed page highlight color", description="Sets the highlight color of completed pages", position=5, section="appearance")
    default public Color highlightColor() {
        return DEFAULT_GREEN;
    }

    @Alpha
    @ConfigItem(keyName="in_progress_highlight_color", name="In progress page highlight color", description="Sets the highlight color of page titles with at least one item obtained", position=6, section="appearance")
    default public Color inProgressHighlightColor() {
        return DEFAULT_ORANGE;
    }

    @Alpha
    @ConfigItem(keyName="empty_highlight_color", name="Empty page highlight color", description="Sets the highlight color of page titles with no items obtained", position=7, section="appearance")
    default public Color emptyHighlightColor() {
        return DEFAULT_RED;
    }

    @ConfigItem(keyName="show_quantity_for_all_obtained_items", name="Show quantity for all obtained items", description="Show the quantity of items where only one has been obtained", position=8, section="appearance")
    default public boolean showQuantityForAllObtainedItems() {
        return false;
    }

    @ConfigItem(keyName="upload_collection_log", name="Allow collectionlog.net connections", description="Allows collection log data to upload on log out and the chat command to pull data", position=1, section="exporting", warning="Enabling this option submits your IP address and account hash to a 3rd party website not controlled or verified by the RuneLite Developers.")
    default public boolean allowApiConnections() {
        return false;
    }

    @ConfigItem(keyName="export_chat_message", name="Chat message on export", description="Show exported file location in chat box on collection log export", position=2, section="exporting")
    default public boolean sendExportChatMessage() {
        return true;
    }
}

