/*
 * Decompiled with CFR 0.152.
 */
package com.evansloan.collectionlog;

import com.evansloan.collectionlog.CollectionLogPage;
import com.evansloan.collectionlog.CollectionLogTab;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CollectionLog {
    private final String username;
    private int totalObtained;
    private int totalItems;
    private int uniqueObtained;
    private int uniqueItems;
    private final Map<String, CollectionLogTab> tabs;

    public CollectionLogPage searchForPage(String pageName) {
        if (StringUtils.isEmpty((CharSequence)pageName)) {
            return null;
        }
        for (CollectionLogTab tab : this.tabs.values()) {
            for (CollectionLogPage page : tab.getPages().values()) {
                if (!pageName.equalsIgnoreCase(page.getName())) continue;
                return page;
            }
        }
        return null;
    }

    public CollectionLogPage randomPage() {
        int pageCount = 0;
        for (CollectionLogTab tab : this.tabs.values()) {
            pageCount += tab.getPages().size();
        }
        int randomIndex = (int)(Math.random() * (double)pageCount);
        int index = 0;
        for (CollectionLogTab tab : this.tabs.values()) {
            for (CollectionLogPage page : tab.getPages().values()) {
                if (index == randomIndex) {
                    return page;
                }
                ++index;
            }
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public int getTotalObtained() {
        return this.totalObtained;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getUniqueObtained() {
        return this.uniqueObtained;
    }

    public int getUniqueItems() {
        return this.uniqueItems;
    }

    public Map<String, CollectionLogTab> getTabs() {
        return this.tabs;
    }

    public CollectionLog(String username, int totalObtained, int totalItems, int uniqueObtained, int uniqueItems, Map<String, CollectionLogTab> tabs) {
        this.username = username;
        this.totalObtained = totalObtained;
        this.totalItems = totalItems;
        this.uniqueObtained = uniqueObtained;
        this.uniqueItems = uniqueItems;
        this.tabs = tabs;
    }

    public void setTotalObtained(int totalObtained) {
        this.totalObtained = totalObtained;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public void setUniqueObtained(int uniqueObtained) {
        this.uniqueObtained = uniqueObtained;
    }

    public void setUniqueItems(int uniqueItems) {
        this.uniqueItems = uniqueItems;
    }
}

