/*
 * Decompiled with CFR 0.152.
 */
package com.hitsounds;

import com.google.inject.Provides;
import com.hitsounds.HitSoundsConfig;
import com.hitsounds.enums.HitSoundEnum;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Hit Sounds", description="This plugin will send a custom sound on hitsplat", tags={"sound", "hitsplat", "max", "poison", "disease", "venom", "damage", "health"}, enabledByDefault=true)
public class HitSoundsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HitSoundsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private HitSoundsConfig config;
    @Inject
    private ClientThread clientThread;
    private Clip clip = null;
    private static final String BASE_DIRECTORY = System.getProperty("user.home") + "/.runelite/hitsounds/";
    public static final File NORMAL_FILE = new File(BASE_DIRECTORY, "normal.wav");
    public static final File MAX_FILE = new File(BASE_DIRECTORY, "max.wav");
    public static final File POISON_FILE = new File(BASE_DIRECTORY, "poison.wav");
    public static final File VENOM_FILE = new File(BASE_DIRECTORY, "venom.wav");
    public static final File DISEASE_FILE = new File(BASE_DIRECTORY, "disease.wav");
    public static final File MISS_FILE = new File(BASE_DIRECTORY, "miss.wav");
    public static final File HEALING_FILE = new File(BASE_DIRECTORY, "healing.wav");
    public static final File SHIELD_FILE = new File(BASE_DIRECTORY, "shield.wav");
    public static final File ARMOUR_FILE = new File(BASE_DIRECTORY, "armour.wav");
    public static final File CHARGE_FILE = new File(BASE_DIRECTORY, "charge.wav");
    public static final File UNCHARGE_FILE = new File(BASE_DIRECTORY, "uncharge.wav");
    public static final File OTHER_FILE = new File(BASE_DIRECTORY, "other.wav");
    private long lastClipMTime = -2L;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private static final long CLIP_MTIME_BUILTIN = -1L;

    protected void startUp() throws Exception {
        log.info("Hit Sounds started!");
    }

    protected void shutDown() throws Exception {
        log.info("Hit Sounds stopped!");
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        switch (hitsplatApplied.getHitsplat().getHitsplatType()) {
            case 17: {
                if (this.config.muteOthers()) break;
            }
            case 16: {
                if (!this.config.normalHitBoolean() || this.playCustomSound(HitSoundEnum.NORMAL)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.normalHitSound().getID().intValue()));
                break;
            }
            case 13: {
                if (this.config.muteOthers()) break;
            }
            case 12: {
                if (!this.config.missHitBoolean() || this.playCustomSound(HitSoundEnum.MISS)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.missHitSound().getID().intValue()));
                break;
            }
            case 43: {
                if (!this.config.maxHitBoolean() || this.playCustomSound(HitSoundEnum.MAX)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.maxHitSound().getID().intValue()));
                break;
            }
            case 4: {
                if (!this.config.diseaseHitBoolean() || this.playCustomSound(HitSoundEnum.DISEASE)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.diseaseHitSound().getID().intValue()));
                break;
            }
            case 5: {
                if (!this.config.venomHitBoolean() || this.playCustomSound(HitSoundEnum.VENOM)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.venomHitSound().getID().intValue()));
                break;
            }
            case 6: {
                if (!this.config.healingHitBoolean() || this.playCustomSound(HitSoundEnum.HEALING)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.healingHitSound().getID().intValue()));
                break;
            }
            case 2: {
                if (!this.config.poisonHitBoolean() || this.playCustomSound(HitSoundEnum.POISON)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.poisonHitSound().getID().intValue()));
                break;
            }
            case 19: {
                if (this.config.muteOthers()) break;
            }
            case 18: {
                if (!this.config.shieldHitBoolean() || this.playCustomSound(HitSoundEnum.SHIELD)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.shieldHitSound().getID().intValue()));
                break;
            }
            case 44: {
                if (!this.config.shieldHitBoolean() || !this.config.maxHitBoolean() || this.playCustomSound(HitSoundEnum.SHIELD)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.shieldHitSound().getID().intValue()));
                break;
            }
            case 25: {
                if (this.config.muteOthers()) break;
            }
            case 24: {
                if (!this.config.unchargeHitBoolean() || this.playCustomSound(HitSoundEnum.UNCHARGE)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.unchargeHitSound().getID().intValue()));
                break;
            }
            case 47: {
                if (!this.config.unchargeHitBoolean() || !this.config.maxHitBoolean() || this.playCustomSound(HitSoundEnum.UNCHARGE)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.unchargeHitSound().getID().intValue()));
                break;
            }
            case 23: {
                if (this.config.muteOthers()) break;
            }
            case 22: {
                if (!this.config.chargeHitBoolean() || this.playCustomSound(HitSoundEnum.CHARGE)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.chargeHitSound().getID().intValue()));
                break;
            }
            case 46: {
                if (!this.config.chargeHitBoolean() || !this.config.maxHitBoolean() || this.playCustomSound(HitSoundEnum.CHARGE)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.chargeHitSound().getID().intValue()));
                break;
            }
            case 21: {
                if (this.config.muteOthers()) break;
            }
            case 20: {
                if (!this.config.armourHitBoolean() || this.playCustomSound(HitSoundEnum.ARMOUR)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.armourHitSound().getID().intValue()));
                break;
            }
            case 45: {
                if (!this.config.armourHitBoolean() || !this.config.maxHitBoolean() || this.playCustomSound(HitSoundEnum.ARMOUR)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.armourHitSound().getID().intValue()));
                break;
            }
            default: {
                if (!this.config.otherHitBoolean() || this.playCustomSound(HitSoundEnum.OTHER)) break;
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.otherHitSound().getID().intValue()));
            }
        }
    }

    private synchronized boolean playCustomSound(HitSoundEnum hitSoundEnum) {
        long currentMTime;
        long l = currentMTime = hitSoundEnum.getFile().exists() ? hitSoundEnum.getFile().lastModified() : -1L;
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                log.warn("Unable to play sound", (Throwable)e);
                return false;
            }
            this.lastClipMTime = currentMTime;
            if (!this.tryLoadCustomSound(hitSoundEnum)) {
                return false;
            }
        }
        this.clip.loop(1);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean tryLoadCustomSound(HitSoundEnum hitSoundEnum) {
        if (hitSoundEnum.getFile().exists()) {
            try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(hitSoundEnum.getFile()));){
                boolean bl;
                block14: {
                    AudioInputStream sound = AudioSystem.getAudioInputStream(fileStream);
                    try {
                        this.clip.open(sound);
                        bl = true;
                        if (sound == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (sound != null) {
                            try {
                                sound.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    sound.close();
                }
                return bl;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                log.warn("Unable to load sound", (Throwable)e);
            }
        }
        return false;
    }

    @Provides
    HitSoundsConfig provideConfig(ConfigManager configManager) {
        return (HitSoundsConfig)configManager.getConfig(HitSoundsConfig.class);
    }
}

