/*
 * Decompiled with CFR 0.152.
 */
package com.FriendsExporter;

import com.FriendsExporter.FriendsExporterConfig;
import com.FriendsExporter.LineLeads;
import com.FriendsExporter.PlayerListItem;
import com.google.inject.Provides;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.Ignore;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Friends Exporter")
public class FriendsExporterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FriendsExporterPlugin.class);
    private static final String EXPORT = "Export";
    public static final File EXPORT_DIR = new File(RuneLite.RUNELITE_DIR, "player-exports");
    private static final WidgetMenuOption FIXED_FRIENDS_LIST = new WidgetMenuOption("Export", "Friends List", WidgetInfo.FIXED_VIEWPORT_FRIENDS_TAB);
    private static final WidgetMenuOption RESIZABLE_FRIENDS_LIST = new WidgetMenuOption("Export", "Friends List", WidgetInfo.RESIZABLE_VIEWPORT_FRIENDS_TAB);
    private static final WidgetMenuOption MODERN_FRIENDS_LIST = new WidgetMenuOption("Export", "Friends List", 10747943);
    private static final WidgetMenuOption FIXED_IGNORE_LIST = new WidgetMenuOption("Export", "Ignore List", WidgetInfo.FIXED_VIEWPORT_FRIENDS_TAB);
    private static final WidgetMenuOption RESIZABLE_IGNORE_LIST = new WidgetMenuOption("Export", "Ignore List", WidgetInfo.RESIZABLE_VIEWPORT_FRIENDS_TAB);
    private static final WidgetMenuOption MODERN_IGNORE_LIST = new WidgetMenuOption("Export", "Ignore List", 10747943);
    private static final WidgetMenuOption CHAT_CHANNEL_LIST = new WidgetMenuOption("Export", "Current Members", 46333955);
    private static final WidgetMenuOption CHAT_CHANNEL_RANKS = new WidgetMenuOption("Export", "Rank List", 46333955);
    private static final WidgetMenuOption CLAN_CHAT_MEMBERS = new WidgetMenuOption("Export", "Online Clan Members", 46333956);
    private static final WidgetMenuOption CLAN_CHAT_JOINS = new WidgetMenuOption("Export", "All Clan Members", 46333956);
    private static final WidgetMenuOption CLAN_CHAT_BANS = new WidgetMenuOption("Export", "Clan Bans", 46333956);
    private static final WidgetMenuOption CLAN_CHAT_EVENTS = new WidgetMenuOption("Export", "Clan Events", 46333956);
    private static final WidgetMenuOption GUEST_CLAN_CHAT_TITLES = new WidgetMenuOption("Export", "Guest Clan Members", 46333957);
    private static final WidgetMenuOption FIXED_EMOTE = new WidgetMenuOption("Export", "Local Players", WidgetInfo.FIXED_VIEWPORT_EMOTES_TAB);
    private static final WidgetMenuOption RESIZABLE_EMOTE = new WidgetMenuOption("Export", "Local Players", WidgetInfo.RESIZABLE_VIEWPORT_EMOTES_TAB);
    private static final WidgetMenuOption MODERN_EMOTE = new WidgetMenuOption("Export", "Local Players", 10747945);
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private boolean chatChannel = false;
    private boolean wid = false;
    @Inject
    private Client client;
    @Inject
    private MenuManager menuManager;
    @Inject
    private FriendsExporterConfig config;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        EXPORT_DIR.mkdirs();
        this.refreshShiftClickCustomizationMenus();
    }

    protected void shutDown() throws Exception {
        this.removeShiftClickCustomizationMenus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String format(Date date) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return TIME_FORMAT.format(date);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) throws Exception {
        this.refreshShiftClickCustomizationMenus();
    }

    private void refreshShiftClickCustomizationMenus() {
        this.removeShiftClickCustomizationMenus();
        this.menuManager.addManagedCustomMenu(FIXED_FRIENDS_LIST, e -> this.exportFriendsList());
        this.menuManager.addManagedCustomMenu(RESIZABLE_FRIENDS_LIST, e -> this.exportFriendsList());
        this.menuManager.addManagedCustomMenu(MODERN_FRIENDS_LIST, e -> this.exportFriendsList());
        this.menuManager.addManagedCustomMenu(FIXED_IGNORE_LIST, e -> this.exportIgnoreList());
        this.menuManager.addManagedCustomMenu(RESIZABLE_IGNORE_LIST, e -> this.exportIgnoreList());
        this.menuManager.addManagedCustomMenu(MODERN_IGNORE_LIST, e -> this.exportIgnoreList());
        this.menuManager.addManagedCustomMenu(CHAT_CHANNEL_LIST, e -> this.exportChatChannelMembers());
        this.menuManager.addManagedCustomMenu(CHAT_CHANNEL_RANKS, e -> this.exportChatChannelRankList());
        this.menuManager.addManagedCustomMenu(FIXED_EMOTE, e -> this.exportLocalPlayers());
        this.menuManager.addManagedCustomMenu(RESIZABLE_EMOTE, e -> this.exportLocalPlayers());
        this.menuManager.addManagedCustomMenu(MODERN_EMOTE, e -> this.exportLocalPlayers());
        this.menuManager.addManagedCustomMenu(CLAN_CHAT_MEMBERS, e -> this.exportOnlineClanMembers());
        this.menuManager.addManagedCustomMenu(CLAN_CHAT_JOINS, e -> this.exportAllClanMembers());
        this.menuManager.addManagedCustomMenu(CLAN_CHAT_BANS, e -> this.exportClanBanList());
        this.menuManager.addManagedCustomMenu(CLAN_CHAT_EVENTS, e -> this.exportClanEventList());
    }

    private void removeShiftClickCustomizationMenus() {
        this.menuManager.removeManagedCustomMenu(FIXED_FRIENDS_LIST);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_FRIENDS_LIST);
        this.menuManager.removeManagedCustomMenu(MODERN_FRIENDS_LIST);
        this.menuManager.removeManagedCustomMenu(FIXED_IGNORE_LIST);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_IGNORE_LIST);
        this.menuManager.removeManagedCustomMenu(MODERN_IGNORE_LIST);
        this.menuManager.removeManagedCustomMenu(CHAT_CHANNEL_LIST);
        this.menuManager.removeManagedCustomMenu(CHAT_CHANNEL_RANKS);
        this.menuManager.removeManagedCustomMenu(FIXED_EMOTE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_EMOTE);
        this.menuManager.removeManagedCustomMenu(MODERN_EMOTE);
        this.menuManager.removeManagedCustomMenu(CLAN_CHAT_MEMBERS);
        this.menuManager.removeManagedCustomMenu(CLAN_CHAT_JOINS);
        this.menuManager.removeManagedCustomMenu(CLAN_CHAT_BANS);
        this.menuManager.removeManagedCustomMenu(CLAN_CHAT_EVENTS);
    }

    private void exportFriendsList() {
        String filename = this.client.getLocalPlayer().getName() + " Friends " + FriendsExporterPlugin.format(new Date()) + ".txt";
        Friend[] array = (Friend[])this.client.getFriendContainer().getMembers();
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 0; i != ((Friend[])this.client.getFriendContainer().getMembers()).length; ++i) {
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(array[i].getName());
            if (!StringUtils.isEmpty((CharSequence)array[i].getPrevName()) && this.config.includePrevName()) {
                playerListItem.setPreviousName(array[i].getPrevName());
            }
            if (this.config.includeNote()) {
                playerListItem.setNote(this.configManager.getConfiguration("friendNotes", "note_" + playerListItem.getName()));
            }
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportIgnoreList() {
        String filename = this.client.getLocalPlayer().getName() + " Ignore " + FriendsExporterPlugin.format(new Date()) + ".txt";
        Ignore[] array = (Ignore[])this.client.getIgnoreContainer().getMembers();
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 0; i != array.length; ++i) {
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(array[i].getName());
            if (!StringUtils.isEmpty((CharSequence)array[i].getPrevName()) && this.config.includePrevName()) {
                playerListItem.setPreviousName(array[i].getPrevName());
            }
            if (this.config.includeNote()) {
                playerListItem.setNote(this.configManager.getConfiguration("friendNotes", "note_" + playerListItem.getName()));
            }
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportChatChannelRankList() {
        String filename = this.client.getLocalPlayer().getName() + " Ranks " + FriendsExporterPlugin.format(new Date()) + ".txt";
        Friend[] memberArray = (Friend[])this.client.getFriendContainer().getMembers();
        Widget temp = this.client.getWidget(94, 28);
        Widget[] temp2 = temp.getChildren();
        if (!this.chatChannel) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Please open Chat-channel Setup found in the Chat-channel tab to export this list.", "");
            return;
        }
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 0; i < temp2.length / 4; ++i) {
            String rank = temp2[i * 4 + 1].getText();
            if (rank.equals("Not ranked") && !this.config.showUnranked()) continue;
            String prevName = "";
            for (int j = 0; j < memberArray.length; ++j) {
                String friendName = memberArray[j].getName();
                if (!friendName.equals(temp2[i * 4 + 2].getText())) continue;
                if (StringUtils.isEmpty((CharSequence)memberArray[j].getPrevName()) || !this.config.includePrevName()) break;
                prevName = memberArray[j].getPrevName();
                break;
            }
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(temp2[i * 4 + 2].getText());
            playerListItem.setPreviousName(prevName);
            playerListItem.setRank(!rank.equals("Not ranked") ? rank : "No Rank");
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportChatChannelMembers() {
        String filename = this.client.getLocalPlayer().getName() + " Members " + FriendsExporterPlugin.format(new Date()) + ".txt";
        if (this.client.getFriendsChatManager() == null) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Please join a Chat-channel to export this list.", "");
            return;
        }
        FriendsChatMember[] array = (FriendsChatMember[])this.client.getFriendsChatManager().getMembers();
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 0; i != ((FriendsChatMember[])this.client.getFriendsChatManager().getMembers()).length; ++i) {
            String friendName = array[i].getName();
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(friendName);
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportLocalPlayers() {
        String filename = this.client.getLocalPlayer().getName() + " Local " + FriendsExporterPlugin.format(new Date()) + ".txt";
        List array = this.client.getPlayers();
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 0; i != array.size(); ++i) {
            String localName = ((Player)array.get(i)).getName();
            if (localName.matches(this.client.getLocalPlayer().getName())) continue;
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(localName);
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportOnlineClanMembers() {
        String filename = this.client.getClanChannel().getName() + " Members " + FriendsExporterPlugin.format(new Date()) + ".txt";
        List<PlayerListItem> playerList = this.client.getClanChannel().getMembers().stream().sorted(Comparator.comparing(ClanChannelMember::getRank).reversed().thenComparing(ClanChannelMember::getName, String::compareToIgnoreCase)).map(clanmate -> {
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(clanmate.getName());
            playerListItem.setRank(this.client.getClanSettings().titleForRank(clanmate.getRank()).getName());
            return playerListItem;
        }).collect(Collectors.toList());
        this.exportList(filename, playerList);
    }

    private void exportAllClanMembers() {
        String filename = this.client.getClanChannel().getName() + " Full Member List " + FriendsExporterPlugin.format(new Date()) + ".txt";
        Widget clanListWidget = this.client.getWidget(693, 10);
        if (clanListWidget == null) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Please open clan settings and navigate to the Members tab.", "");
            return;
        }
        Widget[] clanList = clanListWidget.getChildren();
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 1; i < clanList.length; i += 3) {
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(clanList[i].getText());
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportClanBanList() {
        String player;
        String filename = this.client.getClanChannel().getName() + " Ban List " + FriendsExporterPlugin.format(new Date()) + ".txt";
        Widget clanBanListWidget = this.client.getWidget(689, 6);
        if (clanBanListWidget == null) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Please open clan settings and navigate to the Bans tab.", "");
            return;
        }
        int banSize = clanBanListWidget.getDynamicChildren().length / 2;
        ArrayList<PlayerListItem> playerList = new ArrayList<PlayerListItem>();
        for (int i = 0; i != banSize && !(player = this.client.getWidget(689, 6).getDynamicChildren()[500 + i].getText()).isEmpty(); ++i) {
            PlayerListItem playerListItem = new PlayerListItem();
            playerListItem.setName(player);
            playerList.add(playerListItem);
        }
        this.exportList(filename, playerList);
    }

    private void exportClanEventList() {
        String filePath = EXPORT_DIR + "\\" + this.client.getClanChannel().getName() + " Events " + FriendsExporterPlugin.format(new Date()) + ".txt";
        try {
            this.purgeList(filePath);
            Widget clanEventWidget = this.client.getWidget(703, 11);
            if (clanEventWidget == null) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Please open clan settings and navigate to the Events tab.", "");
                return;
            }
            int eventSize = clanEventWidget.getDynamicChildren().length;
            FileWriter writer = new FileWriter(filePath, true);
            for (int i = 0; i != eventSize; ++i) {
                String world = Text.removeTags((String)this.client.getWidget(703, 11).getDynamicChildren()[i].getText());
                String startDate = Text.removeTags((String)this.client.getWidget(703, 12).getDynamicChildren()[i].getText());
                String startTime = Text.removeTags((String)this.client.getWidget(703, 13).getDynamicChildren()[i].getText());
                String duration = Text.removeTags((String)this.client.getWidget(703, 14).getDynamicChildren()[i].getText());
                String type = Text.removeTags((String)this.client.getWidget(703, 15).getDynamicChildren()[i].getText());
                String focus = Text.removeTags((String)this.client.getWidget(703, 16).getDynamicChildren()[i].getText());
                String subType = Text.removeTags((String)this.client.getWidget(703, 17).getDynamicChildren()[i].getText());
                String ranks = Text.removeTags((String)this.client.getWidget(703, 19).getDynamicChildren()[i].getText());
                StringBuilder exportString = new StringBuilder();
                if (!this.config.lineLeads().equals((Object)LineLeads.None)) {
                    exportString.append(i + this.config.lineLeads().getPunctuation());
                }
                exportString.append(focus + this.config.getSeparator() + type + this.config.getSeparator() + subType + this.config.getSeparator() + startDate + " " + startTime + this.config.getSeparator() + duration + this.config.getSeparator() + world + this.config.getSeparator() + ranks);
                writer.write(exportString + "\r\n");
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to create file: " + filePath + ". Stack trace: " + e);
        }
    }

    private void exportList(String filename, List<PlayerListItem> playerList) {
        String filePath = EXPORT_DIR + "\\" + filename;
        this.purgeList(filePath);
        try {
            FileWriter writer = new FileWriter(filePath, true);
            for (int i = 0; i < playerList.size(); ++i) {
                writer.write(this.getExportLineForPlayer(i + 1, playerList.get(i)) + "\r\n");
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to create file: " + filePath + ". Stack trace: " + e);
        }
    }

    private void purgeList(String filename) {
        File purge = new File(filename);
        purge.delete();
    }

    private String getExportLineForPlayer(int num, PlayerListItem playerListItem) {
        String separator = this.config.getSeparator();
        StringBuilder exportString = new StringBuilder();
        if (!this.config.lineLeads().equals((Object)LineLeads.None)) {
            exportString.append(num + this.config.lineLeads().getPunctuation());
        }
        if (!playerListItem.getRank().isEmpty()) {
            exportString.append(playerListItem.getRank() + separator);
        }
        exportString.append(playerListItem.getName());
        if (!StringUtils.isEmpty((CharSequence)playerListItem.getPreviousName())) {
            exportString.append(separator + playerListItem.getPreviousName());
        }
        if (!StringUtils.isEmpty((CharSequence)playerListItem.getNote())) {
            exportString.append(separator + playerListItem.getNote());
        }
        return exportString.toString();
    }

    @Provides
    FriendsExporterConfig provideConfig(ConfigManager configManager) {
        return (FriendsExporterConfig)configManager.getConfig(FriendsExporterConfig.class);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widget) {
        if (widget.getGroupId() == 94) {
            this.wid = true;
            this.chatChannel = true;
        }
        Widget temp = this.client.getWidget(widget.getGroupId(), 0);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getWidget(94, 28) == null) {
            this.chatChannel = false;
            this.refreshShiftClickCustomizationMenus();
        }
        if (this.wid) {
            this.refreshShiftClickCustomizationMenus();
            this.wid = false;
        }
    }
}

