/*
 * Decompiled with CFR 0.152.
 */
package dev.wannaknow.clanusers;

import dev.wannaknow.clanusers.ClanUsersPanel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.FriendsChatRank;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.clan.ClanSettings;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.StringUtils;

@PluginDescriptor(name="Copy FC/CC users to clipboard", description="Copy FriendsChat/ClanChat users to clipboard", tags={"clan", "friends", "clipboard", "names", "log"})
public class ClanUsersPlugin
extends Plugin {
    private static final String PLUGIN_NAME = "Copy clan usernames";
    private static final String ICON_FILE = "users.png";
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    private ClanUsersPanel panel;
    private NavigationButton navButton;

    protected void startUp() throws Exception {
        this.panel = new ClanUsersPanel(this);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)ICON_FILE);
        this.navButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public void copyRankedFriendsChatUsernames() {
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager != null) {
            Object names = "";
            for (FriendsChatMember member : (FriendsChatMember[])friendsChatManager.getMembers()) {
                if (member.getRank() == FriendsChatRank.UNRANKED) continue;
                names = (String)names + member.getName() + "\n";
            }
            this.copyStringToClipboard((String)names);
        } else {
            this.panel.getCopiedNames().setText("Not in a FriendsChat.");
        }
    }

    public void copyFriendsChatUsernames() {
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager != null) {
            Object names = "";
            for (FriendsChatMember member : (FriendsChatMember[])friendsChatManager.getMembers()) {
                names = (String)names + member.getName() + "\n";
            }
            this.copyStringToClipboard((String)names);
        }
    }

    public void copyOnlineClanChatUsernames() {
        ClanChannel clanChannel = this.client.getClanChannel();
        if (clanChannel != null) {
            Object names = "";
            for (ClanChannelMember member : clanChannel.getMembers()) {
                names = (String)names + member.getName() + "\n";
            }
            this.copyStringToClipboard((String)names);
        } else {
            this.panel.getCopiedNames().setText("Not in a ClanChat.");
        }
    }

    public void copyOnlineRankedClanChatUsernames() {
        ClanChannel clanChannel = this.client.getClanChannel();
        if (clanChannel != null) {
            Object names = "";
            for (ClanChannelMember member : clanChannel.getMembers()) {
                if (member.getRank() == ClanRank.GUEST) continue;
                names = (String)names + member.getName() + "\n";
            }
            this.copyStringToClipboard((String)names);
        } else {
            this.panel.getCopiedNames().setText("Not in a ClanChat.");
        }
    }

    public void copyClanChatUsernames() {
        ClanSettings clanChannel = this.client.getClanSettings();
        if (clanChannel != null) {
            Object names = "";
            for (ClanMember member : clanChannel.getMembers()) {
                names = (String)names + member.getName() + "\n";
            }
            this.copyStringToClipboard((String)names);
        } else {
            this.panel.getCopiedNames().setText("Not in a ClanChat.");
        }
    }

    public void copyGuestChatUsernames() {
        ClanSettings clanChannel = this.client.getGuestClanSettings();
        if (clanChannel != null) {
            Object names = "";
            for (ClanMember member : clanChannel.getMembers()) {
                names = (String)names + member.getName() + "\n";
            }
            this.copyStringToClipboard((String)names);
        } else {
            this.panel.getCopiedNames().setText("Not in a ClanChat.");
        }
    }

    private void copyStringToClipboard(String copy) {
        if (StringUtils.isBlank((CharSequence)(copy = copy.replaceAll("\\p{Zs}+", " ")))) {
            this.panel.getCopiedNames().setText("No names found.");
        } else {
            this.panel.getCopiedNames().setText(copy);
            StringSelection stringSelection = new StringSelection(copy);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }
}

