/*
 * Decompiled with CFR 0.152.
 */
package com.NameChangeDetector;

import com.NameChangeDetector.WOMNameChangesModel;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NameChangeManager {
    private static final Logger log = LoggerFactory.getLogger(NameChangeManager.class);
    private final OkHttpClient client;
    private final ClientThread clientThread;
    private static final Type typeToken = new TypeToken<List<WOMNameChangesModel>>(){}.getType();
    private String wiseOldManBaseApiUrl = "https://api.wiseoldman.net";
    private String crystalMathBaseApiUrl = "https://crystalmathlabs.com";
    private List<String> crystalMathLabResponses = ImmutableList.of((Object)"-1", (Object)"-2", (Object)"-3", (Object)"-4");

    @Inject
    public NameChangeManager(OkHttpClient client, ClientThread clientThread) {
        this.client = client;
        this.clientThread = clientThread;
    }

    public List<String> getPreviousNames(String rsn) {
        String cleanRsn = Text.removeTags((String)Text.toJagexName((String)rsn)).toLowerCase();
        ArrayList<String> previousNames = new ArrayList<String>();
        List<String> namesFromWOM = this.getPreviousNamesFromWOM(cleanRsn);
        previousNames.addAll(namesFromWOM);
        String nameChangeFromMathLabs = this.getPreviousNamesFromMathLabs(cleanRsn);
        if (!previousNames.contains(nameChangeFromMathLabs) && nameChangeFromMathLabs != "") {
            previousNames.add(nameChangeFromMathLabs);
        }
        return previousNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getPreviousNamesFromWOM(String rsn) {
        String url = this.wiseOldManBaseApiUrl + "/players/username/" + rsn + "/names";
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) return Collections.emptyList();
            List nameChanges = (List)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(response.body().byteStream()), typeToken);
            List<String> list = nameChanges.stream().map(WOMNameChangesModel::getOldName).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            log.error("failed to check Wise Old Man for name changes: {}", (Object)e.toString());
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPreviousNamesFromMathLabs(String rsn) {
        String url = this.crystalMathBaseApiUrl + "/tracker/api.php?type=previousname&player=" + rsn;
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) return "";
            String stringResponse = response.body().string();
            if (this.crystalMathLabResponses.contains(stringResponse)) {
                String string = "";
                return string;
            }
            String string = stringResponse;
            return string;
        }
        catch (IOException e) {
            log.error("failed to check Crystal Math Labs for name changes: {}", (Object)e.toString());
        }
        return "";
    }
}

