/*
 * Decompiled with CFR 0.152.
 */
package com.NameChangeDetector;

import com.NameChangeDetector.NameChangeManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Name Change Detector")
public class NameChangeDetectorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NameChangeDetectorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private NameChangeManager nameChangeManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ScheduledExecutorService executor;
    private static final String INVESTIGATE = "Previous names";
    private static final List<Integer> MENU_WIDGET_IDS = ImmutableList.of((Object)WidgetInfo.FRIENDS_CHAT.getGroupId(), (Object)WidgetInfo.CHATBOX.getGroupId(), (Object)WidgetInfo.RAIDING_PARTY.getGroupId(), (Object)WidgetInfo.IGNORE_LIST.getGroupId(), (Object)WidgetInfo.CLAN_MEMBER_LIST.getGroupId());
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message", (Object)"Add ignore", (Object)"Remove friend", (Object)"Delete", (Object)"Kick", (Object)"Reject");

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int groupId = WidgetInfo.TO_GROUP((int)event.getActionParam1());
        String option = event.getOption();
        if (!MENU_WIDGET_IDS.contains(groupId) || !AFTER_OPTIONS.contains((Object)option)) {
            return;
        }
        for (MenuEntry me : this.client.getMenuEntries()) {
            if (!INVESTIGATE.equals(me.getOption())) continue;
            return;
        }
        this.client.createMenuEntry(-1).setOption(INVESTIGATE).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier());
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int groupId = WidgetInfo.TO_GROUP((int)event.getWidgetId());
        String option = event.getMenuOption();
        MenuAction action = event.getMenuAction();
        if ((action == MenuAction.RUNELITE || action == MenuAction.RUNELITE_PLAYER) && option.equals(INVESTIGATE)) {
            Player player;
            String target = action == MenuAction.RUNELITE_PLAYER ? ((player = this.client.getCachedPlayers()[event.getId()]) != null ? player.getName() : null) : Text.removeTags((String)event.getMenuTarget());
            if (target != null) {
                this.executor.execute(() -> {
                    List<String> names = this.nameChangeManager.getPreviousNames(target);
                    this.printPreviousNames(target, names);
                });
            }
        }
    }

    private void printPreviousNames(String currentRsn, List<String> names) {
        currentRsn = Text.toJagexName((String)currentRsn);
        ChatMessageBuilder response = new ChatMessageBuilder();
        long countOfNames = names.stream().count();
        if (countOfNames > 0L) {
            response.append(ChatColorType.HIGHLIGHT).append(currentRsn).append(ChatColorType.NORMAL);
            response.append(" has also gone by: ").append(ChatColorType.HIGHLIGHT);
            int timesRan = 1;
            boolean whoCaresAboutAOxfordComma = false;
            for (String name : names) {
                if (whoCaresAboutAOxfordComma && (long)timesRan == countOfNames) {
                    response.append(ChatColorType.NORMAL).append(" and ").append(ChatColorType.HIGHLIGHT);
                }
                response.append(name);
                if ((long)timesRan != countOfNames) {
                    response.append(ChatColorType.NORMAL).append(", ").append(ChatColorType.HIGHLIGHT);
                }
                if ((long)(timesRan + 1) == countOfNames) {
                    whoCaresAboutAOxfordComma = true;
                }
                ++timesRan;
            }
        } else {
            response.append("No previous names were found for ").append(ChatColorType.HIGHLIGHT);
            response.append(currentRsn);
        }
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(response.build()).build());
    }
}

