/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.ClientAntiDragConfig;
import com.google.inject.Provides;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Client Anti Drag", description="Prevent dragging the client unless moved more more than X milliseconds(custom set in config)")
public class ClientAntiDragPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClientAntiDragPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientAntiDragConfig config;
    Instant lastFrameMovement = null;
    AWTEventListener titleListener = null;

    protected void startUp() throws Exception {
        this.titleListener = event -> {
            if (!(event.getSource() instanceof SubstanceTitlePane)) {
                return;
            }
            switch (event.getID()) {
                case 501: {
                    this.lastFrameMovement = Instant.now();
                    break;
                }
                case 506: {
                    if (this.lastFrameMovement == null || TimeUnit.NANOSECONDS.toMillis(Duration.between(this.lastFrameMovement, Instant.now()).toNanos()) > (long)this.config.dragDelay()) break;
                    ((MouseEvent)event).consume();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.titleListener, 48L);
    }

    protected void shutDown() throws Exception {
        this.lastFrameMovement = null;
        if (this.titleListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.titleListener);
            this.titleListener = null;
        }
    }

    @Provides
    ClientAntiDragConfig provideConfig(ConfigManager configManager) {
        return (ClientAntiDragConfig)configManager.getConfig(ClientAntiDragConfig.class);
    }
}

